/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.world.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.items.ArtifactItem;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.registry.LootModifierRegistry;
import it.mralxart.etheria.world.loot.data.LootData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ArtifactsLootModifier
extends LootModifier {
    public static final Codec<ArtifactsLootModifier> CODEC = RecordCodecBuilder.create(instance -> ArtifactsLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ArtifactsLootModifier::new));

    public ArtifactsLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String lootId = context.getQueriedLootTableId().toString();
        Random random = new Random();
        for (RegistryObject item : ItemRegistry.ITEMS.getEntries().stream().filter(itemRegistryObject -> itemRegistryObject.isPresent() && itemRegistryObject.get() instanceof ArtifactItem).toList()) {
            LootData data = ArtifactStatsManager.ARTIFACT_LOOT.get((ArtifactItem)item.get());
            if (data == null) continue;
            for (Map.Entry<String, List<Float>> lootData : data.getLootCollection().entrySet()) {
                boolean matches;
                try {
                    matches = lootId.matches(lootData.getKey());
                }
                catch (PatternSyntaxException e) {
                    matches = lootId.equals(lootData.getKey());
                }
                if (!matches) continue;
                for (Float chance : lootData.getValue()) {
                    if (!(random.nextFloat() <= chance.floatValue())) continue;
                    generatedLoot.add((Object)new ItemStack((ItemLike)item.get()));
                }
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)LootModifierRegistry.ARTIFACTS.get();
    }
}

