/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.world.loot.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LootData {
    private Map<String, List<Float>> lootCollection = new HashMap<String, List<Float>>();

    public LootData addData(String data, float chance) {
        this.lootCollection.computeIfAbsent(data, k -> new ArrayList()).add(Float.valueOf(chance));
        return this;
    }

    public LootData addData(String folder, String keyword, float chance) {
        String pattern = LootData.createPattern(folder, keyword);
        return this.addData(pattern, chance);
    }

    public static String createPattern(String folder, String keyword) {
        String prefix = "[a-zA-Z0-9_]+:chests/";
        String between = "[a-zA-Z0-9_/]*";
        return prefix + folder + between + keyword + between;
    }

    public Map<String, List<Float>> getLootCollection() {
        return this.lootCollection;
    }

    public void setLootCollection(Map<String, List<Float>> lootCollection) {
        this.lootCollection = lootCollection;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootData)) {
            return false;
        }
        LootData other = (LootData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<Float>> this$lootCollection = this.getLootCollection();
        Map<String, List<Float>> other$lootCollection = other.getLootCollection();
        return !(this$lootCollection == null ? other$lootCollection != null : !((Object)this$lootCollection).equals(other$lootCollection));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LootData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<Float>> $lootCollection = this.getLootCollection();
        result = result * 59 + ($lootCollection == null ? 43 : ((Object)$lootCollection).hashCode());
        return result;
    }

    public String toString() {
        return "LootData(lootCollection=" + this.getLootCollection() + ")";
    }
}

