/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinToolOutcome;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinToolPixelSelection;
import traben.entity_texture_features.config.screens.skin.ETFScreenOldCompat;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.player.ETFPlayerTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinTool
extends ETFScreenOldCompat {
    private static final ResourceLocation APPLY_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_printout.png");
    private static final ResourceLocation REMOVE_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_remove.png");
    private static final ResourceLocation WHOLE_FACE_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_whole_face.png");
    private static final ResourceLocation SMALL_EYE_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_small_eyes.png");
    private static final ResourceLocation BOXES_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_orange_areas.png");
    public Boolean originalEnableBlinking;
    public ETFPlayerTexture thisETFPlayerTexture = null;
    public NativeImage currentEditorSkin = null;
    public boolean flipView = false;
    Button printSkinFileButton = null;
    Button villagerNoseButton = null;
    Button coatButton = null;
    Button coatLengthButton = null;
    Button blinkButton = null;
    Button blinkHeightButton = null;
    Button emissiveButton = null;
    Button emissiveSelectButton = null;
    Button enchantButton = null;
    Button enchantSelectButton = null;
    Button transparencyButton = null;
    private Button overridesButton = null;
    private Boolean allowOverrides = null;

    public ETFConfigScreenSkinTool(Screen parent) {
        super("config.entity_texture_features.player_skin_features.title", parent, false);
    }

    public static int getPixelColour(int choice) {
        switch (choice) {
            case 1: {
                return -65281;
            }
            case 2: {
                return -256;
            }
            case 3: {
                return -16776961;
            }
            case 4: {
                return -16711936;
            }
            case 5: {
                return -16760705;
            }
            case 6: {
                return -65536;
            }
            case 7: {
                return -16744449;
            }
            case 8: {
                return -14483457;
            }
        }
        return choice;
    }

    private void onExit() {
        ETF.config().getConfig().enableBlinking = this.originalEnableBlinking;
        if (Minecraft.m_91087_().f_91074_ != null) {
            ETFManager.getInstance().PLAYER_TEXTURE_MAP.removeEntryOnly(Minecraft.m_91087_().f_91074_.m_20148_());
        }
        this.thisETFPlayerTexture = null;
    }

    @Override
    public void m_7379_() {
        this.onExit();
        super.m_7379_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.originalEnableBlinking == null) {
            this.originalEnableBlinking = ETF.config().getConfig().enableBlinking;
            ETF.config().getConfig().enableBlinking = true;
        }
        if (Minecraft.m_91087_().f_91074_ != null && this.thisETFPlayerTexture == null) {
            this.thisETFPlayerTexture = ETFManager.getInstance().PLAYER_TEXTURE_MAP.get(Minecraft.m_91087_().f_91074_.m_20148_());
            if (this.thisETFPlayerTexture == null) {
                ETFPlayerTexture etfPlayerTexture = new ETFPlayerTexture();
                ETFManager.getInstance().PLAYER_TEXTURE_MAP.put(Minecraft.m_91087_().f_91074_.m_20148_(), etfPlayerTexture);
                this.thisETFPlayerTexture = etfPlayerTexture;
            } else if (this.thisETFPlayerTexture.etfTextureOfFinalBaseSkin != null) {
                this.thisETFPlayerTexture.etfTextureOfFinalBaseSkin.setGUIBlink();
            }
        }
        if (this.currentEditorSkin == null) {
            this.currentEditorSkin = ETFUtils2.emptyNativeImage(64, 64);
            NativeImage skin = ETFPlayerTexture.clientPlayerOriginalSkinImageForTool;
            if (skin != null) {
                this.currentEditorSkin.m_85054_(ETFPlayerTexture.clientPlayerOriginalSkinImageForTool);
            } else {
                this.onExit();
                ETFUtils2.logError("could not load tool as skin could not be loaded");
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }
        }
        this.m_142416_((GuiEventListener)this.getETFButton(this.f_96543_ / 2 - 210, (int)((double)this.f_96544_ * 0.9), 200, 20, CommonComponents.f_130656_, button -> {
            this.onExit();
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
        }));
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.024), (int)((double)this.f_96544_ * 0.2), 20, 20, Component.m_130674_((String)"\u27f3"), button -> {
            this.flipView = !this.flipView;
        }));
        this.printSkinFileButton = this.getETFButton(this.f_96543_ / 2 + 10, (int)((double)this.f_96544_ * 0.9), 200, 20, ETF.getTextFromTranslation("selectWorld.edit.save"), button -> {
            boolean result = false;
            if (Minecraft.m_91087_().f_91074_ != null) {
                result = this.printPlayerSkinCopy();
            }
            Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new ETFConfigScreenSkinToolOutcome(this.parent, result, this.currentEditorSkin));
            this.onExit();
        });
        this.m_142416_((GuiEventListener)this.printSkinFileButton);
        if (Minecraft.m_91087_().f_91074_ != null) {
            this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.25), (int)((double)this.f_96544_ * 0.2), (int)((double)this.f_96543_ * 0.42), 20, this.thisETFPlayerTexture.hasFeatures ? ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.remove_features") : ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.add_features"), button -> {
                if (this.thisETFPlayerTexture.hasFeatures) {
                    this.applyExistingOverlayToSkin(REMOVE_OVERLAY);
                } else {
                    this.applyExistingOverlayToSkin(APPLY_OVERLAY);
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.m_93666_(this.thisETFPlayerTexture.hasFeatures ? ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.remove_features") : ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.add_features"));
                this.updateButtons();
            }));
            this.overridesButton = (Button)this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.695), (int)((double)this.f_96544_ * 0.2), (int)((double)this.f_96543_ * 0.275), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.allow_examples"), button -> {
                this.allowOverrides = false;
                button.f_93623_ = false;
                button.m_93666_(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.allow_examples.off"));
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.allow_examples.tooltip")));
            this.villagerNoseButton = this.getETFButton((int)((double)this.f_96543_ * 0.25), (int)((double)this.f_96544_ * 0.7), (int)((double)this.f_96543_ * 0.2), 20, Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.button").getString() + this.thisETFPlayerTexture.noseType.getButtonText().getString())), button -> {
                int colour = this.thisETFPlayerTexture.noseType.next().getNosePixelColour();
                ETFUtils2.setPixel(this.currentEditorSkin, 53, 17, colour);
                if (this.thisETFPlayerTexture.noseType.next().appliesTextureOverlay()) {
                    this.applyExistingOverlayToSkin(BOXES_OVERLAY);
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.button").getString() + this.thisETFPlayerTexture.noseType.getButtonText().getString())));
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.tooltip"));
            this.transparencyButton = this.getETFButton((int)((double)this.f_96543_ * 0.695), (int)((double)this.f_96544_ * 0.7), (int)((double)this.f_96543_ * 0.275), 20, Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.button").getString() + ETFConfigScreenSkinTool.booleanAsOnOff(!this.thisETFPlayerTexture.wasForcedSolid))), button -> {
                button.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.button").getString() + ETFConfigScreenSkinTool.booleanAsOnOff(this.thisETFPlayerTexture.wasForcedSolid))));
                ETFUtils2.setPixel(this.currentEditorSkin, 53, 18, ETFConfigScreenSkinTool.getPixelColour(this.thisETFPlayerTexture.wasForcedSolid ? 0 : 1));
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.tooltip"));
            this.coatButton = this.getETFButton((int)((double)this.f_96543_ * 0.25), (int)((double)this.f_96544_ * 0.3), (int)((double)this.f_96543_ * 0.42), 20, CoatStyle.get(this.thisETFPlayerTexture.coatStyle).getTitle(), button -> {
                CoatStyle coat = CoatStyle.get(this.thisETFPlayerTexture.coatStyle).next();
                button.m_93666_(coat.getTitle());
                ETFUtils2.setPixel(this.currentEditorSkin, 52, 17, coat.getCoatPixelColour());
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.tooltip"));
            this.coatLengthButton = this.getETFButton((int)((double)this.f_96543_ * 0.695), (int)((double)this.f_96544_ * 0.3), (int)((double)this.f_96543_ * 0.275), 20, Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.title").getString() + this.thisETFPlayerTexture.coatLength)), button -> {
                int lengthChoice = this.thisETFPlayerTexture.coatLength == 8 ? 1 : this.thisETFPlayerTexture.coatLength + 1;
                ETFUtils2.setPixel(this.currentEditorSkin, 52, 18, ETFConfigScreenSkinTool.getPixelColour(lengthChoice));
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.title").getString() + this.thisETFPlayerTexture.coatLength)));
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.tooltip"));
            this.blinkButton = this.getETFButton((int)((double)this.f_96543_ * 0.25), (int)((double)this.f_96544_ * 0.4), (int)((double)this.f_96543_ * 0.42), 20, BlinkType.get(this.thisETFPlayerTexture.blinkType).getTitle(), button -> {
                BlinkType blink = BlinkType.get(this.thisETFPlayerTexture.blinkType).next();
                button.m_93666_(blink.getTitle());
                if (blink != BlinkType.NONE && blink != BlinkType.WHOLE_FACE_TWO && blink != BlinkType.WHOLE_FACE) {
                    ETFUtils2.setPixel(this.currentEditorSkin, 52, 19, ETFConfigScreenSkinTool.getPixelColour(0));
                } else if (ETFUtils2.getPixel(this.currentEditorSkin, 52, 19) > blink.getMaxEyePixelHeight()) {
                    ETFUtils2.setPixel(this.currentEditorSkin, 52, 19, ETFConfigScreenSkinTool.getPixelColour(blink.getMaxEyePixelHeight()));
                }
                ResourceLocation overlay = blink.getExampleOverlay();
                if (overlay != null) {
                    this.applyExistingOverlayToSkin(overlay);
                }
                ETFUtils2.setPixel(this.currentEditorSkin, 52, 16, blink.getBlinkPixelColour());
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.tooltip"));
            this.blinkHeightButton = this.getETFButton((int)((double)this.f_96543_ * 0.695), (int)((double)this.f_96544_ * 0.4), (int)((double)this.f_96543_ * 0.275), 20, Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.title").getString() + this.thisETFPlayerTexture.blinkHeight)), button -> {
                int heightChoice = this.thisETFPlayerTexture.blinkHeight == BlinkType.get(this.thisETFPlayerTexture.blinkType).getMaxEyePixelHeight() ? 1 : this.thisETFPlayerTexture.blinkHeight + 1;
                ETFUtils2.setPixel(this.currentEditorSkin, 52, 19, ETFConfigScreenSkinTool.getPixelColour(heightChoice));
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.title").getString() + this.thisETFPlayerTexture.blinkHeight)));
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.tooltip"));
            this.emissiveButton = this.getETFButton((int)((double)this.f_96543_ * 0.25), (int)((double)this.f_96544_ * 0.5), (int)((double)this.f_96543_ * 0.42), 20, Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 17) == ETFConfigScreenSkinTool.getPixelColour(1) ? CommonComponents.f_130653_ : CommonComponents.f_130654_).getString())), button -> {
                if (this.thisETFPlayerTexture.hasEmissives) {
                    ETFUtils2.setPixel(this.currentEditorSkin, 1, 17, 0);
                } else {
                    ETFUtils2.setPixel(this.currentEditorSkin, 1, 17, ETFConfigScreenSkinTool.getPixelColour(1));
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 17) == ETFConfigScreenSkinTool.getPixelColour(1) ? CommonComponents.f_130653_ : CommonComponents.f_130654_).getString())));
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.tooltip"));
            this.emissiveSelectButton = this.getETFButton((int)((double)this.f_96543_ * 0.695), (int)((double)this.f_96544_ * 0.5), (int)((double)this.f_96543_ * 0.275), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_select.button"), button -> Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new ETFConfigScreenSkinToolPixelSelection(this, ETFConfigScreenSkinToolPixelSelection.SelectionMode.EMISSIVE)));
            this.enchantButton = this.getETFButton((int)((double)this.f_96543_ * 0.25), (int)((double)this.f_96544_ * 0.6), (int)((double)this.f_96543_ * 0.42), 20, Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 18) == ETFConfigScreenSkinTool.getPixelColour(2) ? CommonComponents.f_130653_ : CommonComponents.f_130654_).getString())), button -> {
                if (this.thisETFPlayerTexture.hasEnchant) {
                    ETFUtils2.setPixel(this.currentEditorSkin, 1, 18, 0);
                } else {
                    ETFUtils2.setPixel(this.currentEditorSkin, 1, 18, ETFConfigScreenSkinTool.getPixelColour(2));
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 18) == ETFConfigScreenSkinTool.getPixelColour(2) ? CommonComponents.f_130653_ : CommonComponents.f_130654_).getString())));
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.tooltip"));
            this.enchantSelectButton = this.getETFButton((int)((double)this.f_96543_ * 0.695), (int)((double)this.f_96544_ * 0.6), (int)((double)this.f_96543_ * 0.275), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_select.button"), button -> Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new ETFConfigScreenSkinToolPixelSelection(this, ETFConfigScreenSkinToolPixelSelection.SelectionMode.ENCHANTED)));
            this.updateButtons();
            this.m_142416_((GuiEventListener)this.villagerNoseButton);
            this.m_142416_((GuiEventListener)this.coatButton);
            this.m_142416_((GuiEventListener)this.coatLengthButton);
            this.m_142416_((GuiEventListener)this.blinkButton);
            this.m_142416_((GuiEventListener)this.blinkHeightButton);
            this.m_142416_((GuiEventListener)this.emissiveButton);
            this.m_142416_((GuiEventListener)this.emissiveSelectButton);
            this.m_142416_((GuiEventListener)this.enchantButton);
            this.m_142416_((GuiEventListener)this.enchantSelectButton);
            this.m_142416_((GuiEventListener)this.transparencyButton);
        }
    }

    private void updateButtons() {
        boolean activeFeatures = this.thisETFPlayerTexture.hasFeatures;
        if (this.villagerNoseButton != null) {
            this.villagerNoseButton.f_93623_ = activeFeatures;
            this.villagerNoseButton.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.button").getString() + this.thisETFPlayerTexture.noseType.getButtonText().getString())));
        }
        if (this.coatButton != null) {
            this.coatButton.f_93623_ = activeFeatures;
            this.coatButton.m_93666_(CoatStyle.get(this.thisETFPlayerTexture.coatStyle).getTitle());
        }
        if (this.coatLengthButton != null) {
            this.coatLengthButton.f_93623_ = activeFeatures && CoatStyle.get(this.thisETFPlayerTexture.coatStyle) != CoatStyle.NONE;
            this.coatLengthButton.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.title").getString() + this.thisETFPlayerTexture.coatLength)));
        }
        if (this.blinkButton != null) {
            this.blinkButton.f_93623_ = activeFeatures;
            this.blinkButton.m_93666_(BlinkType.get(this.thisETFPlayerTexture.blinkType).getTitle());
        }
        if (this.blinkHeightButton != null) {
            this.blinkHeightButton.f_93623_ = activeFeatures && BlinkType.get(this.thisETFPlayerTexture.blinkType) != BlinkType.NONE && BlinkType.get(this.thisETFPlayerTexture.blinkType) != BlinkType.WHOLE_FACE_TWO && BlinkType.get(this.thisETFPlayerTexture.blinkType) != BlinkType.WHOLE_FACE;
            this.blinkHeightButton.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.title").getString() + this.thisETFPlayerTexture.blinkHeight)));
        }
        if (this.emissiveButton != null) {
            this.emissiveButton.f_93623_ = activeFeatures;
            this.emissiveButton.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 17) == ETFConfigScreenSkinTool.getPixelColour(1) ? CommonComponents.f_130653_ : CommonComponents.f_130654_).getString())));
        }
        if (this.emissiveSelectButton != null) {
            boolean bl = this.emissiveSelectButton.f_93623_ = activeFeatures && ETFUtils2.getPixel(this.currentEditorSkin, 1, 17) == ETFConfigScreenSkinTool.getPixelColour(1);
        }
        if (this.enchantButton != null) {
            this.enchantButton.f_93623_ = activeFeatures;
            this.enchantButton.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 18) == ETFConfigScreenSkinTool.getPixelColour(2) ? CommonComponents.f_130653_ : CommonComponents.f_130654_).getString())));
        }
        if (this.enchantSelectButton != null) {
            boolean bl = this.enchantSelectButton.f_93623_ = activeFeatures && ETFUtils2.getPixel(this.currentEditorSkin, 1, 18) == ETFConfigScreenSkinTool.getPixelColour(2);
        }
        if (this.transparencyButton != null) {
            this.transparencyButton.f_93623_ = activeFeatures;
            this.transparencyButton.m_93666_(Component.m_130674_((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.button").getString() + ETFConfigScreenSkinTool.booleanAsOnOff(!this.thisETFPlayerTexture.wasForcedSolid))));
        }
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            int height = (int)((double)this.f_96544_ * 0.75);
            int playerX = (int)((double)this.f_96543_ * 0.14);
            this.drawEntity(context, playerX, height, (int)((double)this.f_96544_ * 0.3), -mouseX + playerX, (float)((double)(-mouseY) + (double)this.f_96544_ * 0.3), (LivingEntity)player);
        } else {
            context.m_280430_(this.f_96547_, Component.m_130674_((String)"Player is null for some reason!"), this.f_96543_ / 7, (int)((double)this.f_96544_ * 0.4), 0xFFFFFF);
            context.m_280430_(this.f_96547_, Component.m_130674_((String)"Cannot load player to render!"), this.f_96543_ / 7, (int)((double)this.f_96544_ * 0.45), 0xFFFFFF);
        }
        context.m_280430_(this.f_96547_, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.crouch_message"), this.f_96543_ / 40, (int)((double)this.f_96544_ * 0.8), 0x555555);
        context.m_280430_(this.f_96547_, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_message"), this.f_96543_ / 40, (int)((double)this.f_96544_ * 0.1), 0x555555);
    }

    public void applyExistingOverlayToSkin(ResourceLocation overlayTexture) {
        if (ETF.isFabric() == ETF.isThisModLoaded("fabric")) {
            NativeImage overlayImage = ETFUtils2.getNativeImageElseNull(overlayTexture);
            assert (overlayImage != null);
            if (!overlayTexture.equals((Object)REMOVE_OVERLAY) && !overlayTexture.equals((Object)APPLY_OVERLAY)) {
                if (this.allowOverrides == null) {
                    Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(Component.m_130674_((String)""), this));
                    if (this.allowOverrides == null) {
                        this.allowOverrides = false;
                    }
                }
                if (!this.allowOverrides.booleanValue()) {
                    ETFUtils2.logMessage("Skin example overlay [" + String.valueOf(overlayTexture) + "] not applied.", false);
                    return;
                }
            }
            try {
                for (int x = 0; x < this.currentEditorSkin.m_84982_(); ++x) {
                    for (int y = 0; y < this.currentEditorSkin.m_85084_(); ++y) {
                        if (ETFUtils2.getPixel(overlayImage, x, y) == 0) continue;
                        ETFUtils2.setPixel(this.currentEditorSkin, x, y, ETFUtils2.getPixel(overlayImage, x, y));
                    }
                }
            }
            catch (Exception e) {
                ETFUtils2.logMessage("Skin feature layout could not be applied to a copy of your skin. Error written to log.", false);
                ETFUtils2.logError(e.toString(), false);
            }
        } else {
            ETFUtils2.logError("Fabric API required for skin processing, cancelling.", false);
        }
    }

    public boolean printPlayerSkinCopy() {
        if (ETF.isFabric() == ETF.isThisModLoaded("fabric") && ETF.getConfigDirectory() != null) {
            Path outputDirectory = Path.of(ETF.getConfigDirectory().toFile().getParent(), "\\ETF_player_skin_printout.png");
            try {
                this.currentEditorSkin.m_85066_(outputDirectory);
                ETFUtils2.logMessage(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result.success").getString(), false);
                return true;
            }
            catch (Exception e) {
                ETFUtils2.logError(e.toString(), false);
            }
        }
        return false;
    }

    public void drawEntity(GuiGraphics context, int x, int y, int size, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(0.0f);
        quaternionf.mul((Quaternionfc)quaternionf2);
        context.m_280168_().m_85836_();
        context.m_280168_().m_85837_((double)x, (double)y, 150.0);
        context.m_280168_().m_252931_(new Matrix4f().scaling((float)size, (float)size, (float)(-size)));
        context.m_280168_().m_252781_(quaternionf);
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        if (quaternionf2 != null) {
            quaternionf2.conjugate();
            entityRenderDispatcher.m_252923_(quaternionf2);
        }
        entityRenderDispatcher.m_114468_(false);
        float h = entity.f_20883_;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity.f_20886_;
        float l = entity.f_20885_;
        entity.f_20883_ = (this.flipView ? 0.0f : 180.0f) + f * 20.0f;
        entity.m_146922_((this.flipView ? 0.0f : 180.0f) + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.m_280168_(), (MultiBufferSource)context.m_280091_(), 0xF000F0));
        context.m_280262_();
        entityRenderDispatcher.m_114468_(true);
        context.m_280168_().m_85849_();
        Lighting.m_84931_();
        entity.f_20883_ = h;
        entity.m_146922_(i);
        entity.m_146926_(j);
        entity.f_20886_ = k;
        entity.f_20885_ = l;
    }

    public static enum NoseType {
        VILLAGER(1, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager")),
        VILLAGER_TEXTURED(7, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager2")),
        VILLAGER_REMOVE(8, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager3")),
        VILLAGER_TEXTURED_REMOVE(9, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager4")),
        TEXTURED_1(2, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.1")),
        TEXTURED_2(3, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.2")),
        TEXTURED_3(4, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.3")),
        TEXTURED_4(5, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.4")),
        TEXTURED_5(6, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.5")),
        NONE(0, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.none"));

        public final int id;
        private final Component buttonText;

        private NoseType(int i, Component buttonText) {
            this.id = i;
            this.buttonText = buttonText;
        }

        public NoseType getByColorId(int id) {
            for (NoseType nose : NoseType.values()) {
                if (nose.id != id) continue;
                return nose;
            }
            return NONE;
        }

        public boolean appliesTextureOverlay() {
            return this == TEXTURED_1 || this == TEXTURED_2 || this == TEXTURED_3 || this == TEXTURED_4 || this == TEXTURED_5;
        }

        public Component getButtonText() {
            return this.buttonText;
        }

        public NoseType next() {
            switch (this) {
                case NONE: {
                    return VILLAGER;
                }
                case VILLAGER: {
                    return VILLAGER_TEXTURED;
                }
                case VILLAGER_TEXTURED: {
                    return VILLAGER_REMOVE;
                }
                case VILLAGER_REMOVE: {
                    return VILLAGER_TEXTURED_REMOVE;
                }
                case VILLAGER_TEXTURED_REMOVE: {
                    return TEXTURED_1;
                }
                case TEXTURED_1: {
                    return TEXTURED_2;
                }
                case TEXTURED_2: {
                    return TEXTURED_3;
                }
                case TEXTURED_3: {
                    return TEXTURED_4;
                }
                case TEXTURED_4: {
                    return TEXTURED_5;
                }
            }
            return NONE;
        }

        public int getNosePixelColour() {
            return ETFPlayerTexture.getSkinNumberToPixelColour(this.id);
        }
    }

    public static enum CoatStyle {
        COPIED_THIN_TOP,
        MOVED_THIN_TOP,
        COPIED_FAT_TOP,
        MOVED_FAT_TOP,
        COPIED_THIN,
        MOVED_THIN,
        COPIED_FAT,
        MOVED_FAT,
        NONE;


        public static CoatStyle get(int id) {
            switch (id) {
                case 1: {
                    return COPIED_THIN_TOP;
                }
                case 2: {
                    return MOVED_THIN_TOP;
                }
                case 3: {
                    return COPIED_FAT_TOP;
                }
                case 4: {
                    return MOVED_FAT_TOP;
                }
                case 5: {
                    return COPIED_THIN;
                }
                case 6: {
                    return MOVED_THIN;
                }
                case 7: {
                    return COPIED_FAT;
                }
                case 8: {
                    return MOVED_FAT;
                }
            }
            return NONE;
        }

        public Component getTitle() {
            switch (this) {
                case COPIED_THIN_TOP: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.1");
                }
                case MOVED_THIN_TOP: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.2");
                }
                case COPIED_FAT_TOP: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.3");
                }
                case MOVED_FAT_TOP: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.4");
                }
                case COPIED_THIN: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.5");
                }
                case MOVED_THIN: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.6");
                }
                case COPIED_FAT: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.7");
                }
                case MOVED_FAT: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.8");
                }
            }
            return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.none");
        }

        public int getCoatPixelColour() {
            switch (this) {
                case COPIED_THIN_TOP: {
                    return -65281;
                }
                case MOVED_THIN_TOP: {
                    return -256;
                }
                case COPIED_FAT_TOP: {
                    return -16776961;
                }
                case MOVED_FAT_TOP: {
                    return -16711936;
                }
                case COPIED_THIN: {
                    return -16760705;
                }
                case MOVED_THIN: {
                    return -65536;
                }
                case COPIED_FAT: {
                    return -16744449;
                }
                case MOVED_FAT: {
                    return -14483457;
                }
            }
            return 0;
        }

        public CoatStyle next() {
            switch (this) {
                case NONE: {
                    return COPIED_THIN_TOP;
                }
                case COPIED_THIN_TOP: {
                    return MOVED_THIN_TOP;
                }
                case MOVED_THIN_TOP: {
                    return COPIED_FAT_TOP;
                }
                case COPIED_FAT_TOP: {
                    return MOVED_FAT_TOP;
                }
                case MOVED_FAT_TOP: {
                    return COPIED_THIN;
                }
                case COPIED_THIN: {
                    return MOVED_THIN;
                }
                case MOVED_THIN: {
                    return COPIED_FAT;
                }
                case COPIED_FAT: {
                    return MOVED_FAT;
                }
            }
            return NONE;
        }
    }

    public static enum BlinkType {
        ONE_PIXEL,
        TWO_PIXEL,
        FOUR_PIXEL,
        WHOLE_FACE,
        WHOLE_FACE_TWO,
        NONE;


        public static BlinkType get(int id) {
            switch (id) {
                case 3: {
                    return ONE_PIXEL;
                }
                case 4: {
                    return TWO_PIXEL;
                }
                case 5: {
                    return FOUR_PIXEL;
                }
                case 1: {
                    return WHOLE_FACE;
                }
                case 2: {
                    return WHOLE_FACE_TWO;
                }
            }
            return NONE;
        }

        public ResourceLocation getExampleOverlay() {
            return switch (this) {
                case WHOLE_FACE, WHOLE_FACE_TWO -> WHOLE_FACE_OVERLAY;
                case NONE -> null;
                default -> SMALL_EYE_OVERLAY;
            };
        }

        public Component getTitle() {
            switch (this) {
                case ONE_PIXEL: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.1");
                }
                case TWO_PIXEL: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.2");
                }
                case FOUR_PIXEL: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.4");
                }
                case WHOLE_FACE: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.whole.1");
                }
                case WHOLE_FACE_TWO: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.whole.2");
                }
            }
            return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.none");
        }

        public int getBlinkPixelColour() {
            switch (this) {
                case ONE_PIXEL: {
                    return ETFConfigScreenSkinTool.getPixelColour(3);
                }
                case TWO_PIXEL: {
                    return ETFConfigScreenSkinTool.getPixelColour(4);
                }
                case FOUR_PIXEL: {
                    return ETFConfigScreenSkinTool.getPixelColour(5);
                }
                case WHOLE_FACE: {
                    return ETFConfigScreenSkinTool.getPixelColour(1);
                }
                case WHOLE_FACE_TWO: {
                    return ETFConfigScreenSkinTool.getPixelColour(2);
                }
            }
            return 0;
        }

        public int getMaxEyePixelHeight() {
            switch (this) {
                case ONE_PIXEL: {
                    return 8;
                }
                case TWO_PIXEL: {
                    return 7;
                }
                case FOUR_PIXEL: {
                    return 5;
                }
            }
            return 1;
        }

        public BlinkType next() {
            switch (this) {
                case NONE: {
                    return ONE_PIXEL;
                }
                case ONE_PIXEL: {
                    return TWO_PIXEL;
                }
                case TWO_PIXEL: {
                    return FOUR_PIXEL;
                }
                case FOUR_PIXEL: {
                    return WHOLE_FACE;
                }
                case WHOLE_FACE: {
                    return WHOLE_FACE_TWO;
                }
            }
            return NONE;
        }
    }

    private class ConfirmScreen
    extends Screen {
        final Screen parent;

        protected ConfirmScreen(Component title, Screen parent) {
            super(title);
            this.parent = parent;
        }

        public void m_7379_() {
            if (ETFConfigScreenSkinTool.this.overridesButton == null) {
                ETFConfigScreenSkinTool.this.allowOverrides = false;
            } else {
                ETFConfigScreenSkinTool.this.overridesButton.m_5691_();
            }
            Minecraft.m_91087_().m_91152_(this.parent);
        }

        public boolean m_6913_() {
            return true;
        }

        protected void m_7856_() {
            super.m_7856_();
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130657_, button -> {
                ETFConfigScreenSkinTool.this.allowOverrides = true;
                Minecraft.m_91087_().m_91152_(this.parent);
            }).m_252987_(this.f_96543_ / 2 - 210, this.f_96544_ / 2 + 50, 200, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130658_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 10, this.f_96544_ / 2 + 50, 200, 20).m_253136_());
        }

        public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.m_88315_(context, mouseX, mouseY, delta);
            context.m_280653_(this.f_96547_, ETF.getTextFromTranslation("config.entity_texture_features.skin_editor.overlays.1"), this.f_96543_ / 2, this.f_96544_ / 2, -1);
            context.m_280653_(this.f_96547_, ETF.getTextFromTranslation("config.entity_texture_features.skin_editor.overlays.2"), this.f_96543_ / 2, this.f_96544_ / 2 + 11, -1);
            context.m_280653_(this.f_96547_, ETF.getTextFromTranslation("config.entity_texture_features.skin_editor.overlays.3"), this.f_96543_ / 2, this.f_96544_ / 2 + 22, -1);
        }
    }
}

