/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api;

import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class VecTransformer {
    private static final Vec3[] AXIS_VECS = (Vec3[])Util.m_137537_(() -> {
        Vec3[] vecs = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 1.0)};
        return vecs;
    });
    protected final Vec3 vec;

    public VecTransformer(Vec3 vec) {
        this.vec = vec;
    }

    public abstract Vec3 apply();

    public Vec3 applyForEntity(Entity entity) {
        return this.apply().m_82549_(entity.m_20182_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof VecTransformer)) return false;
        VecTransformer v = (VecTransformer)obj;
        if (this.getClass() != v.getClass()) return false;
        if (!Objects.equals(this.vec, v.vec)) return false;
        return true;
    }

    public static Vec3 rotateVec(Vec3 vec, float angleDegrees, Direction.Axis axis) {
        double theta = (float)Math.PI / 180 * angleDegrees;
        Vec3 axisVec = AXIS_VECS[axis.ordinal()];
        double x = vec.m_7096_();
        double y = vec.m_7098_();
        double z = vec.m_7094_();
        double u = axisVec.m_7096_();
        double v = axisVec.m_7098_();
        double w = axisVec.m_7094_();
        double xPrime = u * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta);
        return new Vec3(xPrime, yPrime, zPrime);
    }

    public static class PitchAndYaw
    extends VecTransformer {
        private final float pitch;
        private final float yaw;
        private final Direction.Axis pitchAxis;

        public PitchAndYaw(Vec3 vec, float pitchDegrees, float yawDegrees) {
            this(vec, pitchDegrees, yawDegrees, Direction.Axis.X);
        }

        public PitchAndYaw(Vec3 vec, float pitchDegrees, float yawDegrees, Direction.Axis pitchAxis) {
            super(vec);
            this.pitch = pitchDegrees;
            this.yaw = yawDegrees;
            this.pitchAxis = pitchAxis;
        }

        @Override
        public Vec3 apply() {
            Vec3 vec = PitchAndYaw.rotateVec(this.vec, this.pitch, this.pitchAxis);
            return PitchAndYaw.rotateVec(vec, this.yaw, Direction.Axis.Y);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) return false;
            if (!(obj instanceof PitchAndYaw)) return false;
            PitchAndYaw v = (PitchAndYaw)obj;
            if (this.pitch != v.pitch) return false;
            if (this.yaw != v.yaw) return false;
            if (this.pitchAxis != v.pitchAxis) return false;
            return true;
        }
    }

    public static class Rotated
    extends VecTransformer {
        private final float angle;
        private final Direction.Axis axis;

        public Rotated(Vec3 vec, float angleDegrees, Direction.Axis axis) {
            super(vec);
            this.angle = angleDegrees;
            this.axis = axis;
        }

        @Override
        public Vec3 apply() {
            return Rotated.rotateVec(this.vec, this.angle, this.axis);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) return false;
            if (!(obj instanceof Rotated)) return false;
            Rotated v = (Rotated)obj;
            if (this.axis != v.axis) return false;
            if (this.angle != v.angle) return false;
            return true;
        }
    }

    public static class RaytracedFacing
    extends VecTransformer {
        private final Vec3 anchor;
        private final ClipContext.Block blockClip;
        private final ClipContext.Fluid fluidClip;

        public RaytracedFacing(Vec3 maxDist, Vec3 anchor, ClipContext.Block blockClip, ClipContext.Fluid fluidClip) {
            super(maxDist);
            this.anchor = anchor;
            this.blockClip = blockClip;
            this.fluidClip = fluidClip;
        }

        public RaytracedFacing(float maxDist, Vec3 anchor) {
            this(new Vec3(0.0, 0.0, (double)maxDist), anchor);
        }

        public RaytracedFacing(Vec3 maxDist, Vec3 anchor) {
            this(maxDist, anchor, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE);
        }

        @Override
        public Vec3 apply() {
            return this.vec.m_82549_(this.anchor);
        }

        @Override
        public Vec3 applyForEntity(Entity entity) {
            Vec3 dest = new Facing(this.vec, this.anchor).applyForEntity(entity);
            BlockHitResult hitResult = entity.m_9236_().m_45547_(new ClipContext(entity.m_20182_().m_82549_(this.anchor), dest, this.blockClip, this.fluidClip, entity));
            return hitResult.m_82450_().m_82549_(new Vec3(hitResult.m_82434_().m_253071_()));
        }
    }

    public static class Facing
    extends VecTransformer {
        private final Vec3 anchor;

        public Facing(Vec3 vec, Vec3 anchor) {
            super(vec);
            this.anchor = anchor;
        }

        public Facing(Vec3 vec) {
            this(vec, Vec3.f_82478_);
        }

        public Facing(float left, float up, float forward) {
            this(new Vec3((double)left, (double)up, (double)forward));
        }

        @Override
        public Vec3 apply() {
            return this.vec.m_82549_(this.anchor);
        }

        @Override
        public Vec3 applyForEntity(Entity entity) {
            Vec2 lookVec = entity.m_20155_();
            Vec3 pos = new PitchAndYaw(this.vec, lookVec.f_82470_, -lookVec.f_82471_).apply();
            return pos.m_82549_(this.anchor).m_82549_(entity.m_20182_());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) return false;
            if (!(obj instanceof Facing)) return false;
            Facing v = (Facing)obj;
            if (!Objects.equals(this.anchor, v.anchor)) return false;
            return true;
        }
    }

    public static class Relative
    extends VecTransformer {
        public Relative(Vec3 vec) {
            super(vec);
        }

        public Relative(float x, float y, float z) {
            this(new Vec3((double)x, (double)y, (double)z));
        }

        @Override
        public Vec3 apply() {
            return this.vec;
        }
    }

    public static class Direct
    extends VecTransformer {
        public Direct(Vec3 vec) {
            super(vec);
        }

        @Override
        public Vec3 apply() {
            return Vec3.f_82478_;
        }

        @Override
        public Vec3 applyForEntity(Entity entity) {
            return this.apply().m_82549_(this.vec);
        }
    }
}

