/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.registry;

import com.legacy.lucent.api.EntityBrightness;
import com.legacy.lucent.api.data.objects.ItemLighting;
import com.legacy.lucent.api.data.objects.LightLevelProvider;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ItemLightingRegistry {
    private static final Map<Item, List<ItemLighting>> PROVIDER_REGISTRY = new HashMap<Item, List<ItemLighting>>();
    private static final List<ItemLighting> DEFAULT_PROVIDERS = new ArrayList<ItemLighting>();
    private static Map<Item, LucentRegistry.Source> registeredBy = new HashMap<Item, LucentRegistry.Source>();

    public void register(ItemLighting lighting) {
        LightLevelProvider<?> prov = lighting.provider();
        lighting.item().ifPresentOrElse(item -> {
            LightLevelProvider.Direct direct;
            if (prov instanceof LightLevelProvider.Direct && (direct = (LightLevelProvider.Direct)prov).value() <= -1) {
                this.remove((Item)item);
            } else {
                boolean overwrote = false;
                LucentRegistry.Source source = registeredBy.get(item);
                if (source != null && source.isBuiltin && source.priority < LucentRegistry.currentSource.priority) {
                    ArrayList<ItemLighting> list = new ArrayList<ItemLighting>();
                    list.add(lighting);
                    PROVIDER_REGISTRY.put((Item)item, (List<ItemLighting>)list);
                    overwrote = true;
                } else {
                    PROVIDER_REGISTRY.computeIfAbsent((Item)item, i -> new ArrayList()).add(lighting);
                }
                registeredBy.put((Item)item, LucentRegistry.currentSource);
                if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
                    LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> [" + ForgeRegistries.ITEMS.getKey(item) + "] " + (overwrote ? "overwrote " : "added ") + prov, new Object[0]);
                }
            }
        }, () -> {
            DEFAULT_PROVIDERS.add(lighting);
            if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
                LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> [all items] added " + prov, new Object[0]);
            }
        });
    }

    public void register(ItemLighting.Builder itemLightingBuilder) {
        if (!itemLightingBuilder.hasFailed()) {
            this.register(itemLightingBuilder.build());
        }
    }

    public void register(@Nullable Item item, LightLevelProvider<?> lightLevelProvider) {
        this.register(ItemLighting.builder().item(item).light(lightLevelProvider));
    }

    public void register(LightLevelProvider<?> lightLevelProvider) {
        this.register(null, lightLevelProvider);
    }

    public void register(Item item, int lightLevel) {
        if (lightLevel <= -1) {
            this.remove(item);
        } else {
            this.register(ItemLighting.builder().item(item).light(new LightLevelProvider.Direct(lightLevel)));
        }
    }

    public void register(ResourceLocation itemId, int lightLevel) {
        if (ForgeRegistries.ITEMS.containsKey(itemId)) {
            this.register((Item)ForgeRegistries.ITEMS.getValue(itemId), lightLevel);
        } else if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.warn("  [" + LucentRegistry.sourceName + "] -> [" + itemId + "] was not found in registry", new Object[0]);
        }
    }

    public void register(String itemId, int lightLevel) {
        if (ResourceLocation.m_135830_((String)itemId)) {
            this.register(new ResourceLocation(itemId), lightLevel);
        } else {
            LucentRegistry.logInvalidResourceLocation(itemId);
        }
    }

    public void remove(Item item) {
        if (PROVIDER_REGISTRY.remove(item) != null && ((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> Removed [" + ForgeRegistries.ITEMS.getKey((Object)item) + "]", new Object[0]);
        }
    }

    public List<Item> getMatching(Predicate<Item> itemPredicate) {
        return ForgeRegistries.ITEMS.getValues().stream().filter(itemPredicate).toList();
    }

    public List<Item> getMatchingByName(Predicate<ResourceLocation> namePredicate) {
        return ForgeRegistries.ITEMS.getKeys().stream().filter(namePredicate).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).toList();
    }

    @Deprecated(forRemoval=true, since="1.19")
    public static int get(Item item) {
        return ItemLightingRegistry.get(item.m_7968_());
    }

    public static int get(ItemStack itemStack) {
        return ItemLightingRegistry.get(itemStack, EntityBrightness.activeEntity);
    }

    public static int get(ItemStack itemStack, Entity entity) {
        if (itemStack.m_41619_()) {
            return 0;
        }
        List<ItemLighting> lightings = PROVIDER_REGISTRY.getOrDefault(itemStack.m_41720_(), DEFAULT_PROVIDERS);
        if (lightings.isEmpty()) {
            return 0;
        }
        int ret = 0;
        for (ItemLighting lighting : lightings) {
            LightLevelProvider<?> prov;
            if (!lighting.worksUnderwater() && entity.m_9236_().m_6425_(entity.m_20183_()).m_205070_(FluidTags.f_13131_) || !lighting.worksOnLand() && !entity.m_9236_().m_6425_(entity.m_20183_()).m_205070_(FluidTags.f_13131_) || !(prov = lighting.provider()).getSource().isValidClass(itemStack)) continue;
            int l = prov.getLightLevel(entity.m_9236_().m_9598_(), itemStack);
            if (l >= 15) {
                return l;
            }
            if (l <= ret) continue;
            ret = l;
        }
        return ret;
    }

    @Deprecated
    public static void clear() {
        PROVIDER_REGISTRY.clear();
        DEFAULT_PROVIDERS.clear();
        ItemLightingRegistry.clearCache();
    }

    @Deprecated
    public static void clearCache() {
        registeredBy.clear();
    }
}

