/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core;

import com.legacy.lucent.core.LucentClient;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lucent")
public class LucentMod {
    public static final String MODID = "lucent";
    public static final LoggerWrapper LOGGER = new LoggerWrapper("lucent");

    public LucentMod() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, isServer) -> true));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> LucentClient.init());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> LOGGER.warn("LUCENT IS A CLIENT SIDE MOD. IT DOES NOT NEED TO BE INSTALLED ON THE SERVER.", new Object[0]));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(LucentMod::gatherData);
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MODID, path);
    }

    protected static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        gen.addProvider(true, (DataProvider)LucentMod.packMcmeta(output, "Lucent resources"));
    }

    private static final PackMetadataGenerator packMcmeta(PackOutput output, String description) {
        Map packVersionMap = Stream.of(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0)));
        int packVersion = packVersionMap.get(PackType.SERVER_DATA);
        return new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)description), packVersion, packVersionMap));
    }

    public static final class LoggerWrapper {
        private final Logger logger;
        private final String prefix;

        public LoggerWrapper(String modID) {
            modID = modID.toLowerCase(Locale.ENGLISH);
            StringBuilder modProper = new StringBuilder();
            for (String word : modID.split("_")) {
                modProper.append(word.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(word.substring(1));
            }
            this.logger = LogManager.getLogger((String)("ModdingLegacy/" + modProper));
            this.prefix = "[" + modID + "] ";
        }

        private void log(Level level, Object message, Object ... params) {
            this.logger.log(level, this.prefix + message, params);
        }

        public void info(Object message, Object ... params) {
            this.log(Level.INFO, message, params);
        }

        public void debug(Object message, Object ... params) {
            this.log(Level.DEBUG, message, params);
        }

        public void error(Object message, Object ... params) {
            this.log(Level.ERROR, message, params);
        }

        public void warn(Object message, Object ... params) {
            this.log(Level.WARN, message, params);
        }

        public void fatal(Object message, Object ... params) {
            this.log(Level.FATAL, message, params);
        }

        public void printStacktrace(String customMessage, Throwable t) {
            StackTraceElement[] st;
            this.error(customMessage + " " + t.toString(), new Object[0]);
            for (StackTraceElement s : st = t.getStackTrace()) {
                this.error("  " + s, new Object[0]);
            }
        }

        public Logger getLogger() {
            return this.logger;
        }
    }
}

