/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.dynamic_lighting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LightData {
    protected static final LightData NONE = new LightData(0, new SourcePos(0.0, 0.0, 0.0));
    protected boolean shouldStay = true;
    protected boolean dirty = true;
    protected int lightLevel;
    protected float calculatedBlockLight = -1.0f;
    protected final List<SourcePos> sourcePoses;

    protected LightData(int lightLevel, SourcePos sourcePos) {
        this(lightLevel, new ArrayList<SourcePos>(Arrays.asList(sourcePos)));
    }

    protected LightData(int lightLevel, List<SourcePos> sourcePoses) {
        this.lightLevel = lightLevel;
        this.sourcePoses = sourcePoses;
    }

    public int rawLight() {
        return this.lightLevel;
    }

    public boolean equals(Object obj) {
        LightData l;
        return obj instanceof LightData && this.equals(l = (LightData)obj);
    }

    public boolean equals(LightData lightData) {
        return this.lightLevel == lightData.lightLevel && this.sourcePosEquals(lightData.sourcePoses);
    }

    protected boolean sourcePosEquals(List<SourcePos> sourcePoses) {
        int size = this.sourcePoses.size();
        if (size == sourcePoses.size()) {
            if (size == 0) {
                return true;
            }
            if (size == 1) {
                return sourcePoses.get(0).equals(this.sourcePoses.get(0));
            }
            for (int i = 0; i < size; ++i) {
                if (sourcePoses.contains(this.sourcePoses.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class SourcePos {
        protected final double x;
        protected final double y;
        protected final double z;

        protected SourcePos(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object obj) {
            SourcePos s;
            return obj instanceof SourcePos && this.equals(s = (SourcePos)obj);
        }

        public boolean equals(SourcePos pos) {
            return this.x == pos.x && this.y == pos.y && this.z == pos.z;
        }
    }
}

