/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.mixin;

import com.legacy.lucent.core.LucentMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class LucentMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        if (MixinEnvironment.getCurrentEnvironment().getSide() == MixinEnvironment.Side.CLIENT) {
            mixins.addAll(Arrays.asList("EntityRendererMixin", "LevelRendererMixin", "LevelMixin", "EntityMixin"));
            if (LucentMixinPlugin.doesClassExist("net.optifine.Lang")) {
                LucentMod.LOGGER.info("Found Optifine", new Object[0]);
                mixins.addAll(Arrays.asList("ModelBlockRendererMixinOptifine"));
            } else {
                mixins.addAll(Arrays.asList("ModelBlockRendererMixin", "LevelRendererMixinThreadedRendering", "RebuildTaskMixin", "HumanoidArmorLayerMixin"));
            }
            if (LucentMixinPlugin.doesClassExist("com.simibubi.create.compat.Mods")) {
                LucentMod.LOGGER.info("Found Create", new Object[0]);
                mixins.addAll(Arrays.asList("create.ContraptionEntityMixin"));
            }
        }
        return mixins;
    }

    private static boolean doesClassExist(String classPath) {
        try {
            Class.forName(classPath);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

