/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.mixin;

import com.structureessentials.IGeneratorNearbyStructureHolder;
import com.structureessentials.StructureEssentials;
import com.structureessentials.config.CommonConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public abstract class StructureStartMinDistMixin {
    @Shadow
    public abstract Structure.StructureSettings getModifiedStructureSettings();

    @Inject(method={"generate"}, at={@At(value="RETURN")}, cancellable=true)
    private void checkOtherStructuresNearby(RegistryAccess registryAccess, ChunkGenerator generator, BiomeSource biomeSource, RandomState p_226600_, StructureTemplateManager p_226601_, long p_226602_, ChunkPos p_226603_, int p_226604_, LevelHeightAccessor p_226605_, Predicate<Holder<Biome>> p_226606_, CallbackInfoReturnable<StructureStart> cir) {
        BlockPos center;
        if (cir.getReturnValue() == StructureStart.f_73561_ || !((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistanceEnabled) {
            return;
        }
        if (!(generator instanceof IGeneratorNearbyStructureHolder)) {
            if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistanceLogging) {
                StructureEssentials.LOGGER.warn("Skipping structure minimum distance check, invalid generator: " + generator);
            }
            return;
        }
        IGeneratorNearbyStructureHolder nearbyStructureHolder = (IGeneratorNearbyStructureHolder)generator;
        int distance = ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistance;
        int xzOffset = 3000000 * distance;
        int yOffset = this.getModifiedStructureSettings().f_226691_() == GenerationStep.Decoration.SURFACE_STRUCTURES ? 2000 : 500;
        ResourceLocation regID = ((Registry)registryAccess.m_6632_(Registries.f_256944_).get()).m_7981_((Object)((Structure)this));
        Object name = regID != null ? regID.toString() : "unknown:" + this;
        for (StructurePiece piece : ((StructureStart)cir.getReturnValue()).m_73602_()) {
            center = piece.m_142171_();
            String nearby = nearbyStructureHolder.getNearby(BlockPos.m_121882_((int)((center.m_123341_() + xzOffset) / distance), (int)((center.m_123342_() + yOffset) / distance), (int)((center.m_123343_() + xzOffset) / distance)));
            if (nearby == null && (piece.m_73547_().m_71056_() > 8 || piece.m_73547_().m_71057_() > 8 || piece.m_73547_().m_71058_() > 8)) {
                BlockPos pos;
                Iterator<BlockPos> iterator = StructureStartMinDistMixin.getBoundingBoxCorners(piece.m_73547_()).iterator();
                while (iterator.hasNext() && ((nearby = nearbyStructureHolder.getNearby(BlockPos.m_121882_((int)(((pos = iterator.next()).m_123341_() + xzOffset) / distance), (int)((pos.m_123342_() + yOffset) / distance), (int)((pos.m_123343_() + xzOffset) / distance)))) == null || nearby.equals(name))) {
                }
            }
            if (nearby == null || nearby.equals(name)) continue;
            if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistanceLogging) {
                StructureEssentials.LOGGER.warn("Prevented structure overlap for: " + (String)name + " at: " + center + " existing structure: " + nearby);
            }
            cir.setReturnValue((Object)StructureStart.f_73561_);
            return;
        }
        for (StructurePiece piece : ((StructureStart)cir.getReturnValue()).m_73602_()) {
            center = piece.m_142171_();
            nearbyStructureHolder.setNearby(BlockPos.m_121882_((int)((center.m_123341_() + xzOffset) / distance), (int)((center.m_123342_() + 2000) / distance), (int)((center.m_123343_() + xzOffset) / distance)), (String)name);
            if (piece.m_73547_().m_71056_() <= 8 && piece.m_73547_().m_71057_() <= 8 && piece.m_73547_().m_71058_() <= 8) continue;
            for (BlockPos pos : StructureStartMinDistMixin.getBoundingBoxCorners(piece.m_73547_())) {
                nearbyStructureHolder.setNearby(BlockPos.m_121882_((int)((pos.m_123341_() + xzOffset) / distance), (int)((pos.m_123342_() + 2000) / distance), (int)((pos.m_123343_() + xzOffset) / distance)), (String)name);
            }
        }
    }

    @Unique
    private static List<BlockPos> getBoundingBoxCorners(BoundingBox box) {
        return List.of(new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162398_()), new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162401_()), new BlockPos(box.m_162395_(), box.m_162400_(), box.m_162398_()), new BlockPos(box.m_162395_(), box.m_162400_(), box.m_162401_()), new BlockPos(box.m_162399_(), box.m_162396_(), box.m_162398_()), new BlockPos(box.m_162399_(), box.m_162396_(), box.m_162401_()), new BlockPos(box.m_162399_(), box.m_162400_(), box.m_162398_()), new BlockPos(box.m_162399_(), box.m_162400_(), box.m_162401_()));
    }
}

