/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.client;

import fr.addonslib.api.client.McwColors;
import fr.samlegamer.addonslib.Finder;
import java.util.Map;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;

@OnlyIn(value=Dist.CLIENT)
public class ColorRegistry {
    private final McwColors mcwColors;

    public ColorRegistry(McwColors mcwColors) {
        this.mcwColors = mcwColors;
    }

    public void registryBlockColors(RegisterColorHandlersEvent.Block event) {
        for (Map.Entry<String, Integer> entry : this.mcwColors.getNoColorLeaves().entrySet()) {
            String value = entry.getKey();
            Block block = Finder.findBlock(value);
            event.register((state, view, pos, tintIndex) -> (Integer)entry.getValue(), new Block[]{block});
        }
    }

    public void registryItemColors(RegisterColorHandlersEvent.Item event) {
        for (Map.Entry<String, Integer> entry : this.mcwColors.getNoColorLeaves().entrySet()) {
            String value = entry.getKey();
            Block hedges = Finder.findBlock(value);
            event.register((stack, tintIndex) -> {
                Block block = ((BlockItem)stack.m_41720_()).m_40614_();
                return event.getBlockColors().m_92577_(block.m_49966_(), null, null, tintIndex);
            }, new ItemLike[]{hedges});
        }
    }

    public void registryBlockColorsAverage(RegisterColorHandlersEvent.Block event) {
        for (Map.Entry<String, Integer> entry : this.mcwColors.getNoColorLeaves().entrySet()) {
            String value = entry.getKey();
            Block block = Finder.findBlock(value);
            event.register((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)view, (BlockPos)pos) : FoliageColor.m_46107_((double)0.5, (double)1.0), new Block[]{block});
        }
    }
}

