/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories;

import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.criteria.AccessoryChangedCriterion;
import io.wispforest.accessories.impl.AccessoriesTags;
import io.wispforest.accessories.mixin.CriteriaTriggersAccessor;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Accessories {
    @ApiStatus.Internal
    public static GameRules.Key<GameRules.BooleanValue> RULE_KEEP_ACCESSORY_INVENTORY = null;
    public static final String MODID = "accessories";
    @Nullable
    public static ConfigHolder<AccessoriesConfig> CONFIG_HOLDER = null;
    public static MenuType<AccessoriesMenu> ACCESSORIES_MENU_TYPE;
    public static AccessoryChangedCriterion ACCESSORY_EQUIPPED;
    public static AccessoryChangedCriterion ACCESSORY_UNEQUIPPED;

    public static ResourceLocation of(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static String translation(String path) {
        return "accessories." + path;
    }

    public static AccessoriesConfig getConfig() {
        if (CONFIG_HOLDER == null) {
            return null;
        }
        return (AccessoriesConfig)CONFIG_HOLDER.getConfig();
    }

    public static void setAndSaveConfig(Consumer<AccessoriesConfig> consumer) {
        consumer.accept(Accessories.getConfig());
        CONFIG_HOLDER.save();
    }

    public static boolean attemptOpenScreenPlayer(ServerPlayer player) {
        HitResult result = ProjectileUtil.m_278180_((Entity)player, e -> e instanceof LivingEntity, (double)(player.m_7500_() ? 4.5 : 4.0));
        if (!(result instanceof EntityHitResult)) {
            return false;
        }
        EntityHitResult entityHitResult = (EntityHitResult)result;
        Accessories.openAccessoriesMenu((Player)player, (LivingEntity)entityHitResult.m_82443_());
        return true;
    }

    public static void openAccessoriesMenu(Player player, @Nullable LivingEntity targetEntity) {
        Accessories.openAccessoriesMenu(player, targetEntity, null);
    }

    public static void openAccessoriesMenu(Player player, @Nullable LivingEntity targetEntity, @Nullable ItemStack carriedStack) {
        TriState result;
        if (targetEntity != null && !(result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null)).orElse(false)) {
            return;
        }
        AccessoriesInternals.openAccessoriesMenu(player, targetEntity, carriedStack);
    }

    public static void init() {
        CONFIG_HOLDER = AutoConfig.register(AccessoriesConfig.class, JanksonConfigSerializer::new);
        AllowEntityModificationCallback.EVENT.register((target, player, reference) -> {
            OwnableEntity ownableEntity;
            boolean isOwnersPet;
            EntityType type = target.m_6095_();
            if (type.m_204039_(AccessoriesTags.MODIFIABLE_ENTITY_BLACKLIST)) {
                return TriState.FALSE;
            }
            boolean bl = isOwnersPet = target instanceof OwnableEntity && (ownableEntity = (OwnableEntity)target).m_269323_().equals((Object)player);
            if (isOwnersPet || type.m_204039_(AccessoriesTags.MODIFIABLE_ENTITY_WHITELIST)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
    }

    public static void registerCriteria() {
        ACCESSORY_EQUIPPED = CriteriaTriggersAccessor.accessories$callRegister(new AccessoryChangedCriterion(Accessories.of("equip_accessory")));
        ACCESSORY_UNEQUIPPED = CriteriaTriggersAccessor.accessories$callRegister(new AccessoryChangedCriterion(Accessories.of("unequip_accessory")));
    }

    public static void registerMenuType() {
        ACCESSORIES_MENU_TYPE = AccessoriesInternals.registerMenuType(Accessories.of("accessories_menu"), AccessoriesMenu::of);
    }
}

