/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.menu;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesBasedSlot
extends Slot {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final LivingEntity entity;
    public final AccessoriesContainer accessoriesContainer;

    public AccessoriesBasedSlot(AccessoriesContainer accessoriesContainer, ExpandedSimpleContainer container, int slot, int x, int y) {
        super((Container)container, slot, x, y);
        this.accessoriesContainer = accessoriesContainer;
        this.entity = accessoriesContainer.capability().entity();
    }

    @Nullable
    public static AccessoriesBasedSlot of(LivingEntity livingEntity, SlotType slotType, int x, int y) {
        return AccessoriesBasedSlot.of(livingEntity, slotType, 0, x, y);
    }

    @Nullable
    public static AccessoriesBasedSlot of(LivingEntity livingEntity, SlotType slotType, int slot, int x, int y) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability == null) {
            LOGGER.error("Unable to locate a capability for the given livingEntity meaning it does not have a valid Accessory Inventory [EntityType: {}]", (Object)livingEntity.m_6095_());
            return null;
        }
        Map<String, SlotType> validEntitySlots = EntitySlotLoader.getEntitySlots(livingEntity);
        if (!validEntitySlots.containsKey(slotType.name())) {
            LOGGER.error("Unable to create Accessory Slot due to the given LivingEntity not having the given SlotType bound to it! [EntityType: {}, SlotType: {}]", (Object)livingEntity.m_6095_(), (Object)slotType.name());
            return null;
        }
        AccessoriesContainer container = capability.getContainer(slotType);
        if (container == null) {
            LOGGER.error("Unable to locate the given container for the passed slotType. [SlotType:{}]", (Object)slotType.name());
            return null;
        }
        return new AccessoriesBasedSlot(container, container.getAccessories(), slot, x, y);
    }

    @Deprecated
    public int m_6641_() {
        return super.m_6641_();
    }

    public int m_5866_(ItemStack stack) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        return accessory.maxStackSize(stack);
    }

    public void m_5852_(ItemStack stack) {
        super.m_5852_(stack);
    }

    public boolean m_5857_(ItemStack stack) {
        return AccessoriesAPI.canInsertIntoSlot(stack, SlotReference.of(this.entity, this.accessoriesContainer.getSlotName(), this.m_150661_()));
    }

    public boolean m_8010_(Player player) {
        if (!this.entity.equals((Object)player)) {
            SlotReference ref = this.accessoriesContainer.createReference(this.m_150661_());
            TriState result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(this.entity, player, ref);
            if (!result.orElse(false)) {
                return false;
            }
        }
        return AccessoriesAPI.canUnequip(this.m_7993_(), SlotReference.of(this.entity, this.accessoriesContainer.getSlotName(), this.m_150661_()));
    }

    protected ResourceLocation icon() {
        SlotType slotType = this.accessoriesContainer.slotType();
        return slotType != null ? slotType.icon() : SlotType.EMPTY_SLOT_ICON;
    }

    public List<Component> getTooltipData() {
        ArrayList<Component> tooltipData = new ArrayList<Component>();
        SlotType slotType = this.accessoriesContainer.slotType();
        tooltipData.add((Component)Component.m_237115_((String)Accessories.translation("slot.tooltip.singular")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)slotType.translation()).m_130940_(ChatFormatting.BLUE)));
        return tooltipData;
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        return new Pair((Object)new ResourceLocation("textures/atlas/blocks.png"), (Object)this.icon());
    }
}

