/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.client.MPOATVConstructingVertexConsumer;
import io.wispforest.accessories.client.PostEffectBuffer;
import io.wispforest.accessories.client.gui.AccessoriesInternalSlot;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.awt.Color;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.lwjgl.opengl.GL30;

public class AccessoriesRenderLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final PostEffectBuffer BUFFER = new PostEffectBuffer();
    private static final float increment = 0.1f;
    private static Map<String, Float> brightnessMap = new HashMap<String, Float>();
    private static Map<String, Float> opacityMap = new HashMap<String, Float>();
    private static long lastUpdated20th = 0L;

    public AccessoriesRenderLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AccessoriesScreen accessoriesScreen;
        Slot slot;
        long current20th;
        boolean shouldUpdate;
        AccessoriesConfig.ClientData.HoverOptions highlightOptions = Accessories.getConfig().clientData.hoverOptions;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        float scale = (float)(1.0 + 0.5 * (0.75 + Math.sin((double)System.currentTimeMillis() / 250.0)));
        boolean renderingLines = AccessoriesScreen.COLLECT_ACCESSORY_POSITIONS;
        boolean useCustomerBuffer = AccessoriesScreen.IS_RENDERING_UI_ENTITY;
        if (!renderingLines && !AccessoriesScreen.NOT_VERY_NICE_POSITIONS.isEmpty()) {
            AccessoriesScreen.NOT_VERY_NICE_POSITIONS.clear();
        }
        if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
            bufferSource.m_109911_();
        }
        boolean bl = shouldUpdate = lastUpdated20th != (current20th = calendar.getTimeInMillis() / 50L);
        if (shouldUpdate) {
            lastUpdated20th = current20th;
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        AccessoriesInternalSlot selected = null;
        if (screen instanceof AccessoriesScreen && (slot = (accessoriesScreen = (AccessoriesScreen)screen).getHoveredSlot()) instanceof AccessoriesInternalSlot) {
            AccessoriesInternalSlot slot2;
            selected = slot2 = (AccessoriesInternalSlot)slot;
        }
        for (Map.Entry<String, AccessoriesContainer> entry : capability.getContainers().entrySet()) {
            AccessoriesContainer container = entry.getValue();
            ExpandedSimpleContainer accessories = container.getAccessories();
            ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
            boolean containerSelected = selected != null && selected.accessoriesContainer.slotType() == container.slotType();
            for (int i = 0; i < accessories.m_6643_(); ++i) {
                AccessoryRenderer renderer;
                boolean isSelected;
                boolean bl2 = isSelected = containerSelected && selected.m_150661_() == i;
                if (shouldUpdate) {
                    Float currentBrightness = brightnessMap.getOrDefault(entry.getKey() + i, Float.valueOf(1.0f));
                    Float currentOpacity = opacityMap.getOrDefault(entry.getKey() + i, Float.valueOf(1.0f));
                    if (selected != null && !isSelected) {
                        brightnessMap.put(entry.getKey() + i, Float.valueOf(Math.max(highlightOptions.unHoveredOptions.darkenedBrightness, currentBrightness.floatValue() - 0.1f)));
                        opacityMap.put(entry.getKey() + i, Float.valueOf(Math.max(highlightOptions.unHoveredOptions.darkenedOpacity, currentOpacity.floatValue() - 0.1f)));
                    } else {
                        brightnessMap.put(entry.getKey() + i, Float.valueOf(Math.min(1.0f, currentBrightness.floatValue() + 0.1f)));
                        opacityMap.put(entry.getKey() + i, Float.valueOf(Math.min(1.0f, currentOpacity.floatValue() + 0.1f)));
                    }
                }
                ItemStack stack = accessories.m_8020_(i);
                ItemStack cosmeticStack = cosmetics.m_8020_(i);
                if (!cosmeticStack.m_41619_()) {
                    stack = cosmeticStack;
                }
                if (stack.m_41619_() || (renderer = AccessoriesRendererRegistry.getRender(stack)) == null || !renderer.shouldRender(container.shouldRender(i))) continue;
                poseStack.m_85836_();
                MPOATVConstructingVertexConsumer mpoatv = new MPOATVConstructingVertexConsumer();
                MutableBoolean bufferedGrabbedFlag = new MutableBoolean(false);
                MultiBufferSource innerBufferSource = renderType -> {
                    bufferedGrabbedFlag.setValue(true);
                    return useCustomerBuffer ? VertexMultiConsumer.m_86168_((VertexConsumer)multiBufferSource.m_6299_(renderType), (VertexConsumer)mpoatv) : multiBufferSource.m_6299_(renderType);
                };
                if (!AccessoriesScreen.IS_RENDERING_UI_ENTITY || isSelected || selected == null || highlightOptions.unHoveredOptions.renderUnHovered) {
                    renderer.render(stack, SlotReference.of(entity, container.getSlotName(), i), poseStack, this.m_117386_(), innerBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
                float[] colorValues = null;
                if (useCustomerBuffer && bufferedGrabbedFlag.getValue().booleanValue()) {
                    if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
                        MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
                        if (highlightOptions.hoveredOptions.brightenHovered && isSelected) {
                            if (calendar.get(2) + 1 == 5 && calendar.get(5) == 16) {
                                float hue = (float)((double)System.currentTimeMillis() / 20.0 % 360.0 / 360.0);
                                Color color = new Color(Mth.m_14169_((float)hue, (float)1.0f, (float)1.0f));
                                colorValues = new float[]{(float)color.getRed() / 128.0f, (float)color.getGreen() / 128.0f, (float)color.getBlue() / 128.0f, 1.0f};
                            } else {
                                float mul = highlightOptions.hoveredOptions.cycleBrightness ? scale : 1.5f;
                                colorValues = new float[]{mul, mul, mul, 1.0f};
                            }
                        } else if (highlightOptions.unHoveredOptions.darkenUnHovered) {
                            Float darkness = brightnessMap.getOrDefault(entry.getKey() + i, Float.valueOf(1.0f));
                            colorValues = new float[]{darkness.floatValue(), darkness.floatValue(), darkness.floatValue(), opacityMap.getOrDefault(entry.getKey() + i, Float.valueOf(1.0f)).floatValue()};
                        }
                        if (colorValues != null) {
                            BUFFER.beginWrite(true, 256);
                            bufferSource.m_109911_();
                            BUFFER.endWrite();
                            BUFFER.draw(colorValues);
                            RenderTarget frameBuffer = BUFFER.buffer();
                            GlStateManager._glBindFramebuffer((int)36008, (int)frameBuffer.f_83920_);
                            GL30.glBlitFramebuffer((int)0, (int)0, (int)frameBuffer.f_83915_, (int)frameBuffer.f_83916_, (int)0, (int)0, (int)frameBuffer.f_83915_, (int)frameBuffer.f_83916_, (int)256, (int)9728);
                            Minecraft.m_91087_().m_91385_().m_83947_(false);
                        } else {
                            bufferSource.m_109911_();
                        }
                    }
                    if (renderingLines && AccessoriesScreen.IS_RENDERING_LINE_TARGET) {
                        AccessoriesScreen.NOT_VERY_NICE_POSITIONS.put(container.getSlotName() + i, mpoatv.meanPos());
                    }
                }
                poseStack.m_85849_();
            }
        }
    }
}

