/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AccessoriesInternalSlot
extends AccessoriesBasedSlot {
    public final int menuIndex;
    public final boolean isCosmetic;
    private Function<AccessoriesInternalSlot, Boolean> isActive = slot -> true;
    private Function<AccessoriesInternalSlot, Boolean> isAccessible = slot -> true;

    public AccessoriesInternalSlot(int menuIndex, AccessoriesContainer container, boolean isCosmetic, int slot2, int x, int y) {
        super(container, isCosmetic ? container.getCosmeticAccessories() : container.getAccessories(), slot2, x, y);
        this.menuIndex = menuIndex;
        this.isCosmetic = isCosmetic;
    }

    public AccessoriesInternalSlot isActive(Function<AccessoriesInternalSlot, Boolean> isActive) {
        this.isActive = isActive;
        return this;
    }

    public AccessoriesInternalSlot isAccessible(Function<AccessoriesInternalSlot, Boolean> isAccessible) {
        this.isAccessible = isAccessible;
        return this;
    }

    @Override
    protected ResourceLocation icon() {
        return this.isCosmetic ? Accessories.of("gui/slot/cosmetic") : super.icon();
    }

    @Override
    public List<Component> getTooltipData() {
        ArrayList<Component> tooltipData = new ArrayList<Component>();
        String key = this.isCosmetic ? "cosmetic_" : "";
        SlotType slotType = this.accessoriesContainer.slotType();
        tooltipData.add((Component)Component.m_237115_((String)Accessories.translation(key + "slot.tooltip.singular")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)slotType.translation()).m_130940_(ChatFormatting.BLUE)));
        return tooltipData;
    }

    @Override
    public void m_5852_(ItemStack stack) {
        ItemStack prevStack = this.m_7993_();
        super.m_5852_(stack);
    }

    @Override
    public boolean m_5857_(ItemStack stack) {
        return this.isAccessible.apply(this) != false && super.m_5857_(stack);
    }

    @Override
    public boolean m_8010_(Player player) {
        return this.isAccessible.apply(this) != false && (this.isCosmetic || super.m_8010_(player));
    }

    public boolean m_150651_(Player player) {
        return this.isAccessible.apply(this) != false && super.m_150651_(player);
    }

    public boolean m_6659_() {
        return this.isActive.apply(this);
    }
}

