/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.MinecraftEndecs;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.impl.SlotTypeImpl;
import io.wispforest.accessories.networking.BaseAccessoriesPacket;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public record SyncData(List<SlotType> slotTypes, Map<EntityType<?>, Set<String>> entitySlots, Set<SlotGroup> slotGroups, Set<String> uniqueGroups, Map<String, ExtraSlotTypeProperties> uniqueExtraProperties) implements BaseAccessoriesPacket
{
    public static Endec<SyncData> ENDEC = StructEndecBuilder.of((StructField)SlotTypeImpl.ENDEC.listOf().fieldOf("slotTypes", SyncData::slotTypes), (StructField)Endec.map(MinecraftEndecs.ofRegistry(BuiltInRegistries.f_256780_), (Endec)Endec.STRING.setOf()).fieldOf("entitySlots", SyncData::entitySlots), (StructField)SlotGroupImpl.ENDEC.setOf().fieldOf("slotGroups", SyncData::slotGroups), (StructField)Endec.STRING.setOf().fieldOf("uniqueGroups", SyncData::uniqueGroups), (StructField)ExtraSlotTypeProperties.ENDEC.mapOf().fieldOf("uniqueExtraProperties", SyncData::uniqueExtraProperties), SyncData::new);

    public static SyncData create() {
        Map<String, SlotType> allSlotTypes = SlotTypeLoader.INSTANCE.getSlotTypes(false);
        Map<EntityType<?>, Map<String, SlotType>> entitySlotData = EntitySlotLoader.INSTANCE.getEntitySlotData(false);
        HashMap entitySlots = new HashMap();
        for (Map.Entry<EntityType<?>, Map<String, SlotType>> entry : entitySlotData.entrySet()) {
            entitySlots.put(entry.getKey(), entry.getValue().keySet());
        }
        HashSet<SlotGroup> slotGroups = new HashSet<SlotGroup>();
        slotGroups.addAll(SlotGroupLoader.INSTANCE.getGroups(false, false));
        return new SyncData(List.copyOf(allSlotTypes.values()), entitySlots, slotGroups, UniqueSlotHandling.getGroups(false), ExtraSlotTypeProperties.getProperties(false));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Player player) {
        HashMap<String, SlotType> slotTypes = new HashMap<String, SlotType>();
        for (SlotType slotType2 : this.slotTypes()) {
            slotTypes.put(slotType2.name(), slotType2);
        }
        SlotTypeLoader.INSTANCE.setSlotType(slotTypes);
        UniqueSlotHandling.buildClientSlotReferences();
        HashMap entitySlotTypes = new HashMap();
        for (Map.Entry<EntityType<?>, Set<String>> entry : this.entitySlots().entrySet()) {
            Map<String, SlotType> map = entry.getValue().stream().map(slotTypes::get).collect(Collectors.toUnmodifiableMap(SlotType::name, slotType -> slotType));
            entitySlotTypes.put(entry.getKey(), map);
        }
        EntitySlotLoader.INSTANCE.setEntitySlotData(entitySlotTypes);
        Map<String, SlotGroup> map = this.slotGroups().stream().collect(Collectors.toUnmodifiableMap(SlotGroup::name, group -> group));
        SlotGroupLoader.INSTANCE.setGroups(map);
        UniqueSlotHandling.setClientGroups(this.uniqueGroups());
        ExtraSlotTypeProperties.setClientPropertyMap(this.uniqueExtraProperties());
    }
}

