/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final SlopeType type;
    private final boolean ySlope;

    public FramedSlopeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (this.type == SlopeType.HORIZONTAL) {
            if (!this.ySlope && quad.m_111306_() == this.dir.m_122424_()) {
                QuadModifier.geometry(quad).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).export(quadMap.get(null));
            } else if (this.ySlope && quadDir == this.dir.m_122427_()) {
                QuadModifier.geometry(quad).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).export(quadMap.get(null));
            } else if (Utils.isY(quadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 1.0f, 0.0f)).export(quadMap.get(quadDir));
            }
        } else {
            boolean top;
            boolean bl = top = this.type == SlopeType.TOP;
            if (!this.ySlope && quadDir == this.dir.m_122424_()) {
                QuadModifier.geometry(quad).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).export(quadMap.get(null));
            } else if (this.ySlope && Utils.isY(quadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.makeVerticalSlope(this.dir.m_122424_(), 45.0f)).export(quadMap.get(null));
            } else if (quadDir == this.dir.m_122427_() || quadDir == this.dir.m_122428_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
            }
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_SLOPE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

