/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiKeyMappings;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.util.RecipeViewer;

public final class JeiCompat {
    public static final Component MSG_INVALID_RECIPE = Utils.translate("msg", "framing_saw.transfer.invalid_recipe");
    public static final Component MSG_TRANSFER_NOT_IMPLEMENTED = Utils.translate("msg", "framing_saw.transfer.not_implemented");
    private static boolean loadedClient = false;

    public static void init() {
        if (FMLEnvironment.dist.isClient() && ModList.get().isLoaded("jei") && !ModList.get().isLoaded("rei_plugin_compatibilities")) {
            loadedClient = true;
        }
    }

    public static boolean isLoaded() {
        return loadedClient;
    }

    public static RecipeViewer.LookupTarget isShowRecipePressed(int keyCode, int scanCode) {
        if (loadedClient) {
            return GuardedAccess.isShowRecipePressed(keyCode, scanCode);
        }
        return null;
    }

    public static boolean handleShowRecipeRequest(ItemStack result, RecipeViewer.LookupTarget target) {
        if (loadedClient) {
            return GuardedAccess.handleButtonRecipeRequest(result, target);
        }
        return false;
    }

    private JeiCompat() {
    }

    static final class GuardedAccess {
        private static IJeiRuntime runtime = null;
        private static IJeiKeyMappings keys = null;

        public static RecipeViewer.LookupTarget isShowRecipePressed(int keyCode, int scanCode) {
            Preconditions.checkNotNull((Object)runtime, (Object)"Runtime not set");
            InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
            if (keys.getShowRecipe().isActiveAndMatches(key)) {
                return RecipeViewer.LookupTarget.RECIPE;
            }
            if (keys.getShowUses().isActiveAndMatches(key)) {
                return RecipeViewer.LookupTarget.USAGE;
            }
            return null;
        }

        private static boolean handleButtonRecipeRequest(ItemStack result, RecipeViewer.LookupTarget target) {
            Preconditions.checkNotNull((Object)runtime, (Object)"Runtime not set");
            IRecipesGui gui = runtime.getRecipesGui();
            IJeiHelpers helpers = runtime.getJeiHelpers();
            IIngredientManager ingredients = helpers.getIngredientManager();
            IFocusFactory focusFactory = helpers.getFocusFactory();
            Optional ingredient = ingredients.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)result);
            if (ingredient.isPresent()) {
                RecipeIngredientRole role = switch (target) {
                    default -> throw new IncompatibleClassChangeError();
                    case RecipeViewer.LookupTarget.RECIPE -> RecipeIngredientRole.OUTPUT;
                    case RecipeViewer.LookupTarget.USAGE -> RecipeIngredientRole.INPUT;
                };
                IFocus focus = focusFactory.createFocus(role, (ITypedIngredient)ingredient.get());
                gui.show(focus);
                return true;
            }
            return false;
        }

        public static void acceptRuntime(IJeiRuntime runtime) {
            GuardedAccess.runtime = runtime;
            keys = runtime != null ? runtime.getKeyMappings() : null;
        }

        public static IJeiRuntime getRuntime() {
            return runtime;
        }

        private GuardedAccess() {
        }
    }
}

