/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.common.config;

import cofh.core.common.config.IBaseConfig;
import cofh.core.common.item.EnergyContainerItem;
import cofh.core.common.item.FluidContainerItem;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.innovation.common.item.RFMagnetItem;
import cofh.thermal.lib.common.item.EnergyContainerItemAugmentable;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public class TInoToolConfig
implements IBaseConfig {
    private Supplier<Integer> rfDrillMaxEnergy;
    private Supplier<Integer> rfDrillTransfer;
    private Supplier<Integer> rfDrillEnergyPerUse;
    private Supplier<Integer> rfSawMaxEnergy;
    private Supplier<Integer> rfSawTransfer;
    private Supplier<Integer> rfSawEnergyPerUse;
    private Supplier<Integer> rfCapacitorMaxEnergy;
    private Supplier<Integer> rfCapacitorTransfer;
    private Supplier<Integer> rfMagnetMaxEnergy;
    private Supplier<Integer> rfMagnetTransfer;
    private Supplier<Integer> rfMagnetEnergyPerItem;
    private Supplier<Integer> rfMagnetEnergyPerUse;
    private Supplier<Boolean> rfMagnetObeyPickupDelay;
    private Supplier<Integer> fluidReservoirCapacity;
    private Supplier<Integer> potionInfuserCapacity;
    private Supplier<Integer> potionQuiverCapacity;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Tools");
        builder.push("Drill");
        this.rfDrillMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Fluxbore.").defineInRange("Base Capacity", 50000, 1000, 10000000);
        this.rfDrillTransfer = builder.comment("This sets the base RF/t transfer for the Fluxbore.").defineInRange("Base Transfer", 1000, 1, 10000000);
        this.rfDrillEnergyPerUse = builder.comment("This sets the energy required to break a single block.").defineInRange("Energy Per Block", 200, 1, 10000);
        builder.pop();
        builder.push("Saw");
        this.rfSawMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Fluxsaw.").defineInRange("Base Capacity", 50000, 1000, 10000000);
        this.rfSawTransfer = builder.comment("This sets the base RF/t transfer for the Fluxsaw.").defineInRange("Base Transfer", 1000, 1, 10000000);
        this.rfSawEnergyPerUse = builder.comment("This sets the energy required to break a single block.").defineInRange("Energy Per Block", 200, 1, 10000);
        builder.pop();
        builder.push("Capacitor");
        this.rfCapacitorMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Flux Capacitor.").defineInRange("Base Capacity", 500000, 1000, 10000000);
        this.rfCapacitorTransfer = builder.comment("This sets the base RF/t transfer for the Flux Capacitor.").defineInRange("Base Transfer", 1000, 1, 10000000);
        builder.pop();
        builder.push("Magnet");
        this.rfMagnetMaxEnergy = builder.comment("This sets the maximum base RF capacity for the FluxoMagnet.").defineInRange("Base Capacity", 50000, 1000, 10000000);
        this.rfMagnetTransfer = builder.comment("This sets the base RF/t transfer for the FluxoMagnet.").defineInRange("Base Transfer", 1000, 1, 10000000);
        this.rfMagnetEnergyPerItem = builder.comment("This sets the energy used per item picked up.").defineInRange("Energy Per Item", 25, 1, 1000);
        this.rfMagnetEnergyPerUse = builder.comment("This sets the energy required to use (right click) the FluxoMagnet.").defineInRange("Energy Per Use", 200, 1, 10000);
        this.rfMagnetObeyPickupDelay = builder.comment("If TRUE, the FluxoMagnet will obey Item Pickup Delay.").define("Obey Item Pickup Delay", true);
        builder.pop();
        builder.push("Reservoir");
        this.fluidReservoirCapacity = builder.comment("This sets the maximum base fluid capacity for the Reservoir.").defineInRange("Base Capacity", 20000, 1000, 10000000);
        builder.pop();
        builder.push("Potion Infuser");
        this.potionInfuserCapacity = builder.comment("This sets the maximum base fluid capacity for the Potion Infuser.").defineInRange("Base Capacity", 4000, 1000, 10000000);
        builder.pop();
        builder.push("Potion Quiver");
        this.potionQuiverCapacity = builder.comment("This sets the maximum base fluid capacity for the Alchemical Quiver.").defineInRange("Base Capacity", 4000, 1000, 10000000);
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        this.setEnergyParams("flux_drill", this.rfDrillMaxEnergy.get(), this.rfDrillTransfer.get());
        this.setEnergyParams("flux_saw", this.rfSawMaxEnergy.get(), this.rfSawTransfer.get());
        this.setEnergyParams("flux_capacitor", this.rfCapacitorMaxEnergy.get(), this.rfCapacitorTransfer.get());
        this.setEnergyParams("flux_magnet", this.rfMagnetMaxEnergy.get(), this.rfMagnetTransfer.get());
        this.setFluidCapacity("fluid_reservoir", this.fluidReservoirCapacity.get());
        this.setFluidCapacity("potion_infuser", this.potionInfuserCapacity.get());
        this.setFluidCapacity("potion_quiver", this.potionQuiverCapacity.get());
        this.setEnergyPerUse("flux_drill", this.rfDrillEnergyPerUse.get());
        this.setEnergyPerUse("flux_saw", this.rfSawEnergyPerUse.get());
        this.setMagnetParameters("flux_magnet", this.rfMagnetObeyPickupDelay.get(), this.rfMagnetEnergyPerItem.get(), this.rfMagnetEnergyPerUse.get());
    }

    private void setEnergyParams(String id, int energy, int transfer) {
        Item item = (Item)ThermalCore.ITEMS.get(id);
        if (item instanceof EnergyContainerItem) {
            EnergyContainerItem ec = (EnergyContainerItem)item;
            ec.setMaxEnergy(energy);
            ec.setMaxTransfer(transfer);
        }
    }

    private void setFluidCapacity(String id, int capacity) {
        Item item = (Item)ThermalCore.ITEMS.get(id);
        if (item instanceof FluidContainerItem) {
            FluidContainerItem fc = (FluidContainerItem)item;
            fc.setFluidCapacity(capacity);
        }
    }

    private void setEnergyPerUse(String id, int energyPerUse) {
        Item item = (Item)ThermalCore.ITEMS.get(id);
        if (item instanceof EnergyContainerItemAugmentable) {
            EnergyContainerItemAugmentable ec = (EnergyContainerItemAugmentable)item;
            ec.setEnergyPerUse(energyPerUse);
        }
    }

    private void setMagnetParameters(String id, boolean obeyPickupDelay, int energyPerItem, int energyPerUse) {
        Item item = (Item)ThermalCore.ITEMS.get(id);
        if (item instanceof RFMagnetItem) {
            RFMagnetItem mag = (RFMagnetItem)item;
            mag.setObeyItemPickupDelay(obeyPickupDelay);
            mag.setEnergyPerItem(energyPerItem);
            mag.setEnergyPerUse(energyPerUse);
        }
    }
}

