/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class SendManyChunksPacket
extends BaseS2CMessage {
    public final ResourceKey<Level> dimension;
    public final UUID teamId;
    public final List<SendChunkPacket.SingleChunk> chunks;

    public SendManyChunksPacket(ResourceKey<Level> dimension, UUID teamId, List<SendChunkPacket.SingleChunk> chunks) {
        this.dimension = dimension;
        this.teamId = teamId;
        this.chunks = chunks;
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_ALL_CHUNKS;
    }

    SendManyChunksPacket(FriendlyByteBuf buf) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
        this.teamId = buf.m_130259_();
        this.chunks = buf.m_236845_(buf1 -> new SendChunkPacket.SingleChunk((FriendlyByteBuf)buf1, this.teamId));
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130077_(this.teamId);
        buf.m_236828_(this.chunks, (buf1, chunk) -> chunk.write((FriendlyByteBuf)buf1, this.teamId));
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunksClient.INSTANCE.updateChunksFromServer(this.dimension, this.teamId, this.chunks);
    }
}

