/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.file;

import DistantHorizons.libraries.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.seibel.distanthorizons.core.config.ConfigHandler;
import com.seibel.distanthorizons.core.config.file.ConfigTypeConverters;
import com.seibel.distanthorizons.core.config.types.AbstractConfigBase;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.ReentrantLock;

public class ConfigFileHandler {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public final Path configPath;
    private final CommentedFileConfig nightConfig;
    private final ReentrantLock readWriteLock = new ReentrantLock();

    public ConfigFileHandler(Path configPath) {
        this.configPath = configPath;
        this.nightConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath.toFile()).sync().build();
    }

    public void saveToFile() {
        this.saveToFile(this.nightConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(CommentedFileConfig nightConfig) {
        try {
            this.readWriteLock.lock();
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                ConfigFileHandler.reCreateFile(this.configPath);
            }
            this.loadNightConfig(nightConfig);
            for (AbstractConfigBase<?> entry : ConfigHandler.INSTANCE.configBaseList) {
                if (!ConfigEntry.class.isAssignableFrom(entry.getClass())) continue;
                this.createComment((ConfigEntry)entry, nightConfig);
                this.saveEntry((ConfigEntry)entry, nightConfig);
            }
            try {
                nightConfig.save();
            }
            catch (Exception e) {
                SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class).crashMinecraft("Failed to save config at [" + this.configPath + "]", e);
            }
        }
        finally {
            this.readWriteLock.unlock();
        }
    }

    public void loadFromFile() {
        try {
            this.readWriteLock.lock();
            int currentCfgVersion = 3;
            try {
                CommentedFileConfig tmpNightConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath.toFile()).build();
                tmpNightConfig.load();
                currentCfgVersion = (Integer)tmpNightConfig.get("_version");
                tmpNightConfig.close();
            }
            catch (Exception tmpNightConfig) {
                // empty catch block
            }
            if (currentCfgVersion != 3) {
                if (currentCfgVersion > 3) {
                    LOGGER.warn("Found config version [" + currentCfgVersion + "] which is newer than current mods config version of [" + 3 + "]. You may have downgraded the mod and items may have been moved, you have been warned", new Object[0]);
                } else {
                    LOGGER.warn("DistantHorizons config is of an older version, currently there is no config updater... so resetting config", new Object[0]);
                    try {
                        Files.delete(this.configPath);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to delete outdated config file at: [" + this.configPath + "], error: [" + e.getMessage() + "].", e);
                    }
                }
            }
            this.loadFromFile(this.nightConfig);
            this.nightConfig.set("_version", (Object)3);
        }
        finally {
            this.readWriteLock.unlock();
        }
    }

    private void loadFromFile(CommentedFileConfig nightConfig) {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            this.loadNightConfig(nightConfig);
        } else {
            ConfigFileHandler.reCreateFile(this.configPath);
        }
        for (AbstractConfigBase<?> entry : ConfigHandler.INSTANCE.configBaseList) {
            if (!ConfigEntry.class.isAssignableFrom(entry.getClass()) || !entry.getAppearance().showInFile) continue;
            this.createComment((ConfigEntry)entry, nightConfig);
            this.loadEntry((ConfigEntry)entry, nightConfig);
        }
        try {
            nightConfig.save();
        }
        catch (Exception e) {
            SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class).crashMinecraft("Failed to save config at [" + this.configPath + "]", e);
        }
    }

    public void saveEntry(ConfigEntry<?> entry) {
        this.saveEntry(entry, this.nightConfig);
        this.nightConfig.save();
    }

    public void saveEntry(ConfigEntry<?> entry, CommentedFileConfig workConfig) {
        if (!entry.getAppearance().showInFile) {
            return;
        }
        if (entry.getTrueValue() == null) {
            throw new IllegalArgumentException("BlockBiomeWrapperPair [" + entry.getNameAndCategory() + "] is null, this may be a problem with [" + "DistantHorizons" + "]. Please contact the authors.");
        }
        workConfig.set(entry.getNameAndCategory(), ConfigTypeConverters.attemptToConvertToString(entry.getType(), entry.getTrueValue()));
    }

    public void loadEntry(ConfigEntry<?> entry) {
        this.loadEntry(entry, this.nightConfig);
    }

    public <T> void loadEntry(ConfigEntry<T> entry, CommentedFileConfig nightConfig) {
        if (!entry.getAppearance().showInFile) {
            return;
        }
        if (!nightConfig.contains(entry.getNameAndCategory())) {
            this.saveEntry(entry, nightConfig);
            return;
        }
        try {
            Object value;
            if (entry.getType().isEnum()) {
                entry.setWithoutFiringEvents(nightConfig.getEnum(entry.getNameAndCategory(), entry.getType()));
                return;
            }
            Class<?> expectedValueClass = entry.getType();
            Object convertedValue = ConfigTypeConverters.attemptToConvertFromString(expectedValueClass, value = nightConfig.get(entry.getNameAndCategory()));
            if (!convertedValue.getClass().equals(expectedValueClass)) {
                LOGGER.error("Unable to convert config value [" + value + "] from [" + (value != null ? value.getClass() : "NULL") + "] to [" + expectedValueClass + "] for config [" + entry.name + "], the default config value will be used instead [" + entry.getDefaultValue() + "]. Make sure a converter is defined in [" + ConfigTypeConverters.class.getSimpleName() + "].", new Object[0]);
                convertedValue = entry.getDefaultValue();
            }
            entry.setWithoutFiringEvents(convertedValue);
            if (entry.getTrueValue() == null) {
                LOGGER.warn("BlockBiomeWrapperPair [" + entry.getNameAndCategory() + "] returned as null from the config. Using default value.", new Object[0]);
                entry.setWithoutFiringEvents(entry.getDefaultValue());
            }
        }
        catch (Exception e) {
            LOGGER.warn("BlockBiomeWrapperPair [" + entry.getNameAndCategory() + "] had an invalid value when loading the config. Using default value.", new Object[0]);
            entry.setWithoutFiringEvents(entry.getDefaultValue());
        }
    }

    public void createComment(ConfigEntry<?> entry) {
        this.createComment(entry, this.nightConfig);
    }

    public void createComment(ConfigEntry<?> entry, CommentedFileConfig nightConfig) {
        if (!entry.getAppearance().showInFile || entry.getComment() == null) {
            return;
        }
        String comment = entry.getComment().replaceAll("\n", "\n ").trim();
        comment = "\n " + comment;
        nightConfig.setComment(entry.getNameAndCategory(), comment);
    }

    public void loadNightConfig() {
        this.loadNightConfig(this.nightConfig);
    }

    public void loadNightConfig(CommentedFileConfig nightConfig) {
        try {
            try {
                if (!Files.exists(this.configPath, new LinkOption[0])) {
                    Files.createFile(this.configPath, new FileAttribute[0]);
                }
                nightConfig.load();
            }
            catch (Exception e) {
                LOGGER.warn("Loading file failed because of this expectation:\n" + e, new Object[0]);
                ConfigFileHandler.reCreateFile(this.configPath);
                nightConfig.load();
            }
        }
        catch (Exception e) {
            LOGGER.error("File creation failed at [" + this.configPath + "], error: [" + e.getMessage() + "].", e);
            IMinecraftClientWrapper mc = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
            mc.crashMinecraft("Loading file and resetting config file failed at path [" + this.configPath + "]. Please check the file is ok and you have the permissions", e);
        }
    }

    public static void reCreateFile(Path path) {
        try {
            Files.deleteIfExists(path);
            if (!path.getParent().toFile().exists()) {
                Files.createDirectory(path.getParent(), new FileAttribute[0]);
            }
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Unable to recreate config file, error: [" + e.getMessage() + "].", e);
        }
    }
}

