/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pooling;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EMinecraftColor;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pooling.AbstractPhantomArrayList;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListCheckout;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.coreapi.ModInfo;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhantomArrayListPool {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final int PHANTOM_REF_CHECK_TIME_IN_MS = 5000;
    private static final ThreadPoolExecutor RECYCLER_THREAD = ThreadUtil.makeSingleDaemonThreadPool("Phantom Array Recycler");
    private static final ArrayList<PhantomArrayListPool> POOL_LIST = new ArrayList();
    private static final boolean LOG_ARRAY_RECOVERY = ModInfo.IS_DEV_BUILD;
    private static boolean lowMemoryWarningLogged = false;
    public final String name;
    public final boolean logGarbageCollectedStacks;
    public final ConcurrentHashMap<Reference<? extends AbstractPhantomArrayList>, PhantomArrayListCheckout> phantomRefToCheckout = new ConcurrentHashMap();
    public final ReferenceQueue<AbstractPhantomArrayList> phantomRefQueue = new ReferenceQueue();
    private final ConcurrentLinkedQueue<SoftReference<PhantomArrayListCheckout>> pooledCheckoutsRefs = new ConcurrentLinkedQueue();
    private final AtomicInteger totalByteArrayCountRef = new AtomicInteger(0);
    private final AtomicInteger totalShortArrayCountRef = new AtomicInteger(0);
    private final AtomicInteger totalLongArrayCountRef = new AtomicInteger(0);
    private long lastBytePoolSizeInBytes = -1L;
    private long lastShortPoolSizeInBytes = -1L;
    private long lastLongPoolSizeInBytes = -1L;
    private int lastBytePoolCount = 0;
    private int lastShortPoolCount = 0;
    private int lastLongPoolCount = 0;
    private int lastCheckoutPoolCount = 0;
    private boolean clearLastRefPoolSizes = false;

    public PhantomArrayListPool(String name) {
        this(name, false);
    }

    public PhantomArrayListPool(String name, boolean logGarbageCollectedStacks) {
        POOL_LIST.add(this);
        this.name = name;
        this.logGarbageCollectedStacks = logGarbageCollectedStacks;
    }

    public PhantomArrayListCheckout checkoutArrays(int byteArrayCount, int shortArrayCount, int longArrayCount) {
        int i;
        PhantomArrayListCheckout checkout = null;
        while (checkout == null) {
            SoftReference<PhantomArrayListCheckout> checkoutRef = this.pooledCheckoutsRefs.poll();
            if (checkoutRef == null) {
                checkout = new PhantomArrayListCheckout(this);
                checkout.onCheckout();
                continue;
            }
            checkout = checkoutRef.get();
            if (checkout != null) {
                checkout.onCheckout();
                continue;
            }
            if (!lowMemoryWarningLogged) {
                lowMemoryWarningLogged = true;
                String message = (Object)((Object)EMinecraftColor.ORANGE) + "Distant Horizons: Insufficient memory detected." + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING) + "\nThis may cause stuttering or crashing. \nPotential causes: \n1. your allocated memory isn't high enough \n2. your DH CPU preset is too high \n3. your DH quality preset is too high \n4. you have other memory hungry mod(s)";
                LOGGER.warn(message, new Object[0]);
                if (Config.Common.Logging.Warning.showPoolInsufficientMemoryWarning.get().booleanValue()) {
                    ClientApi.INSTANCE.showChatMessageNextFrame(message);
                }
            }
            this.clearLastRefPoolSizes = true;
        }
        for (i = checkout.getByteArrayCount(); i < byteArrayCount; ++i) {
            checkout.addByteArrayList(this.createEmptyByteArrayList());
        }
        for (i = checkout.getShortArrayCount(); i < shortArrayCount; ++i) {
            checkout.addShortArrayList(this.createEmptyShortArrayList());
        }
        for (i = checkout.getLongArrayCount(); i < longArrayCount; ++i) {
            checkout.addLongArrayListRef(this.createEmptyLongArrayList());
        }
        return checkout;
    }

    private ByteArrayList createEmptyByteArrayList() {
        this.totalByteArrayCountRef.getAndIncrement();
        return new ByteArrayList(0);
    }

    private ShortArrayList createEmptyShortArrayList() {
        this.totalShortArrayCountRef.getAndIncrement();
        return new ShortArrayList(0);
    }

    private LongArrayList createEmptyLongArrayList() {
        this.totalLongArrayCountRef.getAndIncrement();
        return new LongArrayList(0);
    }

    private static void runPhantomReferenceCleanupLoop() {
        block4: while (true) {
            ArrayList<Pair<String, AtomicInteger>> allocationStackTraceCountPairList = new ArrayList<Pair<String, AtomicInteger>>();
            try {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int poolIndex = 0;
                while (true) {
                    if (poolIndex >= POOL_LIST.size()) continue block4;
                    PhantomArrayListPool pool = POOL_LIST.get(poolIndex);
                    int returnedByteArrayCount = 0;
                    int returnedShortArrayCount = 0;
                    int returnedLongArrayCount = 0;
                    int checkoutCount = 0;
                    allocationStackTraceCountPairList.clear();
                    Reference<AbstractPhantomArrayList> phantomRef = pool.phantomRefQueue.poll();
                    while (phantomRef != null) {
                        PhantomArrayListCheckout checkout = pool.phantomRefToCheckout.remove(phantomRef);
                        if (checkout != null) {
                            returnedByteArrayCount += checkout.getByteArrayCount();
                            returnedShortArrayCount += checkout.getShortArrayCount();
                            returnedLongArrayCount += checkout.getLongArrayCount();
                            ++checkoutCount;
                            pool.returnCheckout(checkout);
                            if (pool.logGarbageCollectedStacks && checkout.allocationStackTrace != null) {
                                PhantomArrayListPool.putAndIncrementTrackingString(checkout.allocationStackTrace, allocationStackTraceCountPairList);
                            }
                        } else {
                            LOGGER.warn("Pool: [" + pool.name + "]. Unable to find checkout for phantom reference [" + phantomRef + "], arrays will need to be recreated.", new Object[0]);
                        }
                        phantomRef = pool.phantomRefQueue.poll();
                    }
                    if ((LOG_ARRAY_RECOVERY || pool.logGarbageCollectedStacks) && (checkoutCount != 0 || returnedByteArrayCount != 0 || returnedShortArrayCount != 0 || returnedLongArrayCount != 0)) {
                        LOGGER.warn("Pool: [" + pool.name + "] phantom recovery. Returned checkouts:[" + F3Screen.NUMBER_FORMAT.format(checkoutCount) + "], byte:[" + F3Screen.NUMBER_FORMAT.format(returnedByteArrayCount) + "], short:[" + F3Screen.NUMBER_FORMAT.format(returnedShortArrayCount) + "], long:[" + F3Screen.NUMBER_FORMAT.format(returnedLongArrayCount) + "].", new Object[0]);
                        if (pool.logGarbageCollectedStacks) {
                            allocationStackTraceCountPairList.sort((a, b) -> Integer.compare(((AtomicInteger)b.second).get(), ((AtomicInteger)a.second).get()));
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int j = 0; j < allocationStackTraceCountPairList.size(); ++j) {
                                int count = ((AtomicInteger)allocationStackTraceCountPairList.get((int)j).second).get();
                                String stack = (String)allocationStackTraceCountPairList.get((int)j).first;
                                stringBuilder.append(count).append(". ").append(stack).append("\n");
                            }
                            LOGGER.warn("Stacks: [" + allocationStackTraceCountPairList.size() + "]\n" + stringBuilder.toString(), new Object[0]);
                        }
                    }
                    pool.recalculateSizeForDebugging();
                    ++poolIndex;
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in phantom pool return thread, error: [" + e.getMessage() + "].", e);
                continue;
            }
            break;
        }
    }

    private static void putAndIncrementTrackingString(String key, ArrayList<Pair<String, AtomicInteger>> allocationStackTraceCountPairList) {
        boolean pairFound = false;
        for (int i = 0; i < allocationStackTraceCountPairList.size(); ++i) {
            Pair<String, AtomicInteger> possiblePair = allocationStackTraceCountPairList.get(i);
            if (!((String)possiblePair.first).equals(key)) continue;
            ((AtomicInteger)possiblePair.second).getAndIncrement();
            pairFound = true;
            break;
        }
        if (!pairFound) {
            allocationStackTraceCountPairList.add(new Pair<String, AtomicInteger>(key, new AtomicInteger(1)));
        }
    }

    public void returnParentPhantomRef(@NotNull PhantomReference<AbstractPhantomArrayList> parentRef) {
        try {
            parentRef.clear();
            PhantomArrayListCheckout checkout = this.phantomRefToCheckout.remove(parentRef);
            this.returnCheckout(checkout);
        }
        catch (Exception e) {
            LOGGER.error("Unable to close Phantom Array, error: [" + e.getMessage() + "].", e);
        }
    }

    public void returnCheckout(@Nullable PhantomArrayListCheckout checkout) {
        if (checkout == null) {
            throw new IllegalArgumentException("Null phantom checkout, object is being closed multiple times.");
        }
        SoftReference<PhantomArrayListCheckout> checkoutRef = checkout.ownerSoftReference;
        this.pooledCheckoutsRefs.add(checkoutRef);
    }

    public static void addDebugMenuStringsToListForCombinedPools(List<String> messageList) {
        int totalByteArrayCount = 0;
        int totalShortArrayCount = 0;
        int totalLongArrayCount = 0;
        int pooledByteArraySize = 0;
        int pooledShortArraySize = 0;
        int pooledLongArraySize = 0;
        long lastBytePoolSizeInBytes = 0L;
        long lastShortPoolSizeInBytes = 0L;
        long lastLongPoolSizeInBytes = 0L;
        for (int i = 0; i < POOL_LIST.size(); ++i) {
            PhantomArrayListPool pool = POOL_LIST.get(i);
            totalByteArrayCount += pool.totalByteArrayCountRef.get();
            totalShortArrayCount += pool.totalShortArrayCountRef.get();
            totalLongArrayCount += pool.totalLongArrayCountRef.get();
            pooledByteArraySize += pool.lastBytePoolCount;
            pooledShortArraySize += pool.lastShortPoolCount;
            pooledLongArraySize += pool.lastLongPoolCount;
            lastBytePoolSizeInBytes += pool.lastBytePoolSizeInBytes;
            lastShortPoolSizeInBytes += pool.lastShortPoolSizeInBytes;
            lastLongPoolSizeInBytes += pool.lastLongPoolSizeInBytes;
        }
        PhantomArrayListPool.addDebugMenuStringsToList(messageList, "Combined", totalByteArrayCount, totalShortArrayCount, totalLongArrayCount, pooledByteArraySize, pooledShortArraySize, pooledLongArraySize, lastBytePoolSizeInBytes, lastShortPoolSizeInBytes, lastLongPoolSizeInBytes);
    }

    public static void addDebugMenuStringsToListForSeparatePools(List<String> messageList) {
        for (int i = 0; i < POOL_LIST.size(); ++i) {
            PhantomArrayListPool pool = POOL_LIST.get(i);
            pool.addDebugMenuStringsToList(messageList);
        }
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        PhantomArrayListPool.addDebugMenuStringsToList(messageList, this.name, this.totalByteArrayCountRef.get(), this.totalShortArrayCountRef.get(), this.totalLongArrayCountRef.get(), this.lastBytePoolCount, this.lastShortPoolCount, this.lastLongPoolCount, this.lastBytePoolSizeInBytes, this.lastShortPoolSizeInBytes, this.lastLongPoolSizeInBytes);
    }

    private static void addDebugMenuStringsToList(List<String> messageList, String name, int totalByteArrayCount, int totalShortArrayCount, int totalLongArrayCount, int numbOfByteArraysInPool, int numbOfShortArraysInPool, int numbOfLongArraysInPool, long lastBytePoolSizeInBytes, long lastShortPoolSizeInBytes, long lastLongPoolSizeInBytes) {
        String byteArrayTotalCount = F3Screen.NUMBER_FORMAT.format(totalByteArrayCount);
        String shortArrayTotalCount = F3Screen.NUMBER_FORMAT.format(totalShortArrayCount);
        String longArrayTotalCount = F3Screen.NUMBER_FORMAT.format(totalLongArrayCount);
        String bytePoolCount = F3Screen.NUMBER_FORMAT.format(numbOfByteArraysInPool);
        String shortPoolCount = F3Screen.NUMBER_FORMAT.format(numbOfShortArraysInPool);
        String longPoolCount = F3Screen.NUMBER_FORMAT.format(numbOfLongArraysInPool);
        String bytePoolSizeInBytes = lastBytePoolSizeInBytes != -1L ? " ~" + StringUtil.convertBytesToHumanReadable(lastBytePoolSizeInBytes) : "";
        String shortPoolSizeInBytes = lastShortPoolSizeInBytes != -1L ? " ~" + StringUtil.convertBytesToHumanReadable(lastShortPoolSizeInBytes) : "";
        String longPoolSizeInBytes = lastLongPoolSizeInBytes != -1L ? " ~" + StringUtil.convertBytesToHumanReadable(lastLongPoolSizeInBytes) : "";
        messageList.add(name + " - Pools:");
        if (totalByteArrayCount != 0) {
            messageList.add("byte[]: " + bytePoolCount + "/" + byteArrayTotalCount + bytePoolSizeInBytes);
        }
        if (totalShortArrayCount != 0) {
            messageList.add("short[]: " + shortPoolCount + "/" + shortArrayTotalCount + shortPoolSizeInBytes);
        }
        if (totalLongArrayCount != 0) {
            messageList.add("long[]: " + longPoolCount + "/" + longArrayTotalCount + longPoolSizeInBytes);
        }
    }

    public void recalculateSizeForDebugging() {
        long bytePoolByteSize = 0L;
        long shortPoolByteSize = 0L;
        long longPoolByteSize = 0L;
        int bytePoolCount = 0;
        int shortPoolCount = 0;
        int longPoolCount = 0;
        for (SoftReference<PhantomArrayListCheckout> pooledCheckoutRef : this.pooledCheckoutsRefs) {
            PhantomArrayListCheckout pooledCheckout = pooledCheckoutRef.get();
            if (pooledCheckout == null) continue;
            bytePoolByteSize += PhantomArrayListPool.estimateMemoryUsage(pooledCheckout.getAllByteArrays(), 1L);
            bytePoolCount += pooledCheckout.getAllByteArrays().size();
            shortPoolByteSize += PhantomArrayListPool.estimateMemoryUsage(pooledCheckout.getAllShortArrays(), 2L);
            shortPoolCount += pooledCheckout.getAllShortArrays().size();
            longPoolByteSize += PhantomArrayListPool.estimateMemoryUsage(pooledCheckout.getAllLongArrays(), 8L);
            longPoolCount += pooledCheckout.getAllLongArrays().size();
        }
        if (this.clearLastRefPoolSizes) {
            this.lastBytePoolSizeInBytes = 0L;
            this.lastShortPoolSizeInBytes = 0L;
            this.lastLongPoolSizeInBytes = 0L;
            this.clearLastRefPoolSizes = false;
        }
        this.lastCheckoutPoolCount = this.pooledCheckoutsRefs.size();
        this.lastBytePoolSizeInBytes = Math.max(bytePoolByteSize, this.lastBytePoolSizeInBytes);
        this.lastBytePoolCount = bytePoolCount;
        this.lastShortPoolSizeInBytes = Math.max(shortPoolByteSize, this.lastShortPoolSizeInBytes);
        this.lastShortPoolCount = shortPoolCount;
        this.lastLongPoolSizeInBytes = Math.max(longPoolByteSize, this.lastLongPoolSizeInBytes);
        this.lastLongPoolCount = longPoolCount;
    }

    private static <T extends Collection<?>> long estimateMemoryUsage(Iterable<T> pool, long elementSizeInBytes) {
        long longByteSize = 0L;
        for (Collection array : pool) {
            long overhead = 32L;
            long elementCount = PhantomArrayListPool.getCollectionCount(array);
            long arraySize = elementCount * elementSizeInBytes;
            longByteSize += overhead + arraySize;
        }
        return longByteSize;
    }

    private static <T extends Collection<?>> long estimateRefMemoryUsage(ConcurrentLinkedQueue<SoftReference<T>> pool, long elementSizeInBytes) {
        long longByteSize = 0L;
        for (SoftReference<T> arrayRef : pool) {
            long overhead = 32L;
            Collection array = (Collection)arrayRef.get();
            if (array == null) continue;
            long elementCount = PhantomArrayListPool.getCollectionCount(array);
            long arraySize = elementCount * elementSizeInBytes;
            longByteSize += overhead + arraySize;
        }
        return longByteSize;
    }

    private static long getCollectionCount(@NotNull Collection<?> array) {
        long elementCount;
        if (array instanceof ByteArrayList) {
            elementCount = ((ByteArrayList)array).elements().length;
        } else if (array instanceof ShortArrayList) {
            elementCount = ((ShortArrayList)array).elements().length;
        } else if (array instanceof LongArrayList) {
            elementCount = ((LongArrayList)array).elements().length;
        } else {
            throw new UnsupportedOperationException("Not implemented for type [" + array.getClass().getSimpleName() + "].");
        }
        return elementCount;
    }

    static {
        RECYCLER_THREAD.execute(() -> PhantomArrayListPool.runPhantomReferenceCleanupLoop());
    }
}

