/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.ratelimiting;

import com.seibel.distanthorizons.core.util.ratelimiting.SupplierBasedConcurrencyLimiter;
import com.seibel.distanthorizons.core.util.ratelimiting.SupplierBasedRateLimiter;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SupplierBasedRateAndConcurrencyLimiter<TFailObj> {
    private final SupplierBasedRateLimiter<TFailObj> rateLimiter;
    private final SupplierBasedConcurrencyLimiter<TFailObj> concurrencyLimiter;

    public SupplierBasedRateAndConcurrencyLimiter(Supplier<Integer> maxRateSupplier, Consumer<TFailObj> onFailureConsumer) {
        this.rateLimiter = new SupplierBasedRateLimiter<TFailObj>(maxRateSupplier, onFailureConsumer);
        this.concurrencyLimiter = new SupplierBasedConcurrencyLimiter<TFailObj>(maxRateSupplier, onFailureConsumer);
    }

    public boolean tryAcquire(TFailObj context) {
        if (!this.concurrencyLimiter.tryAcquire(context)) {
            return false;
        }
        if (!this.rateLimiter.tryAcquire(context)) {
            this.concurrencyLimiter.release();
            return false;
        }
        return true;
    }

    public void release() {
        this.concurrencyLimiter.release();
    }
}

