/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.seibel.distanthorizons.core.network.messages.MessageRegistry;
import loaderCommon.fabric.com.seibel.distanthorizons.common.commands.ConfigCommand;
import loaderCommon.fabric.com.seibel.distanthorizons.common.commands.CrashCommand;
import loaderCommon.fabric.com.seibel.distanthorizons.common.commands.DebugCommand;
import loaderCommon.fabric.com.seibel.distanthorizons.common.commands.PregenCommand;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import org.jetbrains.annotations.Nullable;

public class CommandInitializer {
    private boolean serverReady = false;
    private static final int REQUIRED_PERMISSION_LEVEL = 4;
    @Nullable
    private CommandDispatcher<class_2168> commandDispatcher;

    public void onServerReady() {
        this.serverReady = true;
        if (this.commandDispatcher != null) {
            this.initCommands(this.commandDispatcher);
            this.commandDispatcher = null;
        }
    }

    public void initCommands(CommandDispatcher<class_2168> commandDispatcher) {
        if (!this.serverReady) {
            this.commandDispatcher = commandDispatcher;
            return;
        }
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"dh").requires(source -> source.method_9259(4));
        builder.then(new ConfigCommand().buildCommand());
        builder.then(new DebugCommand().buildCommand());
        builder.then(new PregenCommand().buildCommand());
        if (MessageRegistry.DEBUG_CODEC_CRASH_MESSAGE) {
            builder.then(new CrashCommand().buildCommand());
        }
        commandDispatcher.register(builder);
    }
}

