/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.client.gui.GuiBase;
import reliquary.common.gui.AlkahestTomeMenu;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModItems;

public class AlkahestryTomeGui
extends GuiBase<AlkahestTomeMenu> {
    private static final ResourceLocation BOOK_TEX = new ResourceLocation("reliquary", "textures/gui/book.png");

    public AlkahestryTomeGui(AlkahestTomeMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
        this.drawTitleText(guiGraphics);
        this.drawTomeText(guiGraphics, this.f_96547_);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(BOOK_TEX, (this.f_96543_ - 146) / 2, (this.f_96544_ - 179) / 2, 0, 0, 146, 179);
        guiGraphics.m_280218_(BOOK_TEX, (this.f_96543_ - 16) / 2 + 19, (this.f_96544_ - 179) / 2 + 148, 0, 180, 10, 10);
        guiGraphics.m_280218_(BOOK_TEX, (this.f_96543_ - 16) / 2 - 14, (this.f_96544_ - 179) / 2 + 148, 10, 180, 10, 10);
        this.drawItemStack(guiGraphics, new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()), (this.f_96543_ - 16) / 2, (this.f_96544_ - 179) / 2 + 145);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        RegistryAccess registryAccess = level.m_9598_();
        AlkahestryRecipeRegistry.getDrainRecipe().ifPresent(drainRecipe -> {
            this.drawItemStack(guiGraphics, drainRecipe.m_8043_(registryAccess), (this.f_96543_ - 16) / 2 - 32, (this.f_96544_ - 179) / 2 + 145);
            this.drawItemStack(guiGraphics, drainRecipe.m_8043_(registryAccess), (this.f_96543_ - 16) / 2 + 32, (this.f_96544_ - 179) / 2 + 145);
        });
    }

    private void drawTomeText(GuiGraphics guigraphics, Font font) {
        String values = Language.m_128107_().m_6834_("gui.reliquary.alkahestry_tome.text");
        Objects.requireNonNull(font);
        int y = 36 + 9;
        for (String value : values.split("\n")) {
            List splitText = font.m_92923_((FormattedText)Component.m_237113_((String)value), 100);
            for (FormattedCharSequence text : splitText) {
                int x = (146 - font.m_92724_(text)) / 2;
                guigraphics.m_280649_(font, text, x + 15, y, 0, false);
                Objects.requireNonNull(font);
                y += 9;
            }
        }
    }

    private void drawTitleText(GuiGraphics guiGraphics) {
        String values = "Perform basic,\nintermediate or\nadvanced Alkahestry.";
        int count = 1;
        for (String value : values.split("\n")) {
            int x = (146 - this.f_96547_.m_92895_(value)) / 2;
            Objects.requireNonNull(this.f_96547_);
            int y = 4 + count * 9;
            guiGraphics.m_280056_(this.f_96547_, value, x + 15, y, 0, false);
            ++count;
        }
    }
}

