/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import reliquary.init.ModItems;
import reliquary.item.MobCharmDefinition;
import reliquary.item.MobCharmRegistry;
import reliquary.reference.Settings;

public class MobCharmRepairRecipe
extends CustomRecipe {
    private static final int PER_FRAGMENT_MULTIPLIER = 6;

    public MobCharmRepairRecipe(ResourceLocation registryName, CraftingBookCategory category) {
        super(registryName, category);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack ingredient = ItemStack.f_41583_;
        int numberIngredients = 0;
        ItemStack mobCharm = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack currentStack = inv.m_8020_(i);
            if (currentStack.m_41619_()) continue;
            if (currentStack.m_41720_() == ModItems.MOB_CHARM.get()) {
                if (!mobCharm.m_41619_()) {
                    return false;
                }
                mobCharm = currentStack;
                continue;
            }
            if (ingredient.m_41619_()) {
                ingredient = currentStack;
            } else if (ingredient.m_41720_() != currentStack.m_41720_()) {
                return false;
            }
            ++numberIngredients;
        }
        if (mobCharm.m_41619_()) {
            return false;
        }
        ItemStack finalIngredient = ingredient;
        Optional<MobCharmDefinition> cd = MobCharmRegistry.getCharmDefinitionFor(mobCharm);
        if (cd.isEmpty()) {
            return false;
        }
        MobCharmDefinition charmDefinition = cd.get();
        int repairMultiplier = charmDefinition.isDynamicallyCreated() ? 6 : 1;
        int durabilityRepaired = (Integer)Settings.COMMON.items.mobCharm.dropDurabilityRepair.get() * repairMultiplier;
        return mobCharm.m_41773_() >= durabilityRepaired * (numberIngredients - 1) && charmDefinition.isRepairItem(finalIngredient);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack ingredient = ItemStack.f_41583_;
        int numberIngredients = 0;
        ItemStack mobCharm = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack currentStack = inv.m_8020_(i);
            if (currentStack.m_41619_()) continue;
            if (currentStack.m_41720_() == ModItems.MOB_CHARM.get()) {
                mobCharm = currentStack;
                continue;
            }
            if (ingredient.m_41619_()) {
                ingredient = currentStack;
            }
            ++numberIngredients;
        }
        ItemStack resultingMobCharm = mobCharm.m_41777_();
        resultingMobCharm.m_41721_(Math.max(resultingMobCharm.m_41773_() - (Integer)Settings.COMMON.items.mobCharm.dropDurabilityRepair.get() * numberIngredients, 0));
        return resultingMobCharm;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.MOB_CHARM_REPAIR_SERIALIZER.get();
    }
}

