/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.shot;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import reliquary.entity.shot.ShotEntityBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class StormShotEntity
extends ShotEntityBase {
    public StormShotEntity(EntityType<StormShotEntity> entityType, Level world) {
        super(entityType, world);
    }

    public StormShotEntity(Level world, Player player, InteractionHand hand) {
        super((EntityType)ModEntities.STORM_SHOT.get(), world, player, hand);
    }

    @Override
    void doFiringEffects() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
    }

    @Override
    void doFlightEffects() {
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            LightningBolt bolt;
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockPos pos = blockResult.m_82425_().m_121945_(blockResult.m_82434_());
            if (this.m_9236_() instanceof ServerLevel && this.m_9236_().m_46758_(pos) && this.m_9236_().m_6106_().m_6533_() && this.m_9236_().m_6106_().m_6534_() && (bolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_())) != null) {
                bolt.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                this.m_9236_().m_7967_((Entity)bolt);
            }
        }
        super.m_6532_(result);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        Vec3 motion = this.m_20184_();
        for (int particles = 0; particles < i; ++particles) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.gaussian(motion.m_7096_()), (double)this.f_19796_.m_188501_() + motion.m_7098_(), this.gaussian(motion.m_7094_()));
        }
    }

    @Override
    int getRicochetMax() {
        return 1;
    }

    @Override
    void doDamage(LivingEntity entity) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            LightningBolt bolt;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_9236_().m_46758_(entity.m_20183_()) && this.m_9236_().m_6106_().m_6533_() && this.m_9236_().m_6106_().m_6534_() && (bolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_())) != null) {
                bolt.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                this.m_9236_().m_7967_((Entity)bolt);
                if (entity instanceof Creeper) {
                    entity.m_8038_(serverLevel, bolt);
                }
            }
        }
        super.doDamage(entity);
    }

    @Override
    int getDamageOfShot(LivingEntity entity) {
        float f = 1.0f + (this.m_9236_().m_46471_() ? 0.5f : 0.0f) + (this.m_9236_().m_46470_() ? 0.5f : 0.0f);
        return Math.round(9.0f * f) + this.d6();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.STORM;
    }
}

