/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import reliquary.init.ModItems;
import reliquary.item.MobCharmFragmentItem;

public class MobCharmDefinition {
    static final MobCharmDefinition ZOMBIE = new MobCharmDefinition("minecraft:zombie", (Item)ModItems.ZOMBIE_HEART.get(), "minecraft:zombie", "minecraft:husk", "minecraft:drowned", "minecraft:zombie_villager");
    static final MobCharmDefinition SKELETON = new MobCharmDefinition("minecraft:skeleton", (Item)ModItems.RIB_BONE.get(), "minecraft:skeleton", "minecraft:stray");
    static final MobCharmDefinition WITHER_SKELETON = new MobCharmDefinition("minecraft:wither_skeleton", (Item)ModItems.WITHERED_RIB.get(), "minecraft:wither_skeleton");
    static final MobCharmDefinition CREEPER = new MobCharmDefinition("minecraft:creeper", (Item)ModItems.CATALYZING_GLAND.get(), "minecraft:creeper");
    static final MobCharmDefinition WITCH = new MobCharmDefinition("minecraft:witch", (Item)ModItems.WITCH_HAT.get(), "minecraft:witch");
    static final MobCharmDefinition ZOMBIFIED_PIGLIN = new MobCharmDefinition("minecraft:zombified_piglin", (Item)ModItems.ZOMBIE_HEART.get(), "minecraft:zombified_piglin");
    static final MobCharmDefinition CAVE_SPIDER = new MobCharmDefinition("minecraft:cave_spider", (Item)ModItems.CHELICERAE.get(), "minecraft:cave_spider");
    static final MobCharmDefinition SPIDER = new MobCharmDefinition("minecraft:spider", (Item)ModItems.CHELICERAE.get(), "minecraft:spider");
    static final MobCharmDefinition ENDERMAN = new MobCharmDefinition("minecraft:enderman", (Item)ModItems.NEBULOUS_HEART.get(), "minecraft:enderman");
    static final MobCharmDefinition GHAST = new MobCharmDefinition("minecraft:ghast", (Item)ModItems.CATALYZING_GLAND.get(), "minecraft:ghast");
    static final MobCharmDefinition SLIME = new MobCharmDefinition("minecraft:slime", (Item)ModItems.SLIME_PEARL.get(), "minecraft:slime");
    static final MobCharmDefinition MAGMA_CUBE = new MobCharmDefinition("minecraft:magma_cube", (Item)ModItems.MOLTEN_CORE.get(), "minecraft:magma_cube");
    static final MobCharmDefinition BLAZE = new MobCharmDefinition("minecraft:blaze", (Item)ModItems.MOLTEN_CORE.get(), "minecraft:blaze");
    static final MobCharmDefinition GUARDIAN = new MobCharmDefinition("minecraft:guardian", (Item)ModItems.GUARDIAN_SPIKE.get(), "minecraft:guardian");
    private final Set<String> applicableToEntities = new HashSet<String>();
    private final String registryName;
    private final Item repairItem;
    private boolean dynamicallyCreated = false;

    public MobCharmDefinition(String registryName) {
        this(registryName, null, registryName);
        this.dynamicallyCreated = true;
    }

    public MobCharmDefinition(String registryName, @Nullable Item repairItem, String ... applicableTo) {
        this.registryName = registryName;
        this.repairItem = repairItem;
        Collections.addAll(this.applicableToEntities, applicableTo);
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public Set<String> getEntities() {
        return this.applicableToEntities;
    }

    public boolean isRepairItem(ItemStack item) {
        return this.repairItem != null ? item.m_41720_() == this.repairItem : item.m_41720_() == ModItems.MOB_CHARM_FRAGMENT.get() && this.applicableToEntities.contains(MobCharmFragmentItem.getEntityRegistryName(item));
    }

    public boolean isDynamicallyCreated() {
        return this.dynamicallyCreated;
    }
}

