/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import reliquary.entity.EntityXRFakePlayer;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.util.RandHelper;
import reliquary.util.TooltipBuilder;
import reliquary.util.XRFakePlayerFactory;

public class ShearsOfWinterItem
extends ShearsItem
implements ICreativeTabItemGenerator {
    public ShearsOfWinterItem() {
        super(new Item.Properties().m_41503_(0));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos = context.m_8083_());
        Block block = state.m_60734_();
        if (block instanceof BeehiveBlock) {
            this.shearBeehive(world, pos, state, context.m_43720_(), context.m_43719_());
        }
        return super.m_6225_(context);
    }

    private void shearBeehive(Level world, BlockPos pos, BlockState state, Vec3 hitVec, Direction face) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ItemStack fakeShears = new ItemStack((ItemLike)Items.f_42574_);
        EntityXRFakePlayer fakePlayer = XRFakePlayerFactory.get((ServerLevel)world);
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, fakeShears);
        state.m_60664_(world, (Player)fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(hitVec, face, pos, false));
    }

    public int m_8105_(ItemStack par1ItemStack) {
        return 2500;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (this.m_8105_(stack) - remainingUseDuration <= 5 || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Vec3 lookVector = player.m_20154_();
        this.spawnBlizzardParticles(lookVector, player);
        if (livingEntity.m_9236_().f_46443_) {
            return;
        }
        this.doEntityShearableCheck(stack, player, lookVector);
        this.shearBlocks(player, lookVector);
    }

    private void shearBlocks(Player player, Vec3 lookVector) {
        Vec3 eyePosition = player.m_20299_(1.0f);
        BlockPos firstPos = BlockPos.m_274446_((Position)eyePosition);
        BlockPos secondPos = BlockPos.m_274446_((Position)eyePosition.m_82549_(lookVector.m_82542_(10.0, 10.0, 10.0)));
        if (firstPos.m_123341_() == secondPos.m_123341_()) {
            firstPos = firstPos.m_7918_(-2, 0, 0);
            secondPos = secondPos.m_7918_(2, 0, 0);
        }
        if (firstPos.m_123342_() == secondPos.m_123342_()) {
            firstPos = firstPos.m_7918_(0, -2, 0);
            secondPos = secondPos.m_7918_(0, 2, 0);
        }
        if (firstPos.m_123343_() == secondPos.m_123343_()) {
            firstPos = firstPos.m_7918_(0, 0, -2);
            secondPos = secondPos.m_7918_(0, 0, 2);
        }
        BlockPos.m_121990_((BlockPos)firstPos, (BlockPos)secondPos).forEach(pos -> this.checkAndShearBlockAt(player, (BlockPos)pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack shears, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        TooltipBuilder.of(tooltip).itemTooltip((Item)this);
    }

    private void checkAndShearBlockAt(Player player, BlockPos pos) {
        int distance = (int)Math.sqrt(pos.m_203202_(player.m_20185_(), player.m_20186_(), player.m_20189_()));
        int probabilityFactor = 5 + distance;
        if (player.m_9236_().f_46441_.m_188503_(probabilityFactor) == 0) {
            this.shearBlockAt(pos, player);
        }
    }

    private void shearBlockAt(BlockPos pos, Player player) {
        Level world = player.m_9236_();
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof IForgeShearable) {
            IForgeShearable target = (IForgeShearable)block;
            ItemStack dummyShears = new ItemStack((ItemLike)Items.f_42574_);
            if (target.isShearable(dummyShears, world, pos) && this.removeBlock(player, pos, blockState.canHarvestBlock((BlockGetter)world, pos, player))) {
                player.m_36246_(Stats.f_12949_.m_12902_((Object)block));
                player.m_36399_(0.01f);
                Block.m_49881_((BlockState)blockState, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)dummyShears);
            }
        } else if (block instanceof BeehiveBlock) {
            this.shearBeehive(world, pos, blockState, Vec3.f_82478_, Direction.UP);
        }
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            this.shearBlockAt(pos, player);
        }
        return super.m_6813_(stack, worldIn, state, pos, entityLiving);
    }

    private boolean removeBlock(Player player, BlockPos pos, boolean canHarvest) {
        BlockState state = player.m_9236_().m_8055_(pos);
        boolean removed = state.onDestroyedByPlayer(player.m_9236_(), pos, player, canHarvest, player.m_9236_().m_6425_(pos));
        if (removed) {
            state.m_60734_().m_6786_((LevelAccessor)player.m_9236_(), pos, state);
        }
        return removed;
    }

    private void doEntityShearableCheck(ItemStack stack, Player player, Vec3 lookVector) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        double lowerX = Math.min(player.m_20185_(), player.m_20185_() + lookVector.f_82479_ * 10.0);
        double lowerY = Math.min(player.m_20186_() + (double)player.m_20192_(), player.m_20186_() + (double)player.m_20192_() + lookVector.f_82480_ * 10.0);
        double lowerZ = Math.min(player.m_20189_(), player.m_20189_() + lookVector.f_82481_ * 10.0);
        double upperX = Math.max(player.m_20185_(), player.m_20185_() + lookVector.f_82479_ * 10.0);
        double upperY = Math.max(player.m_20186_() + (double)player.m_20192_(), player.m_20186_() + (double)player.m_20192_() + lookVector.f_82480_ * 10.0);
        double upperZ = Math.max(player.m_20189_(), player.m_20189_() + lookVector.f_82481_ * 10.0);
        List eList = player.m_9236_().m_45976_(Mob.class, new AABB(lowerX, lowerY, lowerZ, upperX, upperY, upperZ));
        RandomSource rand = player.m_9236_().f_46441_;
        for (Mob e : eList) {
            int distance = (int)player.m_20270_((Entity)e);
            int probabilityFactor = (distance - 3) / 2;
            if (probabilityFactor > 0 && player.m_9236_().f_46441_.m_188503_(probabilityFactor) != 0) continue;
            if (!e.m_7306_((Entity)player)) {
                e.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 120, 1));
            }
            if (!(e instanceof IForgeShearable)) continue;
            this.shearEntity(stack, player, rand, e);
        }
    }

    private void shearEntity(ItemStack stack, Player player, RandomSource rand, Mob e) {
        IForgeShearable target = (IForgeShearable)e;
        BlockPos pos = e.m_20183_();
        if (target.isShearable(new ItemStack((ItemLike)Items.f_42574_), e.m_9236_(), pos)) {
            List drops = target.onSheared(player, stack, e.m_9236_(), pos, stack.getEnchantmentLevel(Enchantments.f_44987_));
            drops.forEach(d -> {
                ItemEntity ent = e.m_5552_(d, 1.0f);
                if (ent != null) {
                    ent.m_20256_(ent.m_20184_().m_82520_((double)(RandHelper.getRandomMinusOneToOne(rand) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)(RandHelper.getRandomMinusOneToOne(rand) * 0.1f)));
                }
            });
            player.m_36399_(0.01f);
        }
    }

    private void spawnBlizzardParticles(Vec3 lookVector, Player player) {
        BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50127_.m_49966_());
        for (int i = 0; i < 16; ++i) {
            float randX = 10.0f * (player.m_9236_().f_46441_.m_188501_() - 0.5f);
            float randY = 10.0f * (player.m_9236_().f_46441_.m_188501_() - 0.5f);
            float randZ = 10.0f * (player.m_9236_().f_46441_.m_188501_() - 0.5f);
            player.m_9236_().m_7106_((ParticleOptions)blockParticleData, player.m_20185_() + (double)randX, player.m_20186_() + (double)randY, player.m_20189_() + (double)randZ, lookVector.f_82479_ * 5.0, lookVector.f_82480_ * 5.0, lookVector.f_82481_ * 5.0);
        }
    }
}

