/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor.modinit.codec;

import java.nio.ByteBuffer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.moddingx.libx.annotation.codec.Param;
import org.moddingx.libx.annotation.processor.Classes;
import org.moddingx.libx.annotation.processor.modinit.FailureException;
import org.moddingx.libx.annotation.processor.modinit.ModEnv;
import org.moddingx.libx.annotation.processor.modinit.ModInit;
import org.moddingx.libx.annotation.processor.modinit.codec.CodecProcessor;
import org.moddingx.libx.annotation.processor.modinit.codec.CodecType;
import org.moddingx.libx.annotation.processor.modinit.codec.GeneratedCodec;
import org.moddingx.libx.annotation.processor.modinit.codec.GetterSupplier;

public class ParamType
implements CodecType {
    @Override
    public boolean matchesDirect(Element param, String name, ModEnv env) {
        return param.getAnnotation(Param.class) != null;
    }

    @Override
    public boolean matches(Element param, String name, ModEnv env) {
        return true;
    }

    @Override
    public GeneratedCodec.CodecElement generate(Element param, String name, GetterSupplier getter, ModEnv env) throws FailureException {
        String typeFqn = param.asType().toString();
        String typeFqnBoxed = env.boxed(param.asType()).toString();
        CodecProcessor.ListInfo list = CodecProcessor.getNestedListInfo(param.asType(), env);
        if (list == null) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't get a Codec for parameterized list type: Failed to infer element type.", param);
            throw new FailureException();
        }
        String codecFqn = ParamType.getCodecFqn(list.elementType(), param, env);
        if (codecFqn == null) {
            throw new FailureException();
        }
        return new GeneratedCodec.CodecParam(name, typeFqn, typeFqnBoxed, codecFqn, list.nesting(), getter.get());
    }

    @Nullable
    private static String getCodecFqn(TypeMirror type, Element paramElement, ModEnv env) {
        String fieldName;
        TypeMirror codecClass;
        TypeMirror boxed = env.boxed(type);
        Param annotation = paramElement.getAnnotation(Param.class);
        if (annotation == null) {
            codecClass = boxed;
            fieldName = null;
        } else {
            codecClass = env.classType(annotation::value);
            if (codecClass.getKind() == TypeKind.VOID) {
                codecClass = boxed;
            }
            fieldName = annotation.field().isEmpty() ? null : annotation.field();
        }
        TypeMirror codecClassUnboxed = env.unboxed(codecClass);
        if (fieldName == null && codecClassUnboxed.getKind() == TypeKind.VOID || codecClassUnboxed.getKind() == TypeKind.NULL || codecClassUnboxed.getKind() == TypeKind.NONE) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't get a Codec for the void, null or none type.", paramElement);
            return null;
        }
        if (fieldName == null && codecClassUnboxed.getKind() == TypeKind.BOOLEAN) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".BOOL";
        }
        if (fieldName == null && codecClassUnboxed.getKind() == TypeKind.BYTE) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".BYTE";
        }
        if (fieldName == null && codecClassUnboxed.getKind() == TypeKind.CHAR) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't get a Codec for the char type.", paramElement);
            return null;
        }
        if (fieldName == null && codecClassUnboxed.getKind() == TypeKind.SHORT) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".SHORT";
        }
        if (fieldName == null && codecClassUnboxed.getKind() == TypeKind.INT) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".INT";
        }
        if (fieldName == null && codecClassUnboxed.getKind() == TypeKind.LONG) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".LONG";
        }
        if (fieldName == null && codecClassUnboxed.getKind() == TypeKind.FLOAT) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".FLOAT";
        }
        if (fieldName == null && codecClassUnboxed.getKind() == TypeKind.DOUBLE) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".DOUBLE";
        }
        if (fieldName == null && env.sameErasure(codecClass, env.forClass(String.class))) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".STRING";
        }
        if (fieldName == null && env.sameErasure(codecClass, env.forClass(ByteBuffer.class))) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".BYTE_BUFFER";
        }
        if (fieldName == null && env.sameErasure(codecClass, env.forClass(IntStream.class))) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".INT_STREAM";
        }
        if (fieldName == null && env.sameErasure(codecClass, env.forClass(LongStream.class))) {
            return Classes.sourceName("com.mojang.serialization.Codec") + ".LONG_STREAM";
        }
        if (fieldName == null) {
            for (String name : ModInit.DEFAULT_PARAM_CODEC_FIELDS) {
                String result = ParamType.tryDetect(paramElement, boxed, codecClass, name, env, false);
                if (result == null) continue;
                return result;
            }
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't get codec for parameter: No default codec field found. Tried [ " + String.join((CharSequence)", ", ModInit.DEFAULT_PARAM_CODEC_FIELDS) + " ] in class " + codecClass + ".", paramElement);
            for (String name : ModInit.DEFAULT_PARAM_CODEC_FIELDS) {
                ParamType.tryDetect(paramElement, boxed, codecClass, name, env, true);
            }
            return null;
        }
        return ParamType.tryDetect(paramElement, boxed, codecClass, fieldName, env, true);
    }

    @Nullable
    private static String tryDetect(Element paramElement, TypeMirror type, TypeMirror codecClass, String fieldName, ModEnv env, boolean fail) {
        TypeMirror boxed = env.boxed(type);
        Element typeElem = env.types().asElement(codecClass);
        if (typeElem == null) {
            if (fail) {
                env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't get type element of parameter: " + codecClass + ".", paramElement);
            }
            return null;
        }
        VariableElement fieldElem = typeElem.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getModifiers().contains((Object)Modifier.STATIC)).filter(e -> e instanceof VariableElement).map(e -> (VariableElement)e).filter(e -> e.getSimpleName().contentEquals(fieldName)).findFirst().orElse(null);
        if (fieldElem == null) {
            if (fail) {
                env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't get codec for parameter: " + typeElem.asType() + "." + fieldName + " is not defined or inaccessible.", paramElement);
            }
            return null;
        }
        if (!env.sameErasure(fieldElem.asType(), env.forClass("com.mojang.serialization.Codec"))) {
            if (fail) {
                env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't get codec for parameter: " + typeElem.asType() + "." + fieldName + " is defined but not a Codec.", paramElement);
            }
            return null;
        }
        if (!ParamType.genericMatches(env.boxed(fieldElem.asType()), boxed, env)) {
            if (fail) {
                env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't get codec for parameter: " + typeElem.asType() + "." + fieldName + " is not compatible with type " + type + ".", paramElement);
            }
            return null;
        }
        Element element = fieldElem.getEnclosingElement();
        if (element instanceof QualifiedNameable) {
            QualifiedNameable parent = (QualifiedNameable)element;
            return parent.getQualifiedName().toString() + "." + fieldElem.getSimpleName().toString();
        }
        if (fail) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Codec field is not nameable.", paramElement);
        }
        return null;
    }

    public static boolean genericMatches(TypeMirror typeWithGeneric, TypeMirror compare, ModEnv env) {
        DeclaredType declared;
        if (typeWithGeneric.getKind() == TypeKind.DECLARED && typeWithGeneric instanceof DeclaredType && (declared = (DeclaredType)typeWithGeneric).getTypeArguments().size() == 1) {
            TypeMirror generic = declared.getTypeArguments().get(0);
            return env.sameErasure(generic, compare);
        }
        return true;
    }
}

