/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base.decoration;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.moddingx.libx.impl.base.decoration.BaseMaterial;

public interface DecorationMaterial {
    public static final DecorationMaterial GENERIC = BaseMaterial.GENERIC;
    public static final DecorationMaterial WOOD = BaseMaterial.WOOD;
    public static final DecorationMaterial STONE = BaseMaterial.STONE;
    public static final DecorationMaterial METAL = BaseMaterial.METAL;

    public boolean isWood();

    public boolean isStone();

    public boolean isMetal();

    public MaterialProperties init(ResourceLocation var1);

    public static class MaterialProperties {
        @Nullable
        private final BlockSetType blockSetType;
        @Nullable
        private final WoodType woodType;

        public MaterialProperties(@Nullable BlockSetType blockSetType, @Nullable WoodType woodType) {
            this.blockSetType = blockSetType;
            this.woodType = woodType;
        }

        public BlockSetType blockSetType() {
            if (this.blockSetType == null) {
                throw new IllegalStateException("Decoration material has no BlockSetType available.");
            }
            return this.blockSetType;
        }

        public WoodType woodType() {
            if (this.woodType == null) {
                throw new IllegalStateException("Decoration material has no WoodType available.");
            }
            return this.woodType;
        }

        void register() {
            if (this.blockSetType != null) {
                BlockSetType.m_272115_((BlockSetType)this.blockSetType);
            }
            if (this.woodType != null) {
                WoodType.m_61844_((WoodType)this.woodType);
            }
        }
    }
}

