/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeHelper {
    public static boolean isItemValidInput(RecipeManager rm, RecipeType<?> recipeType, ItemStack stack) {
        Collection recipes = rm.m_44054_(recipeType).values();
        for (Recipe recipe : recipes) {
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!ingredient.test(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matches(Recipe<?> recipe, List<ItemStack> stacks, boolean exactMatch) {
        ArrayList<Integer> countsLeft = new ArrayList<Integer>();
        for (ItemStack stack : stacks) {
            countsLeft.add(stack.m_41619_() ? 0 : stack.m_41613_());
        }
        block1: for (Ingredient ingredient : recipe.m_7527_()) {
            for (int i = 0; i < stacks.size(); ++i) {
                if ((Integer)countsLeft.get(i) <= 0 || !ingredient.test(stacks.get(i))) continue;
                countsLeft.set(i, (Integer)countsLeft.get(i) - 1);
                continue block1;
            }
            return false;
        }
        return !exactMatch || countsLeft.stream().noneMatch(count -> count > 0);
    }

    public static List<ItemStack> stackUp(List<ItemStack> stacks) {
        ArrayList<ItemStack> stacked = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            int itemsLeft = stack.m_41613_();
            for (ItemStack used : stacked) {
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)used)) continue;
                int stackTransfer = Math.min(itemsLeft, used.m_41741_() - used.m_41613_());
                if (stackTransfer < 0) {
                    stackTransfer = 0;
                }
                used.m_41769_(stackTransfer);
                itemsLeft -= stackTransfer;
            }
            if (itemsLeft <= 0) continue;
            ItemStack newStack = stack.m_41777_();
            newStack.m_41764_(itemsLeft);
            stacked.add(newStack);
        }
        return Collections.unmodifiableList(stacked);
    }

    public static JsonObject serializeItemStack(ItemStack stack, boolean writeNBT) {
        JsonObject json = new JsonObject();
        json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), "Can't serialize ItemStack: Item has no registry name: " + stack.m_41720_()).toString());
        json.addProperty("count", (Number)stack.m_41613_());
        if (writeNBT) {
            CompoundTag stackTag = stack.m_41782_() ? stack.m_41783_() : null;
            Tag capsTag = RecipeHelper.forgeCaps(stack);
            if (stackTag != null || capsTag != null) {
                CompoundTag resultTag;
                CompoundTag compoundTag = resultTag = stackTag == null ? new CompoundTag() : stackTag.m_6426_();
                if (capsTag != null) {
                    resultTag.m_128365_("ForgeCaps", capsTag);
                }
                json.addProperty("nbt", resultTag.toString());
            }
        }
        return json;
    }

    @Nullable
    private static Tag forgeCaps(ItemStack stack) {
        CompoundTag cmp;
        Tag tag;
        CompoundTag nbt = stack.serializeNBT();
        if (!(!nbt.m_128441_("ForgeCaps") || (tag = nbt.m_128423_("ForgeCaps")) instanceof CompoundTag && (cmp = (CompoundTag)tag).m_128456_())) {
            return nbt.m_128423_("ForgeCaps");
        }
        return null;
    }
}

