/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datapack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.IOUtils;
import org.moddingx.libx.LibX;
import org.moddingx.libx.codec.CodecHelper;
import org.moddingx.libx.datapack.ResourceEntry;

public class DataLoader {
    private static final Gson GSON = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.setLenient();
        builder.setPrettyPrinting();
        return builder.create();
    });

    public static <T> Map<ResourceLocation, T> loadJson(ResourceManager rm, String basePath, Codec<T> codec) throws IOException {
        return DataLoader.loadJson(rm, basePath, (ResourceLocation id, JsonElement json) -> {
            DataResult result = codec.decode((DynamicOps)JsonOps.INSTANCE, json).map(Pair::getFirst);
            if (result.result().isPresent()) {
                return result.result().get();
            }
            Object err = result.error().map(DataResult.PartialResult::message).orElse("Unknown error");
            if (((String)err).length() > 100) {
                err = ((String)err).substring(0, 100) + " ...";
            }
            LibX.logger.error("Failed to load data entry " + id + ": " + (String)err);
            return null;
        });
    }

    public static <T> Map<ResourceLocation, T> loadJson(ResourceManager rm, String basePath, ResourceFactory<JsonElement, T> factory) throws IOException {
        return DataLoader.collectJson(DataLoader.locate(rm, basePath, "json", true), factory);
    }

    public static <T> Map<ResourceLocation, T> collect(List<ResourceEntry> resources, ResourceFactory<Resource, T> factory) throws IOException {
        HashMap<ResourceLocation, T> map = new HashMap<ResourceLocation, T>();
        for (ResourceEntry entry : resources) {
            T value = factory.apply(entry.id(), entry.resource());
            if (value == null) continue;
            map.put(entry.id(), value);
        }
        return ImmutableMap.copyOf(map);
    }

    public static <T> Map<ResourceLocation, T> collectText(List<ResourceEntry> resources, ResourceFactory<String, T> factory) throws IOException {
        return DataLoader.collect(resources, (id, resource) -> {
            try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                Object r = factory.apply(id, IOUtils.toString((Reader)reader));
                return r;
            }
        });
    }

    public static <T> Map<ResourceLocation, T> collectJson(List<ResourceEntry> resources, Codec<T> codec) throws IOException {
        return DataLoader.collectJson(resources, (ResourceLocation id, JsonElement json) -> CodecHelper.JSON.read(codec, (JsonElement)json));
    }

    public static <T> Map<ResourceLocation, T> collectJson(List<ResourceEntry> resources, ResourceFactory<JsonElement, T> factory) throws IOException {
        return DataLoader.collect(resources, (id, resource) -> {
            try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                Object r = factory.apply(id, (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class));
                return r;
            }
        });
    }

    public static <T> Stream<T> join(List<ResourceEntry> resources, ResourceFactory<Resource, T> factory) throws IOException {
        Stream.Builder<T> stream = Stream.builder();
        for (ResourceEntry entry : resources) {
            T value = factory.apply(entry.id(), entry.resource());
            if (value == null) continue;
            stream.add(value);
        }
        return stream.build();
    }

    public static <T> Stream<T> joinText(List<ResourceEntry> resources, ResourceFactory<String, T> factory) throws IOException {
        return DataLoader.join(resources, (id, resource) -> {
            try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                Object r = factory.apply(id, IOUtils.toString((Reader)reader));
                return r;
            }
        });
    }

    public static <T> Stream<T> joinJson(List<ResourceEntry> resources, ResourceFactory<JsonElement, T> factory) throws IOException {
        return DataLoader.join(resources, (id, resource) -> {
            try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                Object r = factory.apply(id, (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class));
                return r;
            }
        });
    }

    public static List<ResourceEntry> locate(ResourceManager rm, String fullPath, String idPath) {
        Set namespaces = rm.m_7187_();
        ImmutableList.Builder list = ImmutableList.builder();
        for (String namespace : namespaces) {
            ResourceLocation location = new ResourceLocation(namespace, fullPath);
            rm.m_213713_(location).ifPresent(res -> list.add((Object)new ResourceEntry(new ResourceLocation(namespace, idPath), (Resource)res)));
        }
        return list.build();
    }

    public static List<ResourceEntry> locate(ResourceManager rm, String basePath, @Nullable String suffix, boolean recursive) {
        Map resources = rm.m_214159_(basePath, file -> suffix == null || file.m_135815_().endsWith("." + suffix));
        ImmutableList.Builder list = ImmutableList.builder();
        for (Map.Entry entry : resources.entrySet()) {
            String realPath;
            ResourceLocation id = (ResourceLocation)entry.getKey();
            if (!id.m_135815_().startsWith(basePath + "/") || suffix != null && !id.m_135815_().endsWith("." + suffix) || (realPath = id.m_135815_().substring(basePath.length() + 1, id.m_135815_().length() - (suffix == null ? 0 : suffix.length() + 1))).isEmpty() || !recursive && realPath.contains("/")) continue;
            list.add((Object)new ResourceEntry(new ResourceLocation(id.m_135827_(), realPath), (Resource)entry.getValue()));
        }
        return list.build();
    }

    public static interface ResourceFactory<T, R> {
        @Nullable
        public R apply(ResourceLocation var1, T var2) throws IOException;
    }
}

