/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import org.moddingx.libx.impl.config.ConfigGroup;
import org.moddingx.libx.impl.config.ConfigImpl;
import org.moddingx.libx.impl.config.ConfigKey;

public class ConfigState {
    private final ConfigImpl config;
    private final Map<ConfigKey, Object> values;

    public ConfigState(ConfigImpl config, ImmutableMap<ConfigKey, Object> values) {
        this.config = config;
        this.values = values;
    }

    public Object getValue(ConfigKey key) {
        if (!this.values.containsKey(key)) {
            throw new IllegalStateException("Can't get value from config state: Key is invalid.");
        }
        return this.values.get(key);
    }

    public void apply() {
        try {
            for (Map.Entry<ConfigKey, Object> entry : this.values.entrySet()) {
                ConfigKey key = entry.getKey();
                Object value = entry.getValue();
                key.field.setAccessible(true);
                key.field.set(null, value);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to insert value into field.", e);
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.values.size());
        for (Map.Entry<ConfigKey, Object> entry : this.values.entrySet()) {
            ConfigKey key = entry.getKey();
            Object value = entry.getValue();
            buffer.m_130072_(key.field.getDeclaringClass().getName(), Short.MAX_VALUE);
            buffer.m_130072_(key.field.getName(), Short.MAX_VALUE);
            key.mapper.toNetwork(value, buffer);
        }
    }

    public void writeToFile(@Nullable Path path, @Nullable Set<ConfigKey> keys) throws IOException {
        if (path == null) {
            path = this.config.path;
        }
        if (!Files.isDirectory(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        writer.write("{\n" + this.applyIndent(this.writeObject(keys == null ? this.values.keySet() : keys, this.config.groups, 0)) + "\n}\n");
        ((Writer)writer).close();
    }

    public String writeObject(@Nonnull Set<ConfigKey> keys, Set<ConfigGroup> groups, int pathStrip) {
        List<ConfigKey> simpleKeysSorted = keys.stream().filter(key -> key.path.size() == pathStrip + 1).sorted(ConfigKey.BY_PATH).toList();
        Map subGroups = keys.stream().filter(key -> key.path.size() > pathStrip + 1).collect(Collectors.groupingBy(key -> key.path.get(pathStrip), Collectors.toSet()));
        boolean compact = keys.stream().allMatch(key -> key.comment.isEmpty()) && groups.isEmpty();
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (ConfigKey key2 : simpleKeysSorted) {
            if (first) {
                first = false;
            } else if (compact) {
                builder.append(",\n");
            } else {
                builder.append(",\n\n");
            }
            key2.comment.forEach(line -> builder.append("// ").append(line.replace('\n', ' ')).append("\n"));
            builder.append("\"").append(ConfigState.quote(key2.path.get(key2.path.size() - 1))).append("\": ");
            Object value = this.values.get(key2);
            Object json = key2.mapper.toJson(value);
            builder.append(this.specialString((JsonElement)json));
        }
        List subGroupKeys = subGroups.keySet().stream().sorted().toList();
        for (String group : subGroupKeys) {
            ConfigGroup cg = groups.stream().filter(g -> g.path.size() == pathStrip + 1).filter(g -> g.path.get(pathStrip).equals(group)).findFirst().orElse(null);
            Set<ConfigGroup> subGroupInstances = groups.stream().filter(g -> g.path.size() > pathStrip + 1).filter(g -> g.path.get(pathStrip).equals(group)).collect(Collectors.toSet());
            if (first) {
                first = false;
            } else {
                builder.append(",\n\n");
            }
            if (cg != null) {
                cg.comment.forEach(line -> builder.append("// ").append(line.replace('\n', ' ')).append("\n"));
            }
            builder.append("\"").append(ConfigState.quote(group)).append("\": {\n\n");
            builder.append(this.applyIndent(this.writeObject(subGroups.get(group), subGroupInstances, pathStrip + 1)));
            builder.append("\n}");
        }
        return builder.toString();
    }

    private String specialString(JsonElement json) {
        String content;
        List list;
        if (json.isJsonObject() && json.getAsJsonObject().size() == 0) {
            return "{}";
        }
        if (json.isJsonArray() && json.getAsJsonArray().size() == 0) {
            return "[]";
        }
        if (json.isJsonArray() && json.getAsJsonArray().size() <= 5 && (list = Streams.stream((Iterable)json.getAsJsonArray()).toList()).stream().allMatch(this::isSimple)) {
            return "[ " + list.stream().map(arg_0 -> ((Gson)ConfigImpl.GSON).toJson(arg_0)).collect(Collectors.joining(", ")) + " ]";
        }
        if (json.isJsonObject()) {
            content = json.getAsJsonObject().entrySet().stream().map(e -> ConfigImpl.GSON.toJson((JsonElement)new JsonPrimitive((String)e.getKey())) + ": " + this.specialString((JsonElement)e.getValue())).collect(Collectors.joining(",\n")).trim();
            return "{\n" + this.applyIndent(content) + "\n}";
        }
        if (json.isJsonArray()) {
            content = Streams.stream((Iterable)json.getAsJsonArray()).map(this::specialString).collect(Collectors.joining(",\n")).trim();
            return "[\n" + this.applyIndent(content) + "\n]";
        }
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            Double d;
            Number number = json.getAsJsonPrimitive().getAsNumber();
            if (number instanceof Float) {
                Float f = (Float)number;
                if ((double)Math.abs(f.floatValue()) >= 1.0E-5 && (double)Math.abs(f.floatValue()) < 1.0E9) {
                    return new BigDecimal(Float.toString(f.floatValue())).stripTrailingZeros().toPlainString();
                }
            } else if (number instanceof Double && Math.abs(d = (Double)number) >= 1.0E-5 && Math.abs(d) < 1.0E9) {
                return BigDecimal.valueOf(d).stripTrailingZeros().toPlainString();
            }
        }
        return ConfigImpl.GSON.toJson(json);
    }

    private boolean isSimple(JsonElement json) {
        if (json.isJsonNull()) {
            return true;
        }
        if (json.isJsonPrimitive()) {
            return !json.getAsJsonPrimitive().isString() || json.getAsJsonPrimitive().getAsString().length() <= 10;
        }
        return false;
    }

    private String applyIndent(String str) {
        return "  " + str.replace("\n", "\n  ");
    }

    private static String quote(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "\\\t").replace("\b", "\\\b").replace("\n", "\\\n").replace("\r", "\\\r").replace("\f", "\\\f");
    }
}

