/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.load;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.datagen.load.DatagenLoader;
import org.moddingx.libx.impl.libxcore.CoreRegistryLoad;

public class DatagenRegistryLoader {
    public static RegistryAccess.Frozen loadRegistries(ExistingFileHelper fileHelper) {
        LibX.logger.info("Start loading registries for datagen");
        ResourceManager mgr = DatagenLoader.resources(fileHelper, PackType.SERVER_DATA);
        LayeredRegistryAccess<RegistryLayer> access = RegistryLayer.m_245849_();
        access = DatagenRegistryLoader.loadLayer(mgr, access, RegistryLayer.WORLDGEN, DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.WORLDGEN));
        CoreRegistryLoad.afterWorldGenLayerLoad(access);
        access = DatagenRegistryLoader.loadLayer(mgr, access, RegistryLayer.DIMENSIONS, DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.DIMENSIONS));
        LibX.logger.info("Finished loading registries for datagen");
        return access.m_247579_();
    }

    private static LayeredRegistryAccess<RegistryLayer> loadLayer(ResourceManager mgr, LayeredRegistryAccess<RegistryLayer> access, RegistryLayer layer, List<RegistryDataLoader.RegistryData<?>> registries) {
        return access.m_247705_((Object)layer, new RegistryAccess.Frozen[]{RegistryDataLoader.m_247207_((ResourceManager)mgr, (RegistryAccess)access.m_246035_((Object)layer), registries)});
    }

    public static List<RegistryDataLoader.RegistryData<?>> getDataPackRegistries(@Nullable RegistryLayer layer) {
        if (layer == null) {
            return Stream.concat(Stream.concat(DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.STATIC).stream(), DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.WORLDGEN).stream()), Stream.concat(DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.DIMENSIONS).stream(), DatagenRegistryLoader.getDataPackRegistries(RegistryLayer.RELOADABLE).stream())).toList();
        }
        return switch (layer) {
            default -> throw new IncompatibleClassChangeError();
            case RegistryLayer.STATIC, RegistryLayer.RELOADABLE -> List.of();
            case RegistryLayer.WORLDGEN -> DataPackRegistriesHooks.getDataPackRegistries();
            case RegistryLayer.DIMENSIONS -> RegistryDataLoader.f_244547_;
        };
    }
}

