/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;
import org.moddingx.libx.render.RenderHelper;
import org.moddingx.libx.render.target.RenderJob;
import org.moddingx.libx.render.target.RenderJobFailedException;

public class JobRenderer {
    public static NativeImage renderJob(RenderJob job) {
        int width = job.width();
        int height = job.height();
        boolean overlay = job.usesOverlay();
        int maxTextureSize = GL11.glGetInteger((int)3379);
        if (width > maxTextureSize || height > maxTextureSize) {
            throw new RenderJobFailedException(RenderJobFailedException.Reason.TEXTURE_TOO_LARGE, "Maximum texture size exceeded: " + width + "x" + height + ", maximum is " + maxTextureSize + "x" + maxTextureSize);
        }
        TextureTarget target = new TextureTarget(width, height, true, Minecraft.f_91002_);
        target.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        target.m_83954_(true);
        JobRenderer.resetDepthState();
        target.m_83947_(true);
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        target.m_83947_(true);
        FogRenderer.m_109017_();
        RenderSystem.enableCull();
        RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_166856_();
        modelViewStack.m_252931_(job.setupModelViewMatrix());
        RenderSystem.applyModelViewMatrix();
        Matrix4f projectionMatrix = job.setupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)job.getVertexSorting());
        Lighting.m_84931_();
        RenderSystem.defaultBlendFunc();
        RenderHelper.resetColor();
        Matrix4f transformationMatrix = overlay ? new Matrix4f((Matrix4fc)modelViewStack.m_85850_().m_252922_()) : null;
        PoseStack poseStack = new PoseStack();
        job.setupTransformation(poseStack);
        if (overlay) {
            transformationMatrix.mul((Matrix4fc)poseStack.m_85850_().m_252922_());
        }
        RenderBuffers buffers = new RenderBuffers();
        job.render(poseStack, (MultiBufferSource)buffers.m_110104_());
        buffers.m_110104_().m_109911_();
        if (overlay) {
            target.m_83947_(true);
            FogRenderer.m_109017_();
            JobRenderer.resetDepthState();
            RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
            modelViewStack.m_166856_();
            modelViewStack.m_252931_(new Matrix4f().translate(0.0f, 0.0f, 11000.0f));
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 21000.0f), (VertexSorting)VertexSorting.f_276633_);
            PoseStack overlayPoseStack = new PoseStack();
            Lighting.m_84931_();
            ProjectorImpl projector = new ProjectorImpl(projectionMatrix, transformationMatrix, 0, 0, width, height);
            job.renderOverlay(overlayPoseStack, (MultiBufferSource)buffers.m_110104_(), projector);
            buffers.m_110104_().m_109911_();
        }
        JobRenderer.resetDepthState();
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        NativeImage img = JobRenderer.takeNonOpaqueScreenshot((RenderTarget)target);
        target.m_83970_();
        return img;
    }

    private static void resetDepthState() {
        RenderSystem.clearDepth((double)1.0);
        RenderSystem.depthFunc((int)515);
        GL11.glFrontFace((int)2305);
    }

    private static NativeImage takeNonOpaqueScreenshot(RenderTarget fb) {
        NativeImage img = new NativeImage(fb.f_83915_, fb.f_83916_, false);
        RenderSystem.bindTexture((int)fb.m_83975_());
        img.m_85045_(0, false);
        img.m_85122_();
        return img;
    }

    private static class ProjectorImpl
    implements RenderJob.Projector {
        private final Matrix4f projection;
        private final Matrix4f transformation;
        private final int viewportX;
        private final int viewportY;
        private final int viewportWidth;
        private final int viewportHeight;

        public ProjectorImpl(@Nonnull Matrix4f projection, @Nonnull Matrix4f transformation, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
            this.projection = projection;
            this.transformation = transformation;
            this.viewportX = viewportX;
            this.viewportY = viewportY;
            this.viewportWidth = viewportWidth;
            this.viewportHeight = viewportHeight;
        }

        @Override
        public Vec2 projectPoint(Vector3f point) {
            Vector4f vec4 = new Vector4f((Vector3fc)point, 1.0f);
            this.transformation.transform(vec4);
            this.projection.transform(vec4);
            if (!Double.isNaN(vec4.w()) && !Double.isInfinite(vec4.w()) && Math.abs(vec4.w()) >= 1.0E-6f) {
                vec4.set(vec4.x() / vec4.w(), vec4.y() / vec4.w(), vec4.z() / vec4.w(), 1.0f);
            }
            float wx = (float)this.viewportX + (float)this.viewportWidth * ((vec4.x() + 1.0f) / 2.0f);
            float wy = (float)this.viewportY + (float)this.viewportHeight * (1.0f - (vec4.y() + 1.0f) / 2.0f);
            return new Vec2(wx, wy);
        }
    }
}

