/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mes.world.processors;

import com.finndog.mes.modinit.MESProcessors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BrewingStandProcessor
extends StructureProcessor {
    public static final Codec<BrewingStandProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("brewing_stand_chance").orElse((Object)Float.valueOf(1.0f)).forGetter(processor -> Float.valueOf(processor.brewingStandChance)), (App)Codec.INT.fieldOf("min_potions").orElse((Object)1).forGetter(processor -> processor.minPotions), (App)Codec.INT.fieldOf("max_potions").orElse((Object)3).forGetter(processor -> processor.maxPotions)).apply((Applicative)instance, BrewingStandProcessor::new));
    private final float brewingStandChance;
    private final int minPotions;
    private final int maxPotions;

    public BrewingStandProcessor(float brewingStandChance, int minPotions, int maxPotions) {
        this.brewingStandChance = brewingStandChance;
        this.minPotions = minPotions;
        this.maxPotions = maxPotions;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        if (relativeBlockInfo.f_74676_().m_60713_(Blocks.f_50255_)) {
            return this.processBrewingStand(relativeBlockInfo, settings);
        }
        return relativeBlockInfo;
    }

    private StructureTemplate.StructureBlockInfo processBrewingStand(StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings settings) {
        RandomSource random = settings.m_230326_(blockInfo.f_74675_());
        float chance = random.m_188501_();
        if (chance < this.brewingStandChance) {
            CompoundTag nbt = blockInfo.f_74677_() != null ? blockInfo.f_74677_().m_6426_() : new CompoundTag();
            ListTag itemsList = new ListTag();
            int numPotions = random.m_216339_(this.minPotions, this.maxPotions + 1);
            String[] potionTypes = new String[]{"minecraft:regeneration", "minecraft:swiftness", "minecraft:fire_resistance", "minecraft:healing", "minecraft:night_vision", "minecraft:strength"};
            for (int i = 0; i < numPotions; ++i) {
                CompoundTag slot = new CompoundTag();
                slot.m_128344_("Slot", (byte)i);
                slot.m_128359_("id", "minecraft:potion");
                slot.m_128344_("Count", (byte)1);
                CompoundTag potionTag = new CompoundTag();
                potionTag.m_128359_("Potion", potionTypes[random.m_188503_(potionTypes.length)]);
                slot.m_128365_("tag", (Tag)potionTag);
                itemsList.add((Object)slot);
            }
            nbt.m_128365_("Items", (Tag)itemsList);
            return new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), blockInfo.f_74676_(), nbt);
        }
        return blockInfo;
    }

    protected StructureProcessorType<?> m_6953_() {
        return MESProcessors.BREWING_STAND_PROCESSOR.get();
    }
}

