/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.snad;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class SnadConfig {
    public static final SnadConfig INSTANCE = new SnadConfig();
    private final CommentedFileConfig config;

    public SnadConfig() {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("snad-common.toml");
        ConfigSpec spec = new ConfigSpec();
        spec.defineInRange("Growth Speed", (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(20));
        spec.defineInRange("Movement Speed", (Comparable)Double.valueOf(1.4), (Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(2.0));
        this.config = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).build();
        this.config.set("Growth Speed", (Object)2);
        this.config.setComment("Growth Speed", "The multiplier for the chance of growth");
        this.config.set("Movement Speed", (Object)1.4);
        this.config.setComment("Movement Speed", "The multiplier for movement speed on Suol Snad");
        if (Files.exists(configPath, new LinkOption[0])) {
            this.config.load();
            spec.correct((Config)this.config);
        } else {
            this.config.save();
        }
        this.config.close();
    }

    public int getGrowthSpeed() {
        return (Integer)this.config.get("Growth Speed");
    }

    public double getMovementSpeed() {
        return (Double)this.config.get("Movement Speed");
    }
}

