/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.snad;

import com.robrit.snad.Snad;
import com.robrit.snad.blocks.BlockRegistry;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="snad", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SnadData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new Lang(packOutput));
            generator.addProvider(true, (DataProvider)new BlockStates(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new ItemModels(packOutput, existingFileHelper));
        }
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new Recipes(packOutput));
            generator.addProvider(true, (DataProvider)new TagGenerator(packOutput, event.getLookupProvider(), existingFileHelper));
        }
    }

    public static final class Lang
    extends LanguageProvider {
        public Lang(PackOutput output) {
            super(output, "snad", "en_us");
        }

        protected void addTranslations() {
            this.add("block.snad.snad", "Snad");
            this.add("block.snad.red_snad", "Red Snad");
            this.add("block.snad.suol_snad", "Suol Snad");
        }
    }

    public static final class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "snad", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.simpleBlock((Block)BlockRegistry.SNAD.get());
            this.simpleBlock((Block)BlockRegistry.RED_SNAD.get());
            this.simpleBlock((Block)BlockRegistry.SUOL_SNAD.get());
        }
    }

    public static final class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "snad", existingFileHelper);
        }

        protected void registerModels() {
            this.withExistingParent("snad", this.modLoc("block/snad"));
            this.withExistingParent("red_snad", this.modLoc("block/red_snad"));
            this.withExistingParent("suol_snad", this.modLoc("block/suol_snad"));
        }
    }

    public static final class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput output) {
            super(output);
        }

        protected void m_245200_(Consumer<FinishedRecipe> consumer) {
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)BlockRegistry.RED_SNAD.get())).m_126209_((ItemLike)Items.f_41831_).m_126209_((ItemLike)Items.f_41831_).m_126132_("has_red_sand", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_41831_)).m_176498_(consumer);
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)BlockRegistry.SNAD.get())).m_126209_((ItemLike)Items.f_41830_).m_126209_((ItemLike)Items.f_41830_).m_126132_("has_sand", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_41830_)).m_176498_(consumer);
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)BlockRegistry.SUOL_SNAD.get())).m_126209_((ItemLike)Items.f_42049_).m_126209_((ItemLike)Items.f_42049_).m_126132_("has_soul_sand", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42049_)).m_176498_(consumer);
        }
    }

    public static final class TagGenerator
    extends BlockTagsProvider {
        public TagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "snad", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(Snad.SNAD_BLOCKS).m_255179_((Object[])new Block[]{(Block)BlockRegistry.SNAD.get(), (Block)BlockRegistry.RED_SNAD.get(), (Block)BlockRegistry.SUOL_SNAD.get()});
            this.m_206424_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("cactus_plantable_on"))).m_255179_((Object[])new Block[]{(Block)BlockRegistry.SNAD.get(), (Block)BlockRegistry.RED_SNAD.get()});
            this.m_206424_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("nether_wart_plantable_on"))).m_255245_((Object)((Block)BlockRegistry.SUOL_SNAD.get()));
            this.m_206424_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("sugar_cane_plantable_on"))).m_255179_((Object[])new Block[]{(Block)BlockRegistry.SNAD.get(), (Block)BlockRegistry.RED_SNAD.get()});
            this.m_206424_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("bamboo_plantable_on"))).m_255179_((Object[])new Block[]{(Block)BlockRegistry.SNAD.get(), (Block)BlockRegistry.RED_SNAD.get()});
        }
    }
}

