/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.compat;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.enchantments.InertEnchantment;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingRecipe;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class EnchantingCategory
implements IRecipeCategory<EnchantingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("apotheosis", "enchanting");
    public static final RecipeType<EnchantingRecipe> TYPE = RecipeType.create((String)"apotheosis", (String)"enchanting", EnchantingRecipe.class);
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/enchanting_jei.png");
    private static final Map<Class<?>, Extension<?>> EXTENSIONS = new HashMap();
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public EnchantingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, 0, 170, 56);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50201_));
        this.localizedName = Component.m_237115_((String)"apotheosis.recipes.enchanting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public RecipeType<EnchantingRecipe> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EnchantingRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 6, 6);
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 37, 6);
        Extension<?> ext = EXTENSIONS.get(recipe.getClass());
        if (ext != null) {
            ext.setRecipe(builder, input, output, recipe, focuses);
        } else {
            input.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getInput().m_43908_()));
            output.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getOutput());
        }
    }

    public void draw(EnchantingRecipe recipe, IRecipeSlotsView slots, GuiGraphics gfx, double mouseX, double mouseY) {
        boolean hover = false;
        if (mouseX > 57.0 && mouseX <= 165.0 && mouseY > 4.0 && mouseY <= 23.0) {
            gfx.m_280398_(TEXTURES, 57, 4, 0, 0.0f, 71.0f, 108, 19, 256, 256);
            hover = true;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        EnchantingStatRegistry.Stats stats = recipe.getRequirements();
        EnchantingStatRegistry.Stats maxStats = recipe.getMaxRequirements();
        gfx.m_280056_(font, I18n.m_118938_((String)"gui.apotheosis.enchant.eterna", (Object[])new Object[0]), 16, 26, 4044093, false);
        gfx.m_280056_(font, I18n.m_118938_((String)"gui.apotheosis.enchant.quanta", (Object[])new Object[0]), 16, 36, 16536660, false);
        gfx.m_280056_(font, I18n.m_118938_((String)"gui.apotheosis.enchant.arcana", (Object[])new Object[0]), 16, 46, 0xA800A8, false);
        int level = (int)(stats.eterna() * 2.0f);
        String s = "" + level;
        int width = 86 - font.m_92895_(s);
        EnchantmentNames.m_98734_().m_98735_((long)recipe.m_6423_().hashCode());
        FormattedText itextproperties = EnchantmentNames.m_98734_().m_98737_(font, width);
        int color = hover ? 0xFFFF80 : 6839882;
        EnchantingCategory.drawWordWrap(font, itextproperties, 77, 6, width, color, gfx);
        color = 8453920;
        gfx.m_280488_(font, s, 77 + width, 13, color);
        int[] pos = new int[]{(int)(stats.eterna() / EnchantingStatRegistry.getAbsoluteMaxEterna() * 110.0f), (int)(stats.quanta() / 100.0f * 110.0f), (int)(stats.arcana() / 100.0f * 110.0f)};
        if (stats.eterna() > 0.0f) {
            gfx.m_280163_(TEXTURES, 56, 27, 0.0f, 56.0f, pos[0], 5, 256, 256);
        }
        if (stats.quanta() > 0.0f) {
            gfx.m_280163_(TEXTURES, 56, 37, 0.0f, 61.0f, pos[1], 5, 256, 256);
        }
        if (stats.arcana() > 0.0f) {
            gfx.m_280163_(TEXTURES, 56, 47, 0.0f, 66.0f, pos[2], 5, 256, 256);
        }
        RenderSystem.enableBlend();
        if (maxStats.eterna() > 0.0f) {
            gfx.m_280163_(TEXTURES, 56 + pos[0], 27, (float)pos[0], 90.0f, (int)((maxStats.eterna() - stats.eterna()) / EnchantingStatRegistry.getAbsoluteMaxEterna() * 110.0f), 5, 256, 256);
        }
        if (maxStats.quanta() > 0.0f) {
            gfx.m_280163_(TEXTURES, 56 + pos[1], 37, (float)pos[1], 95.0f, (int)((maxStats.quanta() - stats.quanta()) / 100.0f * 110.0f), 5, 256, 256);
        }
        if (maxStats.arcana() > 0.0f) {
            gfx.m_280163_(TEXTURES, 56 + pos[2], 47, (float)pos[2], 100.0f, (int)((maxStats.arcana() - stats.arcana()) / 100.0f * 110.0f), 5, 256, 256);
        }
        RenderSystem.disableBlend();
        Screen scn = Minecraft.m_91087_().f_91080_;
        if (scn == null) {
            return;
        }
        if (hover) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237110_((String)"container.enchant.clue", (Object[])new Object[]{((InertEnchantment)((Object)Ench.Enchantments.INFUSION.get())).m_44700_(1).getString()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            gfx.m_280666_(font, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 26.0 && mouseY <= 32.0) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.eterna").m_130940_(ChatFormatting.GREEN));
            if (maxStats.eterna() == stats.eterna()) {
                list.add(Component.m_237110_((String)"info.apotheosis.eterna_exact", (Object[])new Object[]{Float.valueOf(stats.eterna()), Float.valueOf(EnchantingStatRegistry.getAbsoluteMaxEterna())}).m_130940_(ChatFormatting.GRAY));
            } else {
                list.add(Component.m_237110_((String)"info.apotheosis.eterna_at_least", (Object[])new Object[]{Float.valueOf(stats.eterna()), Float.valueOf(EnchantingStatRegistry.getAbsoluteMaxEterna())}).m_130940_(ChatFormatting.GRAY));
                if (maxStats.eterna() > -1.0f) {
                    list.add(Component.m_237110_((String)"info.apotheosis.eterna_at_most", (Object[])new Object[]{Float.valueOf(maxStats.eterna()), Float.valueOf(EnchantingStatRegistry.getAbsoluteMaxEterna())}).m_130940_(ChatFormatting.GRAY));
                }
            }
            gfx.m_280666_(font, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 36.0 && mouseY <= 42.0) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.quanta").m_130940_(ChatFormatting.RED));
            if (maxStats.quanta() == stats.quanta()) {
                list.add(Component.m_237110_((String)"info.apotheosis.percent_exact", (Object[])new Object[]{Float.valueOf(stats.quanta())}).m_130940_(ChatFormatting.GRAY));
            } else {
                list.add(Component.m_237110_((String)"info.apotheosis.percent_at_least", (Object[])new Object[]{Float.valueOf(stats.quanta())}).m_130940_(ChatFormatting.GRAY));
                if (maxStats.quanta() > -1.0f) {
                    list.add(Component.m_237110_((String)"info.apotheosis.percent_at_most", (Object[])new Object[]{Float.valueOf(maxStats.quanta())}).m_130940_(ChatFormatting.GRAY));
                }
            }
            gfx.m_280666_(font, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 46.0 && mouseY <= 52.0) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.arcana").m_130940_(ChatFormatting.DARK_PURPLE));
            if (maxStats.arcana() == stats.arcana()) {
                list.add(Component.m_237110_((String)"info.apotheosis.percent_exact", (Object[])new Object[]{Float.valueOf(stats.arcana())}).m_130940_(ChatFormatting.GRAY));
            } else {
                list.add(Component.m_237110_((String)"info.apotheosis.percent_at_least", (Object[])new Object[]{Float.valueOf(stats.arcana())}).m_130940_(ChatFormatting.GRAY));
                if (maxStats.arcana() > -1.0f) {
                    list.add(Component.m_237110_((String)"info.apotheosis.percent_at_most", (Object[])new Object[]{Float.valueOf(maxStats.arcana())}).m_130940_(ChatFormatting.GRAY));
                }
            }
            gfx.m_280666_(font, list, (int)mouseX, (int)mouseY);
        }
    }

    public static void drawWordWrap(Font font, FormattedText pText, int pX, int pY, int pMaxWidth, int pColor, GuiGraphics gfx) {
        for (FormattedCharSequence formattedcharsequence : font.m_92923_(pText, pMaxWidth)) {
            gfx.m_280649_(font, formattedcharsequence, pX, pY, pColor, false);
            pY += 9;
        }
    }

    public static <T extends EnchantingRecipe> void registerExtension(Class<T> cls, Extension<T> ext) {
        EXTENSIONS.put(cls, ext);
    }

    public static interface Extension<T extends EnchantingRecipe> {
        public void setRecipe(IRecipeLayoutBuilder var1, IRecipeSlotBuilder var2, IRecipeSlotBuilder var3, EnchantingRecipe var4, IFocusGroup var5);
    }
}

