/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.monster.WeightedRandomEntity;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.exception.DatapackLoadException;

public class RandomMonster {
    public static final Hashtable<EntityType<?>, MobNBTPatcher> NBT_PATCHERS = new Hashtable();
    public static WeightedRandomEntity[] COMMON;
    public static WeightedRandomEntity[] RARE;
    private static final CompoundTag VILLAGER_OFFERS;

    private static CompoundTag offer(String buy, byte buyCount, String buyB, byte buyBCount, String sell, byte sellCount) {
        CompoundTag offer = new CompoundTag();
        CompoundTag buyNbt = new CompoundTag();
        buyNbt.m_128359_("id", buy);
        buyNbt.m_128379_("Count", true);
        buyNbt.m_128405_("MaxUses", 3);
        buyNbt.m_128344_("Count", buyCount);
        CompoundTag buyTag = new CompoundTag();
        buyTag.m_128405_("Damage", 0);
        buyNbt.m_128365_("tag", (Tag)buyTag);
        CompoundTag buyBNbt = new CompoundTag();
        buyBNbt.m_128359_("id", buyB);
        buyBNbt.m_128379_("Count", true);
        buyBNbt.m_128405_("MaxUses", 3);
        buyBNbt.m_128344_("Count", buyBCount);
        CompoundTag buyBTag = new CompoundTag();
        buyBTag.m_128405_("Damage", 0);
        buyBNbt.m_128365_("tag", (Tag)buyBTag);
        CompoundTag sellNbt = new CompoundTag();
        sellNbt.m_128359_("id", sell);
        sellNbt.m_128379_("Count", true);
        sellNbt.m_128405_("MaxUses", 3);
        sellNbt.m_128344_("Count", sellCount);
        CompoundTag sellTag = new CompoundTag();
        sellTag.m_128405_("Damage", 0);
        sellNbt.m_128365_("tag", (Tag)sellTag);
        offer.m_128365_("buy", (Tag)buyNbt);
        offer.m_128365_("buyB", (Tag)buyBNbt);
        offer.m_128365_("sell", (Tag)sellNbt);
        offer.m_128405_("uses", 0);
        offer.m_128405_("xp", 0);
        offer.m_128350_("priceMultiplier", 0.0f);
        offer.m_128405_("demand", 0);
        offer.m_128405_("specialPrice", 0);
        offer.m_128379_("rewardXp", false);
        return offer;
    }

    public static void loadJson(ResourceManager resourceManager) {
        COMMON = new WeightedRandomEntity[5];
        RARE = new WeightedRandomEntity[5];
        try {
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_1.json"), 0);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_2.json"), 1);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_3.json"), 2);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_4.json"), 3);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_5.json"), 4);
        }
        catch (IOException e) {
            DungeonCrawl.LOGGER.error("Failed to load the monster entity files.");
            e.printStackTrace();
        }
    }

    private static void loadEntityFile(ResourceManager resourceManager, ResourceLocation file, int stage) throws IOException {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
        Resource resource = (Resource)resourceManager.m_213713_(file).orElseThrow(() -> new DatapackLoadException("Missing file: " + file));
        JsonObject object = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(resource.m_215507_()))).getAsJsonObject();
        if (object.has("common")) {
            RandomMonster.COMMON[stage] = WeightedRandomEntity.fromJson(object.getAsJsonArray("common"));
        } else {
            DungeonCrawl.LOGGER.warn("Missing entry 'common' in {}", (Object)file.toString());
            RandomMonster.COMMON[stage] = WeightedRandomEntity.EMPTY;
        }
        if (object.has("rare")) {
            RandomMonster.RARE[stage] = WeightedRandomEntity.fromJson(object.getAsJsonArray("rare"));
        } else {
            DungeonCrawl.LOGGER.warn("Missing entry 'rare' in {}", (Object)file.toString());
            RandomMonster.RARE[stage] = WeightedRandomEntity.EMPTY;
        }
    }

    public static EntityType<?> randomMonster(RandomSource rand, int stage) {
        if (stage > 4) {
            stage = 4;
        }
        if ((double)rand.m_188501_() < 0.1) {
            EntityType<?> monster = RARE[stage].roll(rand);
            if (monster != null) {
                return monster;
            }
            return COMMON[stage].roll(rand);
        }
        return COMMON[stage].roll(rand);
    }

    static {
        VILLAGER_OFFERS = new CompoundTag();
        ListTag recipes = new ListTag();
        recipes.add((Object)RandomMonster.offer("minecraft:paper", (byte)1, "minecraft:air", (byte)0, "minecraft:paper", (byte)1));
        VILLAGER_OFFERS.m_128365_("Recipes", (Tag)recipes);
        NBT_PATCHERS.put(EntityType.f_20497_, (nbt, rand, stage) -> {
            nbt.m_128359_("DeathLootTable", Loot.WITHER_SKELETON.toString());
            nbt.m_128356_("DeathLootTableSeed", (long)rand.m_188502_());
        });
        NBT_PATCHERS.put(EntityType.f_20530_, (nbt, rand, stage) -> {
            nbt.m_128365_("Offers", (Tag)VILLAGER_OFFERS.m_6426_());
            nbt.m_128405_("Xp", 1);
            nbt.m_128379_("Willing", false);
            CompoundTag villagerData = nbt.m_128469_("villagerData");
            villagerData.m_128405_("level", 5);
        });
    }

    @FunctionalInterface
    public static interface MobNBTPatcher {
        public void patch(CompoundTag var1, RandomSource var2, int var3);
    }
}

