/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece.room;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.PlacementConfiguration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonNodeConnector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.init.ModStructurePieceTypes;
import xiroc.dungeoncrawl.util.Orientation;

public class DungeonNodeRoom
extends DungeonPiece {
    public boolean lootRoom;

    public DungeonNodeRoom() {
        super(ModStructurePieceTypes.NODE_ROOM);
    }

    public DungeonNodeRoom(CompoundTag nbt) {
        super(ModStructurePieceTypes.NODE_ROOM, nbt);
        this.lootRoom = nbt.m_128471_("lootRoom");
        this.createBoundingBox();
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, RandomSource rand) {
        if (this.lootRoom) {
            this.model = DungeonModels.KEY_TO_MODEL.get(DungeonModels.LOOT_ROOM);
            return;
        }
        switch (this.connectedSides) {
            case 1: {
                this.model = modelSelector.deadEndNodes.roll(rand);
                break;
            }
            case 2: {
                if (this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3]) {
                    this.model = modelSelector.straightNodes.roll(rand);
                    break;
                }
                this.model = modelSelector.turnNodes.roll(rand);
                break;
            }
            case 3: {
                this.model = modelSelector.forkNodes.roll(rand);
                break;
            }
            default: {
                this.model = modelSelector.fullNodes.roll(rand);
            }
        }
    }

    @Override
    public void setWorldPosition(int x, int y, int z) {
        super.setWorldPosition(x - 4, y, z - 4);
    }

    public void m_213694_(WorldGenLevel worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for  {}", (Object)this);
            return;
        }
        Vec3i offset = this.model.getOffset(this.rotation);
        BlockPos pos = new BlockPos(this.x, this.y, this.z).m_121955_(offset);
        this.buildModel(this.model, (LevelAccessor)worldIn, structureBoundingBoxIn, pos, randomIn, PlacementConfiguration.NODE, this.theme, this.secondaryTheme, this.stage, this.rotation, false, false);
        this.entrances((LevelAccessor)worldIn, structureBoundingBoxIn, this.model, randomIn);
        this.placeFeatures((LevelAccessor)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage);
        this.decorate((LevelAccessor)worldIn, pos, this.theme, randomIn, structureBoundingBoxIn, this.f_73383_, this.model);
    }

    @Override
    public int getDungeonPieceType() {
        return 10;
    }

    @Override
    public boolean canConnect(Direction side, int x, int z) {
        return x == this.gridPosition.x || z == this.gridPosition.z;
    }

    @Override
    public boolean hasChildPieces() {
        return true;
    }

    @Override
    public void addChildPieces(List<DungeonPiece> pieces, DungeonBuilder builder, DungeonType type, ModelSelector modelSelector, int layer, RandomSource rand) {
        DungeonNodeConnector connector;
        super.addChildPieces(pieces, builder, type, modelSelector, layer, rand);
        if (this.sides[0]) {
            connector = new DungeonNodeConnector();
            connector.rotation = Orientation.getOppositeRotationFromFacing(Direction.NORTH);
            connector.theme = this.theme;
            connector.secondaryTheme = this.secondaryTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, modelSelector, pieces, rand);
            connector.setWorldPosition(this.x + 7, this.y, this.z - 5);
            connector.adjustPositionAndBounds();
            connector.setup(rand);
            pieces.add(connector);
        }
        if (this.sides[1]) {
            connector = new DungeonNodeConnector();
            connector.rotation = Orientation.getOppositeRotationFromFacing(Direction.EAST);
            connector.theme = this.theme;
            connector.secondaryTheme = this.secondaryTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, modelSelector, pieces, rand);
            connector.setWorldPosition(this.x + 17, this.y, this.z + 7);
            connector.adjustPositionAndBounds();
            connector.setup(rand);
            pieces.add(connector);
        }
        if (this.sides[2]) {
            connector = new DungeonNodeConnector();
            connector.rotation = Orientation.getOppositeRotationFromFacing(Direction.SOUTH);
            connector.theme = this.theme;
            connector.secondaryTheme = this.secondaryTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, modelSelector, pieces, rand);
            connector.setWorldPosition(this.x + 7, this.y, this.z + 17);
            connector.adjustPositionAndBounds();
            connector.setup(rand);
            pieces.add(connector);
        }
        if (this.sides[3]) {
            connector = new DungeonNodeConnector();
            connector.rotation = Orientation.getOppositeRotationFromFacing(Direction.WEST);
            connector.theme = this.theme;
            connector.secondaryTheme = this.secondaryTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, modelSelector, pieces, rand);
            connector.setWorldPosition(this.x - 5, this.y, this.z + 7);
            connector.adjustPositionAndBounds();
            connector.setup(rand);
            pieces.add(connector);
        }
    }

    @Override
    public void m_183620_(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        super.m_183620_(context, tagCompound);
        tagCompound.m_128379_("lootRoom", this.lootRoom);
    }
}

