/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.mob;

import java.util.Objects;
import mcjty.incontrol.compat.CustomNPCSupport;
import mcjty.incontrol.mob.DefaultMob;
import mcjty.incontrol.setup.ModSetup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class CNPCMob
extends DefaultMob {
    private int cloneTab;
    private String cloneName;
    private Entity cached;

    public CNPCMob(int cloneTab, String cloneName) {
        this.cloneName = cloneName;
        this.cloneTab = cloneTab;
    }

    public int getCloneTab() {
        return this.cloneTab;
    }

    public void setCloneTab(int cloneTab) {
        this.cloneTab = cloneTab;
    }

    public String getCloneName() {
        return this.cloneName;
    }

    public void setCloneName(String cloneName) {
        this.cloneName = cloneName;
    }

    @Override
    public EntityType<?> getType() {
        if (!ModSetup.customnpcs) {
            return null;
        }
        return CustomNPCSupport.getNPCEntityType();
    }

    public boolean matches(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!entity.getPersistentData().m_128441_("InControlNatSpawnTab") || !entity.getPersistentData().m_128441_("InControlNatSpawnName")) {
            return false;
        }
        return entity.getPersistentData().m_128451_("InControlNatSpawnTab") == this.cloneTab && entity.getPersistentData().m_128461_("InControlNatSpawnName").equals(this.cloneName);
    }

    @Override
    public Entity getEntity(ServerLevel level) {
        if (ModSetup.customnpcs) {
            if (this.cached == null || this.cached.isAddedToWorld() || this.cached.m_213877_()) {
                this.cached = CustomNPCSupport.getNpcEntity(level, this.cloneTab, this.cloneName);
            }
            return this.cached;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CNPCMob)) {
            return false;
        }
        CNPCMob cnpcMob = (CNPCMob)object;
        return this.cloneTab == cnpcMob.cloneTab && Objects.equals(this.cloneName, cnpcMob.cloneName);
    }

    public int hashCode() {
        return Objects.hash(this.cloneTab, this.cloneName);
    }
}

