/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker;

import com.kyanite.deeperdarker.DeeperDarkerConfig;
import com.kyanite.deeperdarker.content.AncientPaintings;
import com.kyanite.deeperdarker.content.DDBlockEntities;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDEffects;
import com.kyanite.deeperdarker.content.DDEnchantments;
import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.content.DDLootModifiers;
import com.kyanite.deeperdarker.content.DDPotions;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.content.entities.AnglerFish;
import com.kyanite.deeperdarker.content.entities.SculkCentipede;
import com.kyanite.deeperdarker.content.entities.SculkLeech;
import com.kyanite.deeperdarker.content.entities.SculkSnapper;
import com.kyanite.deeperdarker.content.entities.Shattered;
import com.kyanite.deeperdarker.content.entities.ShriekWorm;
import com.kyanite.deeperdarker.content.entities.Sludge;
import com.kyanite.deeperdarker.content.entities.Stalker;
import com.kyanite.deeperdarker.datagen.assets.DDBlockStateProvider;
import com.kyanite.deeperdarker.datagen.assets.DDItemModelProvider;
import com.kyanite.deeperdarker.datagen.assets.DDSoundDefinitions;
import com.kyanite.deeperdarker.datagen.assets.ENLanguageProvider;
import com.kyanite.deeperdarker.datagen.data.DDAdvancements;
import com.kyanite.deeperdarker.datagen.data.DDBlockTagsProvider;
import com.kyanite.deeperdarker.datagen.data.DDItemTagsProvider;
import com.kyanite.deeperdarker.datagen.data.DDRecipeProvider;
import com.kyanite.deeperdarker.datagen.data.DDRegistriesGenerator;
import com.kyanite.deeperdarker.datagen.data.loot.DDLootModifierProvider;
import com.kyanite.deeperdarker.datagen.data.loot.DDLootTableProvider;
import com.kyanite.deeperdarker.network.Messages;
import com.kyanite.deeperdarker.util.DDCreativeTab;
import com.kyanite.deeperdarker.world.DDFeatures;
import com.kyanite.deeperdarker.world.otherside.OthersideDimension;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="deeperdarker")
public class DeeperDarker {
    public static final String MOD_ID = "deeperdarker";

    public DeeperDarker() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DDCreativeTab.CREATIVE_MODE_TABS.register(eventBus);
        DDItems.ITEMS.register(eventBus);
        DDSounds.SOUND_EVENTS.register(eventBus);
        DDBlocks.BLOCKS.register(eventBus);
        DDBlockEntities.BLOCK_ENTITIES.register(eventBus);
        DDEntities.ENTITIES.register(eventBus);
        AncientPaintings.PAINTINGS.register(eventBus);
        DDEffects.EFFECTS.register(eventBus);
        DDPotions.POTIONS.register(eventBus);
        DDEnchantments.ENCHANTMENTS.register(eventBus);
        DDFeatures.FEATURES.register(eventBus);
        OthersideDimension.POI.register(eventBus);
        DDLootModifiers.LOOT_MODIFIERS.register(eventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        eventBus.addListener(DDCreativeTab::buildCreativeTab);
        eventBus.addListener(DeeperDarkerConfig::loadConfigs);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::generateData);
        eventBus.addListener(this::registerAttributes);
        eventBus.addListener(this::registerSpawnPlacements);
        Messages.registerMessages("deeperdarker_network");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DeeperDarkerConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(DDBlocks.ECHO_SAPLING.getId(), DDBlocks.POTTED_ECHO_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(DDBlocks.BLOOMING_STEM.getId(), DDBlocks.POTTED_BLOOMING_STEM);
        });
        PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)DDItems.SOUL_CRYSTAL.get()), (Potion)((Potion)DDPotions.SCULK_AFFINITY.get()));
        PotionBrewing.m_43513_((Potion)Potions.f_43605_, (Item)((Item)DDItems.SOUL_DUST.get()), (Potion)((Potion)DDPotions.SCULK_AFFINITY.get()));
        PotionBrewing.m_43513_((Potion)((Potion)DDPotions.SCULK_AFFINITY.get()), (Item)Items.f_42451_, (Potion)((Potion)DDPotions.LONG_SCULK_AFFINITY.get()));
        PotionBrewing.m_43513_((Potion)Potions.f_43606_, (Item)((Item)DDItems.SOUL_DUST.get()), (Potion)((Potion)DDPotions.LONG_SCULK_AFFINITY.get()));
    }

    private void generateData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ENLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new DDBlockStateProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new DDItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new DDSoundDefinitions(packOutput, fileHelper));
        DDBlockTagsProvider blockTags = new DDBlockTagsProvider(packOutput, event.getLookupProvider(), fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new DDItemTagsProvider(packOutput, event.getLookupProvider(), (TagsProvider<Block>)blockTags, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(packOutput, event.getLookupProvider(), fileHelper, List.of(new DDAdvancements())));
        generator.addProvider(event.includeServer(), (DataProvider)new DDRegistriesGenerator(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new DDLootTableProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new DDLootModifierProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new DDRecipeProvider(packOutput));
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DDEntities.ANGLER_FISH.get(), AnglerFish.createAttributesSupplier());
        event.put((EntityType)DDEntities.SCULK_CENTIPEDE.get(), SculkCentipede.createAttributes());
        event.put((EntityType)DDEntities.SCULK_LEECH.get(), SculkLeech.createAttributes());
        event.put((EntityType)DDEntities.SCULK_SNAPPER.get(), SculkSnapper.createAttributes());
        event.put((EntityType)DDEntities.SHATTERED.get(), Shattered.createAttributes());
        event.put((EntityType)DDEntities.SHRIEK_WORM.get(), ShriekWorm.createAttributes());
        event.put((EntityType)DDEntities.SLUDGE.get(), Sludge.createAttributes());
        event.put((EntityType)DDEntities.STALKER.get(), Stalker.createAttributes());
    }

    private void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)DDEntities.ANGLER_FISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AnglerFish::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)DDEntities.SCULK_CENTIPEDE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)DDEntities.SCULK_SNAPPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)DDEntities.SHATTERED.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)DDEntities.SLUDGE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

