/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.groups;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import oreexcavation.groups.BlockEntry;
import oreexcavation.utils.JsonHelper;

public class BlockGroups {
    public static final BlockGroups INSTANCE = new BlockGroups();
    private final Map<BlockEntry, String> staged = new HashMap<BlockEntry, String>();
    private final Set<List<BlockEntry>> groupList = new HashSet<List<BlockEntry>>();
    private final Set<BlockEntry> strictSubs = new HashSet<BlockEntry>();
    private final Map<Integer, Set<BlockEntry>> groupCache = new HashMap<Integer, Set<BlockEntry>>();

    public BlockGroups() {
        BlockGroups cxub;
    }

    public String getStage(BlockState rwub) {
        BlockGroups twub;
        Map.Entry pwub = twub.staged.entrySet().parallelStream().filter(isub -> ((BlockEntry)isub.getKey()).checkMatch(rwub)).findFirst().orElse(null);
        return pwub == null ? null : (String)pwub.getValue();
    }

    public Set<BlockEntry> getGroup(BlockState tvub) {
        BlockGroups vvub;
        int svub = Block.m_49956_((BlockState)tvub);
        Set qvub = vvub.groupCache.get(svub);
        if (qvub != null) {
            return qvub;
        }
        qvub = vvub.groupList.parallelStream().filter(usub -> usub.parallelStream().anyMatch(osub -> osub.checkMatch(tvub))).collect(HashSet::new, AbstractCollection::addAll, AbstractCollection::addAll);
        vvub.groupCache.put(svub, qvub);
        return qvub;
    }

    public boolean isStrict(@Nonnull BlockState avub) {
        BlockGroups cvub;
        return cvub.quickCheck(cvub.strictSubs, avub);
    }

    public boolean quickCheck(@Nonnull Collection<BlockEntry> uuub, @Nonnull BlockState tuub) {
        return uuub.parallelStream().anyMatch(atub -> atub.checkMatch(tuub));
    }

    public void readFromJson(JsonObject ztub) {
        BlockGroups auub;
        auub.groupCache.clear();
        auub.groupList.clear();
        for (JsonElement fuub : JsonHelper.GetArray(ztub, "blockGroups")) {
            if (fuub == null || !fuub.isJsonArray()) continue;
            ArrayList<BlockEntry> guub = new ArrayList<BlockEntry>();
            for (JsonElement huub : fuub.getAsJsonArray()) {
                BlockEntry iuub;
                if (huub == null || !huub.isJsonPrimitive() || (iuub = BlockEntry.readFromString(huub.getAsString())) == null) continue;
                guub.add(iuub);
            }
            if (guub.size() <= 0) continue;
            auub.groupList.add(guub);
        }
        auub.strictSubs.clear();
        for (JsonElement duub : JsonHelper.GetArray(ztub, "strictSubtypes")) {
            BlockEntry euub;
            if (duub == null || !duub.isJsonPrimitive() || (euub = BlockEntry.readFromString(duub.getAsString())) == null) continue;
            auub.strictSubs.add(euub);
        }
        auub.staged.clear();
        for (Map.Entry buub : JsonHelper.GetObject(ztub, "gamestages").entrySet()) {
            BlockEntry cuub;
            if (buub.getValue() == null || !((JsonElement)buub.getValue()).isJsonPrimitive() || (cuub = BlockEntry.readFromString((String)buub.getKey())) == null) continue;
            auub.staged.put(cuub, ((JsonElement)buub.getValue()).getAsString());
        }
    }

    public JsonObject getDefaultJson() {
        JsonObject ltub = new JsonObject();
        JsonArray ktub = new JsonArray();
        JsonArray jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("tag:minecraft:leaves"));
        ktub.add((JsonElement)jtub);
        jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("tag:minecraft:dirt_like"));
        ktub.add((JsonElement)jtub);
        jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("tag:minecraft:logs"));
        ktub.add((JsonElement)jtub);
        jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("tag:minecraft:flower_pots"));
        ktub.add((JsonElement)jtub);
        jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("minecraft:stone"));
        jtub.add((JsonElement)new JsonPrimitive("minecraft:infested_stone"));
        jtub.add((JsonElement)new JsonPrimitive("minecraft:granite"));
        jtub.add((JsonElement)new JsonPrimitive("minecraft:diorite"));
        jtub.add((JsonElement)new JsonPrimitive("minecraft:andesite"));
        ktub.add((JsonElement)jtub);
        jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("minecraft:cobblestone"));
        jtub.add((JsonElement)new JsonPrimitive("minecraft:infested_cobblestone"));
        ktub.add((JsonElement)jtub);
        jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("minecraft:stone_bricks"));
        jtub.add((JsonElement)new JsonPrimitive("minecraft:infested_stone_bricks"));
        ktub.add((JsonElement)jtub);
        jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("minecraft:cracked_stone_bricks"));
        jtub.add((JsonElement)new JsonPrimitive("minecraft:infested_cracked_stone_bricks"));
        ktub.add((JsonElement)jtub);
        jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("minecraft:mossy_stone_bricks"));
        jtub.add((JsonElement)new JsonPrimitive("minecraft:infested_mossy_stone_bricks"));
        ktub.add((JsonElement)jtub);
        jtub = new JsonArray();
        jtub.add((JsonElement)new JsonPrimitive("minecraft:chiseled_stone_bricks"));
        jtub.add((JsonElement)new JsonPrimitive("minecraft:infested_chiseled_stone_bricks"));
        ktub.add((JsonElement)jtub);
        ltub.add("blockGroups", (JsonElement)ktub);
        ktub = new JsonArray();
        ktub.add((JsonElement)new JsonPrimitive("tag:minecraft:crops"));
        ktub.add((JsonElement)new JsonPrimitive("minecraft:beetroots"));
        ktub.add((JsonElement)new JsonPrimitive("minecraft:carrots"));
        ktub.add((JsonElement)new JsonPrimitive("minecraft:potatoes"));
        ktub.add((JsonElement)new JsonPrimitive("minecraft:wheat"));
        ktub.add((JsonElement)new JsonPrimitive("minecraft:melon_stem"));
        ktub.add((JsonElement)new JsonPrimitive("minecraft:pumpkin_stem"));
        ltub.add("strictSubtypes", (JsonElement)ktub);
        JsonObject itub = new JsonObject();
        itub.addProperty("examplemod:example_block1", "example_stage1");
        itub.addProperty("examplemod:example_block2", "example_stage2");
        ltub.add("gamestages", (JsonElement)itub);
        return ltub;
    }
}

