/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.groups.BlockBlacklist;
import oreexcavation.groups.BlockGroups;
import oreexcavation.groups.ItemBlacklist;
import oreexcavation.overrides.ToolOverrideHandler;
import oreexcavation.shapes.ShapeRegistry;
import oreexcavation.utils.JsonHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final ForgeConfigSpec commonSpec;
    public static final ForgeConfigSpec clientSpec;
    public static final ConfigCommon COMMON;
    public static final ConfigClient CLIENT;
    private static final Pattern PATTERN_SPACE;
    private static final File FILE_OVERRIDES;
    private static final File FILE_GROUPS;

    public ConfigHandler() {
        ConfigHandler maub;
    }

    private static ForgeConfigSpec.IntValue lazyInt(ForgeConfigSpec.Builder eaub, String daub, int caub, int baub, int aaub, String zztb) {
        eaub.comment(zztb);
        eaub.translation(ConfigHandler.getLangKey(daub));
        return eaub.defineInRange(daub, caub, baub, aaub);
    }

    private static ForgeConfigSpec.DoubleValue lazyDouble(ForgeConfigSpec.Builder mztb, String lztb, double kztb, double jztb, double iztb, String hztb) {
        mztb.comment(hztb);
        mztb.translation(ConfigHandler.getLangKey(lztb));
        return mztb.defineInRange(lztb, kztb, jztb, iztb);
    }

    private static ForgeConfigSpec.BooleanValue lazyBool(ForgeConfigSpec.Builder wytb, String vytb, boolean uytb, String tytb) {
        wytb.comment(tytb);
        wytb.translation(ConfigHandler.getLangKey(vytb));
        return wytb.define(vytb, uytb);
    }

    private static ForgeConfigSpec.ConfigValue<String> lazyString(ForgeConfigSpec.Builder kytb, String jytb, String iytb, String hytb) {
        kytb.comment(hytb);
        kytb.translation(ConfigHandler.getLangKey(jytb));
        return kytb.define(jytb, (Object)iytb);
    }

    private static ForgeConfigSpec.ConfigValue<List<? extends String>> lazyList(ForgeConfigSpec.Builder yxtb, String xxtb, List<String> wxtb, String vxtb) {
        yxtb.comment(vxtb);
        yxtb.translation(ConfigHandler.getLangKey(xxtb));
        return yxtb.defineList(xxtb, wxtb, fxtb -> fxtb instanceof String);
    }

    private static String getLangKey(String pxtb) {
        return "oreexcavation".toLowerCase(Locale.ROOT) + ".config.file." + PATTERN_SPACE.matcher(pxtb.toLowerCase(Locale.ROOT)).replaceAll("_");
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading mxtb) {
        if ("oreexcavation".equalsIgnoreCase(mxtb.getConfig().getModId())) {
            if (mxtb.getConfig().getType() == ModConfig.Type.CLIENT) {
                CLIENT.apply();
            } else if (mxtb.getConfig().getType() == ModConfig.Type.COMMON) {
                COMMON.apply();
                ConfigHandler.loadJsonFiles();
            }
        }
    }

    public static void loadJsonFiles() {
        if (FILE_OVERRIDES.exists()) {
            ToolOverrideHandler.INSTANCE.loadOverrides(JsonHelper.ReadFromFile(FILE_OVERRIDES));
        } else {
            JsonObject jxtb = ToolOverrideHandler.INSTANCE.getDefaultOverrides();
            JsonHelper.WriteToFile(FILE_OVERRIDES, jxtb);
            ToolOverrideHandler.INSTANCE.loadOverrides(jxtb);
        }
        ShapeRegistry.INSTANCE.loadShapes(ShapeRegistry.FILE_SHAPES);
        if (FILE_GROUPS.exists()) {
            BlockGroups.INSTANCE.readFromJson(JsonHelper.ReadFromFile(FILE_GROUPS));
        } else {
            JsonObject ixtb = BlockGroups.INSTANCE.getDefaultJson();
            JsonHelper.WriteToFile(FILE_GROUPS, ixtb);
            BlockGroups.INSTANCE.readFromJson(ixtb);
        }
    }

    static {
        PATTERN_SPACE = Pattern.compile("\\s");
        Pair bxtb = new ForgeConfigSpec.Builder().configure(ConfigClient::new);
        clientSpec = (ForgeConfigSpec)bxtb.getRight();
        CLIENT = (ConfigClient)bxtb.getLeft();
        Pair axtb = new ForgeConfigSpec.Builder().configure(ConfigCommon::new);
        commonSpec = (ForgeConfigSpec)axtb.getRight();
        COMMON = (ConfigCommon)axtb.getLeft();
        FILE_OVERRIDES = new File("config/oreexcavation/tool_overrides.json");
        FILE_GROUPS = new File("config/oreexcavation/block_groups.json");
    }

    public static class ConfigClient {
        public final ForgeConfigSpec.IntValue mineMode;
        public final ForgeConfigSpec.BooleanValue mustHold;
        public final ForgeConfigSpec.BooleanValue useSideHit;
        public final ForgeConfigSpec.BooleanValue showOutline;
        private static int[] ub;

        private ConfigClient(ForgeConfigSpec.Builder omsb) {
            ConfigClient pmsb;
            omsb.push("client");
            pmsb.mineMode = ConfigHandler.lazyInt(omsb, "Mode", ub[0], ub[1], ub[2], "Excavation mode (-1 Disabled, 0 = Keybind, 1 = Sneak, 2 = Always)");
            pmsb.mustHold = ConfigHandler.lazyBool(omsb, "Must Hold", ub[3], "Allows players to cancel excavation by releasing the keys");
            pmsb.useSideHit = ConfigHandler.lazyBool(omsb, "Use Side Hit", ub[3], "Use the side of the block hit to determine shape mining direction");
            pmsb.showOutline = ConfigHandler.lazyBool(omsb, "Show Outline", ub[3], "Show an outline when using the shape mining function");
            omsb.pop();
        }

        public void apply() {
            ConfigClient kmsb;
            ExcavationSettings.mineMode = (Integer)kmsb.mineMode.get();
            ExcavationSettings.mustHold = (Boolean)kmsb.mustHold.get();
            ExcavationSettings.useSideHit = (Boolean)kmsb.useSideHit.get();
            ExcavationSettings.showOutline = (Boolean)kmsb.showOutline.get();
        }

        static {
            ConfigClient.fb();
        }

        private static void fb() {
            ub = new int[4];
            ConfigClient.ub[0] = 5 + 3 + 9 + 8 + 7 + 2 - 62 + 8 + 9 + 6 + 1 + 4;
            ConfigClient.ub[1] = -(3 + 4 + 0 + 7 + 3 - 43 + 8 + 3 + 6 + 8 + 2);
            ConfigClient.ub[2] = "         ".length() + (0x71 ^ 0x73) + (9 + 1 + 6 + 2 + 8 + 5 + 0 + 4 + 9 - 35) + "      ".length() - (0x38 ^ 0x27) + "       ".length();
            ConfigClient.ub[3] = " ".length();
        }
    }

    public static class ConfigCommon {
        public final ForgeConfigSpec.IntValue mineSpeed;
        public final ForgeConfigSpec.IntValue mineLimit;
        public final ForgeConfigSpec.IntValue mineRange;
        public final ForgeConfigSpec.DoubleValue exhaustion;
        public final ForgeConfigSpec.IntValue experience;
        public final ForgeConfigSpec.IntValue maxUndos;
        public final ForgeConfigSpec.BooleanValue undoReplace;
        public final ForgeConfigSpec.BooleanValue invertTBlacklist;
        public final ForgeConfigSpec.BooleanValue invertBBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> toolBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockBlacklist;
        public final ForgeConfigSpec.BooleanValue openHand;
        public final ForgeConfigSpec.BooleanValue ignoreTools;
        public final ForgeConfigSpec.BooleanValue toolClass;
        public final ForgeConfigSpec.BooleanValue altTools;
        public final ForgeConfigSpec.BooleanValue tpsGuard;
        public final ForgeConfigSpec.BooleanValue autoPickup;
        public final ForgeConfigSpec.BooleanValue allowShapes;
        public final ForgeConfigSpec.ConfigValue<String> gamestage;
        private static int[] gb;

        private ConfigCommon(ForgeConfigSpec.Builder ittb) {
            ConfigCommon jttb;
            ittb.comment("Common settings").push("common");
            jttb.mineLimit = ConfigHandler.lazyInt(ittb, "Limit", gb[0], gb[1], gb[2], "The maximum number of blocks that can be excavated at once");
            jttb.mineSpeed = ConfigHandler.lazyInt(ittb, "Speed", gb[3], gb[1], gb[2], "How many blocks per tick can be excavated");
            jttb.mineRange = ConfigHandler.lazyInt(ittb, "Range", gb[4], gb[1], gb[2], "How far from the origin an excavation can travel");
            jttb.exhaustion = ConfigHandler.lazyDouble(ittb, "Ehxaustion", 0.1, 0.0, Double.MAX_VALUE, "Amount of exhaustion per block excavated");
            jttb.experience = ConfigHandler.lazyInt(ittb, "Experience", gb[5], gb[5], gb[2], "Experience cost per block excavated");
            jttb.openHand = ConfigHandler.lazyBool(ittb, "Open Hand", gb[1], "Allow excavation with an open hand");
            jttb.invertTBlacklist = ConfigHandler.lazyBool(ittb, "Invert Tool Blacklist", gb[5], "Inverts the tool blacklist to function as a whitelist");
            jttb.invertBBlacklist = ConfigHandler.lazyBool(ittb, "Invert Block Blacklist", gb[5], "Inverts the block blacklist to function as a whitelist");
            jttb.ignoreTools = ConfigHandler.lazyBool(ittb, "Ignore Tool", gb[5], "Ignores whether or not the held tool is valid");
            jttb.altTools = ConfigHandler.lazyBool(ittb, "Alt Tools", gb[5], "Use alternate check for tool validity (e.g. swords on webs)");
            jttb.toolClass = ConfigHandler.lazyBool(ittb, "Only Standard Types", gb[5], "Limit excavation to standard tool types (Picks, Shoves, Axes & Shears)");
            jttb.tpsGuard = ConfigHandler.lazyBool(ittb, "TPS Guard", gb[1], "Temporarily reduces excavation speed if TPS begins to slow down");
            jttb.autoPickup = ConfigHandler.lazyBool(ittb, "Auto Pickup", gb[5], "Skips spawning drops in world adding them directly to your inventory");
            jttb.allowShapes = ConfigHandler.lazyBool(ittb, "Allow Shapes", gb[1], "Allow players to use shape mining");
            jttb.maxUndos = ConfigHandler.lazyInt(ittb, "Max Undos", gb[6], gb[5], gb[2], "How many excavations should be kept in undo history (may lead to exploits or instability)");
            jttb.undoReplace = ConfigHandler.lazyBool(ittb, "Undo Replaceables ", gb[1], "Allows excavation undo function to work through liquids and other replaceable blocks");
            jttb.gamestage = ConfigHandler.lazyString(ittb, "Game Stage", "", "The default game stage required to unlock excavations (requires gamestages to be installed)");
            jttb.toolBlacklist = ConfigHandler.lazyList(ittb, "Tool Blacklist", Collections.emptyList(), "Tools blacklisted from excavating");
            jttb.blockBlacklist = ConfigHandler.lazyList(ittb, "Block Blacklist", Collections.emptyList(), "Blocks blacklisted from being excavated");
            ittb.pop();
        }

        public void apply() {
            ConfigCommon ettb;
            ExcavationSettings.mineLimit = (Integer)ettb.mineLimit.get();
            ExcavationSettings.mineSpeed = (Integer)ettb.mineSpeed.get();
            ExcavationSettings.mineRange = (Integer)ettb.mineRange.get();
            ExcavationSettings.exhaustion = ((Double)ettb.exhaustion.get()).floatValue();
            ExcavationSettings.experience = (Integer)ettb.experience.get();
            ExcavationSettings.openHand = (Boolean)ettb.openHand.get();
            ExcavationSettings.invertTBlacklist = (Boolean)ettb.invertTBlacklist.get();
            ExcavationSettings.invertBBlacklist = (Boolean)ettb.invertBBlacklist.get();
            ExcavationSettings.ignoreTools = (Boolean)ettb.ignoreTools.get();
            ExcavationSettings.altTools = (Boolean)ettb.altTools.get();
            ExcavationSettings.toolClass = (Boolean)ettb.toolClass.get();
            ExcavationSettings.tpsGuard = (Boolean)ettb.tpsGuard.get();
            ExcavationSettings.autoPickup = (Boolean)ettb.autoPickup.get();
            ExcavationSettings.allowShapes = (Boolean)ettb.allowShapes.get();
            ExcavationSettings.maxUndos = (Integer)ettb.maxUndos.get();
            ExcavationSettings.undoReplace = (Boolean)ettb.undoReplace.get();
            ExcavationSettings.gamestage = (String)ettb.gamestage.get();
            BlockBlacklist.INSTANCE.loadList(((List)ettb.blockBlacklist.get()).toArray(new String[gb[5]]));
            ItemBlacklist.INSTANCE.loadList(((List)ettb.toolBlacklist.get()).toArray(new String[gb[5]]));
        }

        static {
            ConfigCommon.ib();
        }

        private static void ib() {
            gb = new int[7];
            ConfigCommon.gb[0] = "                                                                                                                                ".length();
            ConfigCommon.gb[1] = " ".length();
            ConfigCommon.gb[2] = "       ".length() + (0x94 ^ 0x91) + "       ".length() + (0x9E ^ 0x9F) + (0x64 ^ 0x65) - -(3 + 3 + 9 - -2147483580 + 2 + 7 + 4 + 3 + 4 + 0 + 3 + 8);
            ConfigCommon.gb[3] = 2 + 8 - -14 + 6 + 5 + 2 + 7 + 8 + 2 + 2 + 3 + 5 + 0;
            ConfigCommon.gb[4] = 0x92 ^ 0x82;
            ConfigCommon.gb[5] = 1 + 6 + 5 - 35 + 7 + 2 + 6 + 8;
            ConfigCommon.gb[6] = 5 + 4 + 0 + 2 + 1 + 9 - 18;
        }
    }
}

