/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.common.base.Stopwatch;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.events.EventExcavate;
import oreexcavation.events.IExcavateFilter;
import oreexcavation.groups.BlockEntry;
import oreexcavation.groups.BlockGroups;
import oreexcavation.handlers.EventHandler;
import oreexcavation.overrides.ToolOverride;
import oreexcavation.overrides.ToolOverrideDefault;
import oreexcavation.overrides.ToolOverrideHandler;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.undo.BlockHistory;
import oreexcavation.undo.ExcavateHistory;
import oreexcavation.utils.BigItemStack;
import oreexcavation.utils.ToolEffectiveCheck;
import oreexcavation.utils.XPHelper;

public class MiningAgent {
    private final Item origTool;
    public final Set<BlockPos> minedBlocks = new HashSet<BlockPos>();
    private final Set<BlockPos> checkedBlocks = new HashSet<BlockPos>();
    private final Deque<BlockPos> scheduled = new ArrayDeque<BlockPos>();
    public final ServerPlayer player;
    public final BlockPos origin;
    public final UUID playerID;
    public Direction side = Direction.SOUTH;
    public Direction facing = Direction.SOUTH;
    public ExcavateShape shape = null;
    private final ExcavateHistory history;
    public final Set<BlockEntry> blockGroup = new HashSet<BlockEntry>();
    private final Set<IExcavateFilter> filters = new HashSet<IExcavateFilter>();
    public final BlockState state;
    private final Block block;
    public ToolOverride toolProps = ToolOverrideDefault.DEFAULT;
    private final boolean strictSubs;
    public final NonNullList<BigItemStack> drops = NonNullList.m_122779_();
    public int experience = lb[0];
    public final CompoundTag auxNBT = new CompoundTag();
    private static int[] lb;

    public MiningAgent(ServerPlayer bptb, BlockPos aptb, BlockState zotb) {
        MiningAgent cptb;
        cptb.player = bptb;
        cptb.origin = aptb;
        cptb.playerID = bptb.m_20148_();
        cptb.state = zotb;
        cptb.block = zotb.m_60734_();
        cptb.history = new ExcavateHistory((ResourceKey<Level>)bptb.m_9236_().m_46472_());
        cptb.blockGroup.addAll(BlockGroups.INSTANCE.getGroup(zotb));
        cptb.strictSubs = BlockGroups.INSTANCE.isStrict(zotb);
        ItemStack yotb = bptb.m_21120_(InteractionHand.MAIN_HAND);
        Item item = cptb.origTool = yotb.m_41619_() ? null : yotb.m_41720_();
        if (!yotb.m_41619_()) {
            ToolOverride dptb = ToolOverrideHandler.INSTANCE.getOverride(yotb);
            cptb.toolProps = dptb != null ? dptb : cptb.toolProps;
        }
    }

    public UUID getPlayerID() {
        MiningAgent qotb;
        return qotb.playerID;
    }

    public void setOverride(ToolOverride lotb) {
        motb.toolProps = lotb;
    }

    public void addFilter(IExcavateFilter fotb) {
        MiningAgent gotb;
        gotb.filters.add(fotb);
    }

    public void init() {
        MiningAgent botb;
        botb.appendSurrounding(botb.origin);
    }

    public MiningAgent setShape(ExcavateShape untb, Direction tntb, Direction sntb) {
        MiningAgent vntb;
        vntb.shape = untb;
        vntb.side = tntb;
        vntb.facing = sntb;
        return vntb;
    }

    public boolean tickMiner(Stopwatch qmtb) {
        MiningAgent rmtb;
        if (rmtb.origin == null || rmtb.player == null || !rmtb.player.m_6084_() || rmtb.minedBlocks.size() >= rmtb.toolProps.getLimit() || MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Pass(rmtb, TickEvent.Phase.START))) {
            return lb[1];
        }
        int pmtb = lb[0];
        while (!(rmtb.scheduled.isEmpty() || pmtb++ >= rmtb.toolProps.getSpeed() || rmtb.minedBlocks.size() >= rmtb.toolProps.getLimit() || ExcavationSettings.tpsGuard && qmtb.elapsed(TimeUnit.MILLISECONDS) > 40L)) {
            String cntb;
            IStageData bntb;
            int tmtb;
            Item wmtb;
            BlockPos ymtb = rmtb.scheduled.poll();
            if (ymtb == null) continue;
            ItemStack xmtb = rmtb.player.m_21120_(InteractionHand.MAIN_HAND);
            Item item = wmtb = xmtb.m_41619_() ? null : xmtb.m_41720_();
            if (wmtb != rmtb.origTool || !rmtb.hasEnergy(rmtb.player)) {
                return lb[1];
            }
            if (rmtb.player.m_20275_((double)ymtb.m_123341_(), (double)ymtb.m_123342_(), (double)ymtb.m_123343_()) > (double)(rmtb.toolProps.getRange() * rmtb.toolProps.getRange())) {
                rmtb.checkedBlocks.add(ymtb);
                continue;
            }
            BlockState vmtb = rmtb.player.m_9236_().m_8055_(ymtb);
            Block umtb = vmtb.m_60734_();
            if (EventHandler.isBlockBlacklisted(vmtb) || vmtb.m_204336_(BlockTags.f_13076_)) {
                rmtb.checkedBlocks.add(ymtb);
                continue;
            }
            int n = rmtb.strictSubs ? (vmtb == rmtb.state ? lb[1] : lb[0]) : (tmtb = umtb == rmtb.block ? lb[1] : lb[0]);
            if ((tmtb = tmtb != 0 || BlockGroups.INSTANCE.quickCheck(rmtb.blockGroup, vmtb) ? lb[1] : lb[0]) == 0) continue;
            if (ExcavationSettings.gamestagesInstalled && (bntb = GameStageSaveHandler.getPlayerData((UUID)rmtb.player.m_20148_())) != null && !StringUtil.m_14408_((String)(cntb = BlockGroups.INSTANCE.getStage(vmtb))) && !bntb.hasStage(cntb)) {
                rmtb.checkedBlocks.add(ymtb);
                continue;
            }
            CompoundTag smtb = null;
            if (ExcavationSettings.maxUndos > 0) {
                rmtb.player.m_9236_().captureBlockSnapshots = lb[1];
                rmtb.player.m_9236_().capturedBlockSnapshots.clear();
                BlockEntity antb = rmtb.player.m_9236_().m_7702_(ymtb);
                if (antb != null) {
                    smtb = antb.m_187480_();
                }
            }
            if (!ExcavationSettings.ignoreTools && !ToolEffectiveCheck.canHarvestBlock((BlockGetter)rmtb.player.m_9236_(), vmtb, ymtb, (Player)rmtb.player)) {
                rmtb.checkedBlocks.add(ymtb);
                continue;
            }
            if (rmtb.player.f_8941_.m_9280_(ymtb) || rmtb.player.m_9236_().m_8055_(ymtb).m_60734_() == Blocks.f_50016_) {
                if (ExcavationSettings.maxUndos > 0) {
                    rmtb.player.m_9236_().captureBlockSnapshots = lb[0];
                    while (rmtb.player.m_9236_().capturedBlockSnapshots.size() > 0) {
                        BlockSnapshot zmtb = (BlockSnapshot)rmtb.player.m_9236_().capturedBlockSnapshots.get(lb[0]);
                        if (ymtb.equals((Object)zmtb.getPos())) {
                            rmtb.history.addRecordedBlock(new BlockHistory(zmtb, smtb));
                        } else {
                            rmtb.history.addRecordedBlock(new BlockHistory(zmtb));
                        }
                        rmtb.player.m_9236_().capturedBlockSnapshots.remove(lb[0]);
                        rmtb.player.m_9236_().markAndNotifyBlock(zmtb.getPos(), rmtb.player.m_9236_().m_6325_(zmtb.getPos().m_123341_() >> lb[2], zmtb.getPos().m_123343_() >> lb[2]), zmtb.getReplacedBlock(), zmtb.getCurrentBlock(), zmtb.getFlag(), lb[3]);
                    }
                }
                if (!rmtb.player.m_7500_()) {
                    rmtb.player.m_36324_().m_38703_(rmtb.toolProps.getExhaustion());
                    if (rmtb.toolProps.getExperience() > 0) {
                        XPHelper.addXP((Player)rmtb.player, -rmtb.toolProps.getExperience(), lb[0]);
                    }
                }
                rmtb.appendSurrounding(ymtb);
                rmtb.minedBlocks.add(ymtb);
                MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Break(rmtb, vmtb, ymtb));
            } else {
                OreExcavation.logger.warn("Block harvest failed unexpectedly.\nBlock: " + vmtb + "\nTool: " + xmtb + "\nPos: " + ymtb);
            }
            rmtb.player.m_9236_().capturedBlockSnapshots.clear();
            rmtb.player.m_9236_().captureBlockSnapshots = lb[0];
            rmtb.checkedBlocks.add(ymtb);
        }
        if (!rmtb.player.m_7500_()) {
            XPHelper.syncXP(rmtb.player);
        }
        return (rmtb.scheduled.isEmpty() || rmtb.minedBlocks.size() >= rmtb.toolProps.getLimit() || MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Pass(rmtb, TickEvent.Phase.END)) ? lb[1] : lb[0]) != 0;
    }

    private void appendSurrounding(BlockPos yltb) {
        for (int amtb = lb[0]; amtb < lb[4]; ++amtb) {
            MiningAgent zltb;
            if (amtb == lb[5]) continue;
            zltb.appendBlock(yltb.m_7918_(amtb % lb[6] - lb[1], amtb % lb[7] / lb[6] - lb[1], amtb / lb[7] - lb[1]));
        }
    }

    public void appendBlock(BlockPos rltb) {
        MiningAgent sltb;
        if (rltb == null || sltb.checkedBlocks.contains(rltb) || sltb.scheduled.contains(rltb)) {
            return;
        }
        if (sltb.origin.m_203198_((double)rltb.m_123341_(), (double)rltb.m_123342_(), (double)rltb.m_123343_()) > (double)(sltb.toolProps.getRange() * sltb.toolProps.getRange()) || !sltb.player.m_9236_().m_6857_().m_61937_(rltb) || !sltb.canDestroy((Player)sltb.player, rltb)) {
            return;
        }
        if (sltb.shape != null && !sltb.shape.isValid(sltb.origin, rltb, sltb.side, sltb.facing)) {
            return;
        }
        if (sltb.filters.parallelStream().anyMatch(litb -> {
            MiningAgent nitb;
            return !litb.canHarvest(nitb.player, nitb, rltb) ? lb[1] : lb[0];
        })) {
            return;
        }
        sltb.scheduled.add(rltb);
    }

    private boolean canDestroy(Player jltb, BlockPos iltb) {
        if (jltb.m_150110_().f_35938_) {
            return lb[1];
        }
        BlockState hltb = jltb.m_9236_().m_8055_(iltb);
        ItemStack gltb = jltb.m_21205_();
        return (!gltb.m_41619_() && hltb.m_60734_() != Blocks.f_50016_ && gltb.m_204128_(jltb.m_9236_().m_9598_().m_175515_(BuiltInRegistries.f_256975_.m_123023_()), new BlockInWorld((LevelReader)jltb.m_9236_(), iltb, lb[0])) ? lb[1] : lb[0]) != 0;
    }

    private boolean hasEnergy(ServerPlayer yktb) {
        MiningAgent zktb;
        return !(!(zktb.toolProps.getExhaustion() <= 0.0f) && yktb.m_36324_().m_38702_() <= 0 || zktb.toolProps.getExperience() > 0 && XPHelper.getPlayerXP((Player)yktb) < (long)zktb.toolProps.getExperience()) ? lb[1] : lb[0];
    }

    public void dropEverything() {
        MiningAgent sktb;
        MiningAgent rktb = EventHandler.captureAgent;
        EventHandler.captureAgent = null;
        sktb.history.setRecievedStacks((List<BigItemStack>)sktb.drops);
        sktb.history.setRecievedXP(sktb.experience);
        BlockPos qktb = ExcavationSettings.autoPickup ? sktb.player.m_20097_() : sktb.origin;
        sktb.drops.forEach(djtb -> {
            MiningAgent fjtb;
            djtb.getCombinedStacks().forEach(uitb -> {
                MiningAgent witb;
                witb.player.m_9236_().m_7967_((Entity)new ItemEntity(witb.player.m_9236_(), (double)qktb.m_123341_() + 0.5, (double)qktb.m_123342_() + 0.5, (double)qktb.m_123343_() + 0.5, uitb));
            });
        });
        if (sktb.experience > 0) {
            sktb.player.m_9236_().m_7967_((Entity)new ExperienceOrb(sktb.player.m_9236_(), (double)qktb.m_123341_(), (double)qktb.m_123342_(), (double)qktb.m_123343_(), sktb.experience));
        }
        sktb.drops.clear();
        sktb.experience = lb[0];
        EventHandler.captureAgent = rktb;
    }

    public void addItemDrop(ItemStack iktb) {
        MiningAgent jktb;
        BigItemStack hktb = jktb.drops.parallelStream().filter(ljtb -> ljtb.isItemEqual(iktb)).findFirst().orElse(null);
        if (hktb != null) {
            hktb.stackSize += iktb.m_41613_();
        } else {
            jktb.drops.add((Object)new BigItemStack(iktb));
        }
    }

    public void addExperience(int aktb) {
        bktb.experience += aktb;
    }

    public boolean hasMinedPosition(BlockPos ujtb) {
        MiningAgent vjtb;
        return vjtb.checkedBlocks.contains(ujtb);
    }

    public ExcavateHistory getHistory() {
        MiningAgent qjtb;
        return qjtb.history;
    }

    static {
        MiningAgent.lb();
    }

    private static void lb() {
        lb = new int[8];
        MiningAgent.lb[0] = 2 + 1 + 7 - 45 + 8 + 5 + 7 + 2 + 8 + 5;
        MiningAgent.lb[1] = 0x46 ^ 0x47;
        MiningAgent.lb[2] = 0x6E ^ 0x6A;
        MiningAgent.lb[3] = -(0xFFFFF9AF & 0x3E77) & "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ".length();
        MiningAgent.lb[4] = 8 + 4 - 13 + 0 + 1 + 3 + 1 + 8 + 1 + 0 + 6 + 0 + 8;
        MiningAgent.lb[5] = "             ".length();
        MiningAgent.lb[6] = 0x1C ^ 0x2B ^ "                                                    ".length();
        MiningAgent.lb[7] = 3 + 7 + 1 + 0 - 22 + 3 + 7 + 1 + 3 + 0 + 6;
    }
}

