/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.shapes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import oreexcavation.core.OreExcavation;
import oreexcavation.utils.JsonHelper;
import org.apache.logging.log4j.Level;

public class ExcavateShape {
    private String name = "New Shape";
    private int shapeMask = ob[0];
    private int maxDepth = ob[1];
    private int revDepth = ob[0];
    private byte reticle = (byte)ob[2];
    private int stride = ob[0];
    private int elev = ob[0];
    private byte[] outline = new byte[ob[0]];
    private static int[] ob;

    public ExcavateShape() {
        ExcavateShape vkub;
    }

    public byte[] getOutline() {
        ExcavateShape skub;
        return skub.outline;
    }

    public void rebuildOutline() {
        ExcavateShape gkub;
        if (gkub.shapeMask == 0) {
            gkub.outline = new byte[ob[0]];
            return;
        }
        ArrayList<Integer> fkub = new ArrayList<Integer>();
        byte ekub = (byte)(-(gkub.reticle % ob[3]));
        byte dkub = (byte)(-(gkub.reticle / ob[3]));
        int hkub = ob[0];
        while (hkub < ob[3]) {
            int ikub = ob[0];
            while (ikub < ob[3]) {
                if ((ob[4] << hkub * ob[3] + ikub & gkub.shapeMask) != 0) {
                    byte jkub = gkub.adjacentBits(ikub, hkub);
                    if ((jkub & ob[4]) != 0) {
                        fkub.add(ekub + ikub);
                        fkub.add(dkub + hkub + ob[4]);
                        fkub.add(ekub + ikub + ob[4]);
                        fkub.add(dkub + hkub + ob[4]);
                    }
                    if ((jkub & ob[5]) != 0) {
                        fkub.add(ekub + ikub + ob[4]);
                        fkub.add(dkub + hkub + ob[4]);
                        fkub.add(ekub + ikub + ob[4]);
                        fkub.add(dkub + hkub);
                    }
                    if ((jkub & ob[6]) != 0) {
                        fkub.add(ekub + ikub);
                        fkub.add(dkub + hkub);
                        fkub.add(ekub + ikub + ob[4]);
                        fkub.add(dkub + hkub);
                    }
                    if ((jkub & ob[7]) != 0) {
                        fkub.add(ekub + ikub);
                        fkub.add(dkub + hkub + ob[4]);
                        fkub.add(ekub + ikub);
                        fkub.add(dkub + hkub);
                    }
                }
                ikub = (byte)(ikub + ob[4]);
            }
            hkub = (byte)(hkub + ob[4]);
        }
        gkub.outline = new byte[fkub.size()];
        IntStream.range(ob[0], gkub.outline.length).parallel().forEach(swsb -> {
            uwsb.outline[swsb] = ((Integer)fkub.get(swsb)).byteValue();
        });
    }

    private byte adjacentBits(int qjub, int pjub) {
        ExcavateShape rjub;
        if (qjub < 0 || qjub >= ob[3] || pjub < 0 || pjub >= ob[3]) {
            return ob[0];
        }
        byte ojub = ob[0];
        if (qjub == 0 || (rjub.shapeMask & ob[4] << pjub * ob[3] + qjub - ob[4]) == 0) {
            ojub = (byte)(ojub | ob[7]);
        }
        if (qjub == ob[6] || (rjub.shapeMask & ob[4] << pjub * ob[3] + qjub + ob[4]) == 0) {
            ojub = (byte)(ojub | ob[5]);
        }
        if (pjub == 0 || (rjub.shapeMask & ob[4] << (pjub - ob[4]) * ob[3] + qjub) == 0) {
            ojub = (byte)(ojub | ob[6]);
        }
        if (pjub == ob[6] || (rjub.shapeMask & ob[4] << (pjub + ob[4]) * ob[3] + qjub) == 0) {
            ojub = (byte)(ojub | ob[4]);
        }
        return ojub;
    }

    public ExcavateShape setName(String gjub) {
        ExcavateShape hjub;
        hjub.name = gjub;
        return hjub;
    }

    public String getName() {
        ExcavateShape cjub;
        return cjub.name;
    }

    public ExcavateShape setStairStride(int xiub) {
        ExcavateShape yiub;
        yiub.stride = xiub;
        return yiub;
    }

    public ExcavateShape setStairElev(int riub) {
        ExcavateShape siub;
        siub.elev = riub;
        return siub;
    }

    public int getStairStride() {
        ExcavateShape niub;
        return niub.stride;
    }

    public int getStairElevation() {
        ExcavateShape kiub;
        return kiub.elev;
    }

    public ExcavateShape setReticle(int eiub, int diub) {
        ExcavateShape fiub;
        fiub.setReticle(diub * ob[3] + eiub);
        return fiub;
    }

    public ExcavateShape setReticle(int whub) {
        ExcavateShape xhub;
        xhub.reticle = (byte)Mth.m_14045_((int)whub, (int)ob[0], (int)ob[8]);
        xhub.rebuildOutline();
        return xhub;
    }

    public int getReticle() {
        ExcavateShape shub;
        return shub.reticle;
    }

    public ExcavateShape setMaxDepth(int nhub) {
        ExcavateShape ohub;
        ohub.maxDepth = nhub;
        return ohub;
    }

    public int getMaxDepth() {
        ExcavateShape jhub;
        return jhub.maxDepth;
    }

    public ExcavateShape setRevDepth(int ehub) {
        ExcavateShape fhub;
        fhub.revDepth = ehub;
        return fhub;
    }

    public int getRevDepth() {
        ExcavateShape kgtb;
        return kgtb.revDepth;
    }

    public int getShapeMask() {
        ExcavateShape hgtb;
        return hgtb.shapeMask;
    }

    public ExcavateShape setMask(int cgtb) {
        ExcavateShape dgtb;
        dgtb.shapeMask = cgtb;
        dgtb.rebuildOutline();
        return dgtb;
    }

    public ExcavateShape setMask(int uftb, int tftb, boolean sftb) {
        ExcavateShape vftb;
        if (uftb < 0 || uftb >= ob[3] || tftb < 0 || tftb >= ob[3]) {
            return vftb;
        }
        vftb.shapeMask = sftb ? vftb.shapeMask | ob[4] << tftb * ob[3] + uftb : vftb.shapeMask & (ob[4] << tftb * ob[3] + uftb ^ ob[1]);
        vftb.rebuildOutline();
        return vftb;
    }

    public void readFromJson(JsonObject aftb) {
        ExcavateShape bftb;
        int yetb;
        bftb.name = JsonHelper.GetString(aftb, "name", "New Shape");
        bftb.maxDepth = JsonHelper.GetNumber(aftb, "depth", ob[1]).intValue();
        bftb.revDepth = JsonHelper.GetNumber(aftb, "reverse", ob[0]).intValue();
        bftb.reticle = (byte)Mth.m_14045_((int)JsonHelper.GetNumber(aftb, "reticle", ob[2]).byteValue(), (int)ob[0], (int)ob[8]);
        bftb.stride = JsonHelper.GetNumber(aftb, "stride", ob[0]).intValue();
        bftb.elev = JsonHelper.GetNumber(aftb, "elevation", ob[0]).intValue();
        bftb.shapeMask = ob[0];
        JsonArray zetb = JsonHelper.GetArray(aftb, "mask");
        for (int cftb = yetb = Math.min(zetb.size(), ob[3]) - ob[4]; cftb >= 0; --cftb) {
            JsonElement fftb = zetb.get(yetb - cftb);
            if (fftb == null || !fftb.isJsonPrimitive()) continue;
            String eftb = fftb.getAsString();
            int dftb = cftb;
            IntStream.range(ob[0], Math.min(ob[3], eftb.length())).forEach(exsb -> {
                char dxsb = eftb.charAt(exsb);
                if (dxsb == ob[23] || dxsb == ob[24]) {
                    hxsb.shapeMask |= ob[4] << dftb * ob[3] + exsb;
                }
            });
        }
        bftb.rebuildOutline();
    }

    public JsonObject writeToJson(JsonObject ietb) {
        ExcavateShape jetb;
        ietb.addProperty("name", jetb.name);
        ietb.addProperty("depth", (Number)jetb.maxDepth);
        ietb.addProperty("reverse", (Number)jetb.revDepth);
        ietb.addProperty("reticle", (Number)jetb.reticle);
        ietb.addProperty("stride", (Number)jetb.stride);
        ietb.addProperty("elevation", (Number)jetb.elev);
        JsonArray hetb = new JsonArray();
        StringBuilder getb = new StringBuilder(ob[3]);
        for (int ketb = ob[8]; ketb >= 0; --ketb) {
            getb.append((jetb.shapeMask & ob[4] << ketb) != 0 ? "X" : "O");
            if (ketb % ob[3] != 0) continue;
            hetb.add((JsonElement)new JsonPrimitive(getb.toString()));
            getb.setLength(ob[0]);
        }
        ietb.add("mask", (JsonElement)hetb);
        return ietb;
    }

    public void readFromNBT(CompoundTag xdtb) {
        ydtb.name = xdtb.m_128461_("name");
        ydtb.shapeMask = xdtb.m_128451_("mask");
        ydtb.maxDepth = xdtb.m_128451_("depth");
        ydtb.revDepth = xdtb.m_128451_("reverse");
        ydtb.reticle = xdtb.m_128445_("reticle");
        ydtb.stride = xdtb.m_128451_("stride");
        ydtb.elev = xdtb.m_128451_("elev");
    }

    public CompoundTag writeToNBT(CompoundTag rdtb) {
        ExcavateShape sdtb;
        rdtb.m_128359_("name", sdtb.name);
        rdtb.m_128405_("mask", sdtb.shapeMask);
        rdtb.m_128405_("depth", sdtb.maxDepth);
        rdtb.m_128405_("reverse", sdtb.revDepth);
        rdtb.m_128344_("reticle", sdtb.reticle);
        rdtb.m_128405_("stride", sdtb.stride);
        rdtb.m_128405_("elev", sdtb.elev);
        return rdtb;
    }

    public boolean isValid(BlockPos gdtb, BlockPos fdtb, Direction edtb, Direction ddtb) {
        int bdtb;
        ExcavateShape hdtb;
        int[] nArray = new int[ob[9]];
        nArray[ExcavateShape.ob[0]] = fdtb.m_123341_() - gdtb.m_123341_();
        nArray[ExcavateShape.ob[4]] = fdtb.m_123342_() - gdtb.m_123342_();
        nArray[ExcavateShape.ob[5]] = fdtb.m_123343_() - gdtb.m_123343_();
        int[] cdtb = nArray;
        if (edtb.m_122434_().m_122478_()) {
            ExcavateShape.rotateFacing(cdtb, ddtb);
        }
        ExcavateShape.rotateSide(cdtb, edtb);
        int n = ob[0];
        cdtb[n] = cdtb[n] + hdtb.reticle % ob[3];
        int n2 = ob[4];
        cdtb[n2] = cdtb[n2] + hdtb.reticle / ob[3];
        int n3 = bdtb = hdtb.stride <= 0 || hdtb.elev == 0 ? ob[0] : cdtb[ob[5]] / hdtb.stride * hdtb.elev;
        if (cdtb[ob[0]] < 0 || cdtb[ob[0]] >= ob[3] || cdtb[ob[4]] - bdtb < 0 || cdtb[ob[4]] - bdtb >= ob[3] || hdtb.revDepth >= 0 && cdtb[ob[5]] < -hdtb.revDepth || hdtb.maxDepth >= 0 && cdtb[ob[5]] >= hdtb.maxDepth) {
            return ob[0];
        }
        return (hdtb.shapeMask & ob[4] << (cdtb[ob[4]] - bdtb) * ob[3] + cdtb[ob[0]]) != 0 ? ob[4] : ob[0];
    }

    private static void rotateFacing(int[] pctb, Direction octb) {
        int nctb = pctb[ob[0]];
        int mctb = pctb[ob[5]];
        switch (1.$SwitchMap$net$minecraft$core$Direction[octb.ordinal()]) {
            case 1: {
                pctb[ExcavateShape.ob[0]] = mctb;
                pctb[ExcavateShape.ob[5]] = -nctb;
                break;
            }
            case 2: {
                pctb[ExcavateShape.ob[0]] = -nctb;
                pctb[ExcavateShape.ob[5]] = -mctb;
                break;
            }
            case 3: {
                pctb[ExcavateShape.ob[0]] = -mctb;
                pctb[ExcavateShape.ob[5]] = nctb;
                break;
            }
        }
    }

    private static void rotateSide(int[] cctb, Direction bctb) {
        int actb = cctb[ob[0]];
        int zbtb = cctb[ob[4]];
        int ybtb = cctb[ob[5]];
        switch (1.$SwitchMap$net$minecraft$core$Direction[bctb.ordinal()]) {
            case 5: {
                cctb[ExcavateShape.ob[0]] = -actb;
                cctb[ExcavateShape.ob[4]] = -ybtb;
                cctb[ExcavateShape.ob[5]] = -zbtb;
                break;
            }
            case 1: {
                cctb[ExcavateShape.ob[0]] = -ybtb;
                cctb[ExcavateShape.ob[5]] = actb;
                break;
            }
            case 4: {
                cctb[ExcavateShape.ob[0]] = -actb;
                cctb[ExcavateShape.ob[5]] = -ybtb;
                break;
            }
            case 6: {
                cctb[ExcavateShape.ob[0]] = -actb;
                cctb[ExcavateShape.ob[4]] = ybtb;
                cctb[ExcavateShape.ob[5]] = zbtb;
                break;
            }
            case 3: {
                cctb[ExcavateShape.ob[0]] = ybtb;
                cctb[ExcavateShape.ob[5]] = -actb;
                break;
            }
        }
    }

    public static int posToMask(int qbtb, int pbtb) {
        return ob[4] << pbtb * ob[3] + qbtb;
    }

    public static Direction getFacing(Player yatb, BlockState xatb, BlockPos watb) {
        Object vatb;
        try {
            double ebtb = Math.sqrt(yatb.m_20275_((double)watb.m_123341_() + 0.5, (double)watb.m_123342_() + 0.5, (double)watb.m_123343_() + 0.5));
            VoxelShape dbtb = xatb.m_60812_((BlockGetter)yatb.m_9236_(), watb);
            Vec3 cbtb = yatb.m_20299_(1.0f);
            Vec3 bbtb = cbtb.m_82549_(yatb.m_20154_().m_82490_(ebtb + 1.0));
            dbtb = dbtb.m_83216_((double)watb.m_123341_(), (double)watb.m_123342_(), (double)watb.m_123343_());
            BlockHitResult abtb = dbtb.m_83220_(cbtb, bbtb, watb);
        }
        catch (Exception zatb) {
            OreExcavation.logger.log(Level.INFO, "Unable to get excavation direction for player " + yatb.m_7755_(), (Throwable)zatb);
            vatb = null;
        }
        return vatb == null ? ExcavateShape.getFacing(yatb) : vatb.m_82434_().m_122424_();
    }

    public static Direction getFacing(Player jatb) {
        Vec3 iatb = jatb.m_20154_();
        double hatb = Math.abs(iatb.f_82480_);
        if (hatb > Math.abs(iatb.f_82479_) && hatb > Math.abs(iatb.f_82481_)) {
            return iatb.f_82480_ > 0.0 ? Direction.UP : Direction.DOWN;
        }
        return jatb.m_6350_();
    }

    public String writeShareCode() {
        ExcavateShape batb;
        StringBuilder aatb = new StringBuilder();
        ExcavateShape.writeVarInt(batb.shapeMask, aatb);
        ExcavateShape.writeVarInt(batb.reticle, aatb);
        ExcavateShape.writeVarInt(batb.maxDepth, aatb);
        ExcavateShape.writeVarInt(batb.revDepth, aatb);
        ExcavateShape.writeVarInt(batb.stride, aatb);
        ExcavateShape.writeVarInt(batb.elev, aatb);
        return aatb.toString();
    }

    public void readShareCode(@Nonnull String ozsb) {
        CharIterator nzsb = new CharIterator(ozsb);
        try {
            ExcavateShape pzsb;
            int[] rzsb = new int[ob[10]];
            for (int szsb = ob[0]; szsb < ob[10]; ++szsb) {
                rzsb[szsb] = ExcavateShape.readVarInt(nzsb);
            }
            pzsb.setMask(rzsb[ob[0]]);
            pzsb.setReticle(rzsb[ob[4]]);
            pzsb.setMaxDepth(rzsb[ob[5]]);
            pzsb.setRevDepth(rzsb[ob[9]]);
            pzsb.setStairStride(rzsb[ob[6]]);
            pzsb.setStairElev(rzsb[ob[3]]);
        }
        catch (Exception qzsb) {
            OreExcavation.logger.error("Unable to read share code!", (Throwable)qzsb);
        }
    }

    public static boolean validateShareCode(@Nonnull String czsb) {
        CharIterator bzsb = new CharIterator(czsb);
        try {
            for (int ezsb = ob[0]; ezsb < ob[10]; ++ezsb) {
                ExcavateShape.readVarInt(bzsb);
            }
            return ob[4];
        }
        catch (Exception dzsb) {
            return ob[0];
        }
    }

    private static void writeVarInt(int sysb, StringBuilder rysb) {
        int qysb = sysb >> ob[11] ^ sysb << ob[4];
        do {
            byte tysb = (byte)(qysb & ob[12]);
            if ((qysb >>>= ob[13]) != 0) {
                tysb = (byte)(tysb | ob[14]);
            }
            Object[] objectArray = new Object[ob[4]];
            objectArray[ExcavateShape.ob[0]] = tysb;
            rysb.append(String.format("%02X", objectArray));
        } while (qysb != 0);
    }

    private static int readVarInt(CharIterator hysb) throws EOFException {
        int fysb;
        int gysb = ob[0];
        int eysb = ob[0];
        do {
            if ((fysb = ExcavateShape.read(hysb)) < 0) {
                throw new EOFException();
            }
            gysb |= (fysb & ob[12]) << eysb;
            eysb += 7;
        } while ((fysb & ob[14]) != 0);
        return gysb >>> ob[4] ^ -(gysb & ob[4]);
    }

    private static int read(CharIterator txsb) {
        try {
            int wxsb = ExcavateShape.hexChar(txsb.next());
            int vxsb = ExcavateShape.hexChar(txsb.next());
            if ((wxsb | vxsb) < 0) {
                return ob[1];
            }
            return (wxsb << ob[6] | vxsb) & ob[15];
        }
        catch (NoSuchElementException uxsb) {
            return ob[1];
        }
    }

    private static int hexChar(char oxsb) {
        if (oxsb >= ob[16] && oxsb <= ob[17]) {
            return oxsb - ob[16];
        }
        if (oxsb >= ob[18] && oxsb <= ob[19]) {
            return oxsb - ob[18] + ob[20];
        }
        if (oxsb >= ob[21] && oxsb < ob[22]) {
            return oxsb - ob[21] + ob[20];
        }
        return ob[1];
    }

    static {
        ExcavateShape.kb();
    }

    private static void kb() {
        ob = new int[25];
        ExcavateShape.ob[0] = 0x8E ^ 0x8E;
        ExcavateShape.ob[1] = -(0x8F ^ 0x85 ^ "           ".length());
        ExcavateShape.ob[2] = "            ".length();
        ExcavateShape.ob[3] = (0x3A ^ 0x3E) + (1 + 6 + 0 + 0 + 4 - 4) + (9 + 3 + 8 + 7 + 6 + 7 + 6 + 8 + 2 - 51) + (0x2E ^ 0x2A) - (0x70 ^ 0x7F);
        ExcavateShape.ob[4] = " ".length();
        ExcavateShape.ob[5] = 0 + 7 + 7 - 42 + 8 + 2 + 0 + 1 + 0 + 4 + 8 + 7;
        ExcavateShape.ob[6] = 5 + 0 + 5 - 27 + 3 + 6 + 4 + 5 + 3;
        ExcavateShape.ob[7] = 0x3D ^ 0x1F ^ (0x74 ^ 0x5E);
        ExcavateShape.ob[8] = 3 + 4 + 0 + 8 + 4 + 0 + 8 + 8 + 2 + 3 + 4 + 4 - 39 + (6 + 0 + 5 - 11 + 5) + (0x6E ^ 0x6E) + (6 + 3 + 9 - 55 + 7 + 9 + 5 + 9 + 8 + 1) - -(0x94 ^ 0x9C);
        ExcavateShape.ob[9] = "   ".length();
        ExcavateShape.ob[10] = 1 + 6 + 8 - -102 ^ "                                                                                                                   ".length();
        ExcavateShape.ob[11] = "                                                                                                   ".length() ^ (0x7F ^ 3);
        ExcavateShape.ob[12] = 8 + 3 + 8 + 1 + 5 - -96 + 6;
        ExcavateShape.ob[13] = "       ".length();
        ExcavateShape.ob[14] = "                                                                                                                                ".length();
        ExcavateShape.ob[15] = 9 + 1 + 6 + 4 - -235;
        ExcavateShape.ob[16] = "                                                ".length();
        ExcavateShape.ob[17] = 9 + 5 + 7 + 3 + 5 + 7 + 8 - 47 + 4 + 0 + (2 + 5 + 4 + 8 + 6 + 5 + 1 - 29) + (0x97 ^ 0x92) + (6 + 7 + 0 - 10) + (0x27 ^ 0x23) + "      ".length() + (2 + 5 + 7 + 9 + 5 + 1 + 2 + 9 + 9 + 2 + 0 - 46) + (3 + 5 + 3 + 4 + 7 + 5 + 3 + 9 - 33) + (0x63 & ~99) + (7 + 1 + 5 + 8 + 7 + 1 + 0 + 8 + 9 + 4 - 41) - -(0x27 ^ 0x37);
        ExcavateShape.ob[18] = 5 + 5 + 3 - -52;
        ExcavateShape.ob[19] = "                                                                                          ".length();
        ExcavateShape.ob[20] = 4 + 1 + 3 + 2;
        ExcavateShape.ob[21] = "         ".length() + (2 + 8 + 3 + 1 + 2 + 2 + 8 + 9 + 1 - 34) + (7 + 3 + 5 + 3 + 6 - 42 + 7 + 6 + 5) + "      ".length() + "       ".length() + " ".length() - -(0xF6 ^ 0xBE);
        ExcavateShape.ob[22] = (0x86 ^ 0x82) + (2 + 8 + 3 + 0 + 0 + 6 - 23 + 7 + 4) + " ".length() + (3 + 3 + 8 - 40 + 3 + 5 + 2 + 6 + 7 + 3 + 1) + "       ".length() + (0x1F ^ 0x1E) - -"                                                                                                     ".length();
        ExcavateShape.ob[23] = "                                                                                        ".length();
        ExcavateShape.ob[24] = "                                                                                                                        ".length();
    }

    private static class CharIterator {
        private final String str;
        private final int last;
        private int idx = z[0];
        private static int[] z;

        private CharIterator(String flub) {
            CharIterator glub;
            glub.str = flub;
            glub.last = flub.length() - z[1];
        }

        public boolean hasNext() {
            CharIterator blub;
            return blub.idx <= blub.last ? z[1] : z[0];
        }

        public char next() throws NoSuchElementException {
            CharIterator ykub;
            if (!ykub.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = ykub.idx;
            ykub.idx = n + z[1];
            return ykub.str.charAt(n);
        }

        static {
            CharIterator.m();
        }

        private static void m() {
            z = new int[2];
            CharIterator.z[0] = "".length();
            CharIterator.z[1] = 8 + 1 - 37 + 9 + 3 + 8 + 9;
        }
    }
}

