/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import oreexcavation.core.OreExcavation;

public class JsonHelper {
    private static final Gson GSON;
    private static int[] k;

    public JsonHelper() {
        JsonHelper wlwb;
    }

    public static JsonArray GetArray(@Nonnull JsonObject ykwb, @Nonnull String skwb) {
        JsonElement nkwb = ykwb.get(skwb);
        return nkwb instanceof JsonArray ? nkwb.getAsJsonArray() : new JsonArray();
    }

    public static JsonObject GetObject(@Nonnull JsonObject ojwb, @Nonnull String jjwb) {
        JsonElement djwb = ojwb.get(jjwb);
        return djwb instanceof JsonObject ? djwb.getAsJsonObject() : new JsonObject();
    }

    public static String GetString(@Nonnull JsonObject mhwb, @Nonnull String khwb, @Nonnull String hhwb) {
        JsonElement ehwb = mhwb.get(khwb);
        return ehwb instanceof JsonPrimitive && ehwb.getAsJsonPrimitive().isString() ? ehwb.getAsString() : hhwb;
    }

    public static Number GetNumber(@Nonnull JsonObject afwb, @Nonnull String tewb, @Nonnull Number oewb) {
        JsonElement iewb = afwb.get(tewb);
        try {
            return iewb instanceof JsonPrimitive ? (Number)iewb.getAsNumber() : (Number)oewb;
        }
        catch (Exception gfwb) {
            return oewb;
        }
    }

    public static boolean GetBoolean(@Nonnull JsonObject rbwb, @Nonnull String obwb, boolean jbwb) {
        JsonElement dbwb = rbwb.get(obwb);
        try {
            return dbwb instanceof JsonPrimitive ? dbwb.getAsBoolean() : jbwb;
        }
        catch (Exception ybwb) {
            return jbwb;
        }
    }

    public static JsonElement getElement(@Nonnull JsonObject hzvb, @Nonnull String czvb, @Nonnull Supplier<JsonElement> wyvb) {
        JsonElement iwvb = hzvb.get(czvb);
        return iwvb != null ? iwvb : wyvb.get();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JsonObject ReadFromFile(File upvb) {
        if (upvb == null || !upvb.exists()) {
            return new JsonObject();
        }
        try (FileInputStream zpvb = new FileInputStream(upvb);){
            try (InputStreamReader bqvb = new InputStreamReader((InputStream)zpvb, StandardCharsets.UTF_8);){
                JsonObject jpvb = (JsonObject)GSON.fromJson((Reader)bqvb, JsonObject.class);
            }
            return jpvb;
        }
        catch (IOException xpvb) {
            OreExcavation.logger.error("An error occured while loading JSON from file:", (Throwable)xpvb);
            JsonHelper.createBackup(upvb, "malformed");
            return new JsonObject();
        }
    }

    public static void WriteToFile(File jmvb, JsonObject fmvb) {
        File bmvb = new File(jmvb.getAbsolutePath() + ".tmp");
        try {
            if (bmvb.exists()) {
                if (!bmvb.delete()) {
                    throw new IOException("Unable to delete old temp file!");
                }
            } else if (bmvb.getParentFile() != null && !bmvb.getParentFile().exists() && !bmvb.getParentFile().mkdirs()) {
                throw new IOException("Unable to create parent directory!");
            }
        }
        catch (IOException snvb) {
            OreExcavation.logger.error("An error occured while writing JSON to file (Directory Setup): " + snvb);
            return;
        }
        try (FileOutputStream mnvb = new FileOutputStream(bmvb);
             OutputStreamWriter onvb = new OutputStreamWriter((OutputStream)mnvb, StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)fmvb, (Appendable)onvb);
            onvb.flush();
        }
        catch (IOException hnvb) {
            OreExcavation.logger.error("An error occured while writing JSON to file (File Write): " + hnvb);
            return;
        }
        try (FileInputStream zmvb = new FileInputStream(bmvb);
             InputStreamReader dnvb = new InputStreamReader((InputStream)zmvb, StandardCharsets.UTF_8);){
            GSON.fromJson((Reader)dnvb, fmvb.getClass());
        }
        catch (IOException tmvb) {
            OreExcavation.logger.error("An error occured while writing JSON to file (Validation Check): " + tmvb);
            return;
        }
        try {
            if (jmvb.exists() && !jmvb.delete()) {
                throw new IOException("Failed to delete old file!");
            }
            if (!bmvb.renameTo(jmvb)) {
                throw new IOException("Failed to rename temp file!");
            }
        }
        catch (IOException pmvb) {
            OreExcavation.logger.error("An error occured while writing JSON to file (Temp Copy): " + pmvb);
        }
    }

    public static void createBackup(File djvb, String zivb) {
        String vivb = zivb + "_" + djvb.getName();
        String rivb = JsonHelper.getExtension(djvb);
        String oivb = djvb.getParent();
        File kivb = new File(oivb, vivb + rivb);
        int fivb = k[0];
        while (kivb.exists()) {
            kivb = new File(oivb, vivb + "_" + fivb++ + rivb);
        }
        try {
            JsonHelper.copyTo(djvb, kivb);
            OreExcavation.logger.info("Backup created at: " + kivb.getAbsolutePath());
        }
        catch (IOException ijvb) {
            OreExcavation.logger.error("Unable to create backup! Data loss likely!", (Throwable)ijvb);
        }
    }

    public static void copyTo(File zgvb, File xgvb) throws IOException {
        if (!zgvb.exists()) {
            return;
        }
        if (xgvb.getParentFile() != null && !xgvb.getParentFile().mkdirs()) {
            throw new IOException("Failed to create parent directory!");
        }
        CopyOption[] copyOptionArray = new CopyOption[k[1]];
        copyOptionArray[JsonHelper.k[0]] = StandardCopyOption.REPLACE_EXISTING;
        Files.copy(zgvb.toPath(), xgvb.toPath(), copyOptionArray);
    }

    public static String getExtension(File lgvb) {
        String jgvb = lgvb.getAbsolutePath();
        int hgvb = jgvb.lastIndexOf(k[2]);
        return hgvb >= 0 ? jgvb.substring(hgvb) : "";
    }

    static {
        JsonHelper.b();
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    private static void b() {
        k = new int[3];
        JsonHelper.k[0] = 0x19 ^ 0x19 ^ "".length();
        JsonHelper.k[1] = 0x9C ^ 0xA1 ^ (0x8D ^ 0xB1);
        JsonHelper.k[2] = "                                              ".length();
    }
}

