/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.IRecipeProcessingBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.container.BreedingChamberContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BreedingChamberBlockEntity
extends CapabilityBlockEntity
implements UpgradeableBlockEntity,
IRecipeProcessingBlockEntity {
    public int recipeProgress = 0;
    public int recipeLookupCooldown = 0;
    public boolean isRunning = false;
    private List<BeeBreedingRecipe> currentBreedingRecipes = new ArrayList<BeeBreedingRecipe>();
    public BeeBreedingRecipe chosenRecipe;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.BlockEntityItemStackHandler(6, this){

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return slot != 5 && (slot == 3 || slot == 4) && !(item.m_41720_() instanceof BeeCage) || slot == 0 && item.m_41720_() instanceof BeeCage && !BeeCage.isFilled(item) || (slot == 1 || slot == 2) && item.m_41720_() instanceof BeeCage && BeeCage.isFilled(item);
        }

        public boolean isInputSlot(int slot) {
            return slot != 5;
        }

        public int[] getOutputSlots() {
            return new int[]{5};
        }

        protected void onContentsChanged(int slot) {
            BlockEntity blockEntity;
            super.onContentsChanged(slot);
            if ((slot == 1 || slot == 2) && (blockEntity = this.blockEntity) instanceof BreedingChamberBlockEntity) {
                BreedingChamberBlockEntity breedingChamberBlockEntity = (BreedingChamberBlockEntity)blockEntity;
                breedingChamberBlockEntity.reset();
                breedingChamberBlockEntity.setRecipe(null);
            }
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this));
    protected LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(10000));

    public BreedingChamberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BREEDING_CHAMBER.get(), pos, state);
    }

    private void reset() {
        this.recipeProgress = 0;
        this.currentBreedingRecipes = new ArrayList<BeeBreedingRecipe>();
        this.setRunning(false);
        this.m_6596_();
    }

    private void setRunning(boolean running) {
        this.isRunning = running;
    }

    private void setRecipe(BeeBreedingRecipe recipe) {
        this.chosenRecipe = recipe;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public TimedRecipeInterface getCurrentRecipe() {
        return this.chosenRecipe;
    }

    @Override
    public int getRecipeProgress() {
        return this.recipeProgress;
    }

    @Override
    public int getProcessingTime(TimedRecipeInterface recipe) {
        return (int)((double)(recipe != null ? recipe.getProcessingTime() : 6000) * this.getProcessingTimeModifier());
    }

    protected double getProcessingTimeModifier() {
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(0.0, timeUpgradeModifier);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BreedingChamberBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (blockEntity.isRunning) {
                blockEntity.energyHandler.ifPresent(handler -> handler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.breedingChamberPowerUse.get()).intValue() * blockEntity.getEnergyConsumptionModifier()), false));
            }
            blockEntity.inventoryHandler.ifPresent(invHandler -> {
                if (!invHandler.getStackInSlot(1).m_41619_() && !invHandler.getStackInSlot(2).m_41619_()) {
                    if (blockEntity.currentBreedingRecipes.isEmpty() && ++blockEntity.recipeLookupCooldown > 0) {
                        ItemStack cage1 = invHandler.getStackInSlot(1);
                        ItemStack cage2 = invHandler.getStackInSlot(2);
                        if (!cage1.m_41619_() && !cage2.m_41619_()) {
                            BeeHelper.IdentifierInventory beeInv = new BeeHelper.IdentifierInventory(BeeCage.getBeeType(cage1), BeeCage.getBeeType(cage2));
                            blockEntity.currentBreedingRecipes = BeeHelper.getBreedingRecipes(beeInv, serverLevel);
                            if (blockEntity.currentBreedingRecipes.size() > 0 && !blockEntity.currentBreedingRecipes.contains(blockEntity.chosenRecipe)) {
                                blockEntity.setRecipe(blockEntity.currentBreedingRecipes.get(level.f_46441_.m_188503_(blockEntity.currentBreedingRecipes.size())));
                            }
                            blockEntity.recipeLookupCooldown = -20;
                        }
                    }
                    if (blockEntity.isRunning || !blockEntity.currentBreedingRecipes.isEmpty() && blockEntity.canProcessInput((IItemHandlerModifiable)invHandler, true)) {
                        blockEntity.setRunning(true);
                        int totalTime = blockEntity.getProcessingTime(blockEntity.chosenRecipe);
                        if (blockEntity.recipeProgress == 0) {
                            ItemStack cage1 = invHandler.getStackInSlot(1);
                            ItemStack cage2 = invHandler.getStackInSlot(2);
                            CompoundTag bee1Data = BeeReloadListener.INSTANCE.getData(BeeCage.getBeeType(cage1));
                            CompoundTag bee2Data = BeeReloadListener.INSTANCE.getData(BeeCage.getBeeType(cage2));
                            invHandler.getStackInSlot(3).m_41774_(bee1Data != null ? bee1Data.m_128451_("breedingItemCount") : 1);
                            invHandler.getStackInSlot(4).m_41774_(bee2Data != null ? bee2Data.m_128451_("breedingItemCount") : 1);
                        }
                        if (++blockEntity.recipeProgress >= totalTime && blockEntity.completeBreeding((IItemHandlerModifiable)invHandler)) {
                            blockEntity.reset();
                        }
                        blockEntity.recipeProgress = Math.min(blockEntity.recipeProgress, totalTime);
                    }
                } else {
                    blockEntity.reset();
                }
            });
        }
    }

    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(1.0, timeUpgradeModifier);
    }

    private boolean canProcessInput(IItemHandlerModifiable invHandler, boolean firstRun) {
        boolean bee2IsBaby;
        int energy = this.energyHandler.map(IEnergyStorage::getEnergyStored).orElse(0);
        ItemStack cage1 = invHandler.getStackInSlot(1);
        ItemStack cage2 = invHandler.getStackInSlot(2);
        CompoundTag bee1Data = BeeReloadListener.INSTANCE.getData(BeeCage.getBeeType(cage1));
        CompoundTag bee2Data = BeeReloadListener.INSTANCE.getData(BeeCage.getBeeType(cage2));
        boolean bee1IsBaby = BeeCage.isFilled(cage1) && cage1.m_41783_().m_128441_("Age") && cage1.m_41783_().m_128451_("Age") < 0;
        boolean bl = bee2IsBaby = BeeCage.isFilled(cage2) && cage2.m_41783_().m_128441_("Age") && cage2.m_41783_().m_128451_("Age") < 0;
        if (bee1IsBaby || bee2IsBaby) {
            return false;
        }
        Ingredient breedingIngredient1 = Ingredient.m_204132_((TagKey)ItemTags.f_13149_);
        int breedingCount1 = 1;
        Ingredient breedingIngredient2 = Ingredient.m_204132_((TagKey)ItemTags.f_13149_);
        int breedingCount2 = 1;
        if (bee1Data != null) {
            breedingIngredient1 = ConfigurableBee.getBreedingIngredientFromString(bee1Data.m_128461_("breedingItem"));
            breedingCount1 = bee1Data.m_128451_("breedingItemCount");
        }
        if (bee2Data != null) {
            breedingIngredient2 = ConfigurableBee.getBreedingIngredientFromString(bee2Data.m_128461_("breedingItem"));
            breedingCount2 = bee2Data.m_128451_("breedingItemCount");
        }
        ItemStack breedingItem1 = invHandler.getStackInSlot(3);
        ItemStack breedingItem2 = invHandler.getStackInSlot(4);
        return energy > (Integer)ProductiveBeesConfig.GENERAL.incubatorPowerUse.get() && (!firstRun || breedingIngredient1.test(breedingItem1) && breedingCount1 <= breedingItem1.m_41613_() && breedingIngredient2.test(breedingItem2) && breedingCount2 <= breedingItem2.m_41613_());
    }

    private boolean completeBreeding(IItemHandlerModifiable invHandler) {
        BeeIngredient beeIngredient;
        Entity offspring;
        if (this.f_58857_ != null && this.chosenRecipe != null && invHandler.getStackInSlot(5).m_41619_() && invHandler.getStackInSlot(0).m_41720_() instanceof BeeCage && this.canProcessInput(invHandler, false) && (offspring = (beeIngredient = (BeeIngredient)this.chosenRecipe.offspring.get()).getBeeEntity().m_20615_(this.f_58857_)) instanceof Bee) {
            Bee bee = (Bee)offspring;
            if (bee instanceof ConfigurableBee) {
                ((ConfigurableBee)bee).setBeeType(beeIngredient.getBeeType().toString());
                ((ConfigurableBee)bee).setDefaultAttributes();
            }
            Bee bee1 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(1), this.f_58857_, true);
            if (bee instanceof ProductiveBee && bee1 instanceof ProductiveBee) {
                Bee bee2 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(2), this.f_58857_, true);
                BeeHelper.setOffspringAttributes((ProductiveBee)bee, (ProductiveBee)bee1, (AgeableMob)bee2);
            }
            bee.m_146762_(-24000);
            ItemStack cage = invHandler.getStackInSlot(0);
            ItemStack newCage = new ItemStack((ItemLike)cage.m_41720_());
            BeeCage.captureEntity(bee, newCage);
            cage.m_41774_(1);
            invHandler.setStackInSlot(5, newCage);
            return true;
        }
        return false;
    }

    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        Object t;
        Optional recipe;
        super.loadPacketNBT(tag);
        if (tag.m_128441_("ChosenRecipe") && this.f_58857_ != null && (recipe = this.f_58857_.m_7465_().m_44043_(new ResourceLocation(tag.m_128461_("ChosenRecipe")))).isPresent() && (t = recipe.get()) instanceof BeeBreedingRecipe) {
            BeeBreedingRecipe breedingRecipe = (BeeBreedingRecipe)t;
            this.setRecipe(breedingRecipe);
        }
        this.recipeProgress = tag.m_128451_("RecipeProgress");
        this.isRunning = tag.m_128441_("IsRunning") && tag.m_128471_("IsRunning");
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        if (this.chosenRecipe != null) {
            tag.m_128359_("ChosenRecipe", this.chosenRecipe.m_6423_().toString());
        }
        tag.m_128405_("RecipeProgress", this.recipeProgress);
        tag.m_128379_("IsRunning", this.isRunning);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public Component m_7755_() {
        return Component.m_237115_((String)((Block)ModBlocks.BREEDING_CHAMBER.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new BreedingChamberContainer(windowId, playerInventory, this);
    }
}

