/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.container.CryoStasisContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;

public class CryoStasisBlockEntity
extends CapabilityBlockEntity {
    List<BeeEntry> cryoBees = new ArrayList<BeeEntry>();
    public static int SLOT_INPUT = 0;
    public static int SLOT_CAGE = 1;
    public static int SLOT_OUT = 2;
    private final LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.BlockEntityItemStackHandler(3, this){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < SLOT_OUT && stack.m_41720_().m_5456_() instanceof BeeCage && (slot != SLOT_INPUT || BeeCage.isFilled(stack));
        }

        public boolean isContainerItem(Item item) {
            return item instanceof BeeCage;
        }

        public boolean isInputSlot(int slot) {
            return slot == SLOT_INPUT;
        }
    });

    public CryoStasisBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CRYO_STASIS.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        ListTag listNBT = new ListTag();
        this.cryoBees.forEach(beeEntry -> listNBT.add((Object)beeEntry.serializeNBT()));
        tag.m_128365_("BeeList", (Tag)listNBT);
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        if (tag.m_128441_("BeeList")) {
            ListTag listNBT = tag.m_128437_("BeeList", 10);
            listNBT.forEach(beeTag -> this.cryoBees.add(BeeEntry.fromNbt((CompoundTag)beeTag)));
        }
    }

    public static <E extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, CryoStasisBlockEntity blockEntity) {
        blockEntity.inventoryHandler.ifPresent(inv -> {
            Bee entity;
            ItemStack input = inv.getStackInSlot(SLOT_INPUT);
            if (!input.m_41619_() && BeeCage.isFilled(input) && (entity = BeeCage.getEntityFromStack(input.m_41783_(), level, true)) != null) {
                if (entity instanceof ProductiveBee) {
                    ProductiveBee pBee = (ProductiveBee)entity;
                    blockEntity.cryoBees.add(new BeeEntry(new ResourceLocation(pBee.getBeeType()), true, 1200, pBee.getAttributeValue(BeeAttributes.PRODUCTIVITY), pBee.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE), pBee.getAttributeValue(BeeAttributes.BEHAVIOR), pBee.getAttributeValue(BeeAttributes.ENDURANCE), pBee.getAttributeValue(BeeAttributes.TEMPER)));
                } else {
                    blockEntity.cryoBees.add(new BeeEntry(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()), false, 1200, 0, 0, 0, 0, 0));
                }
                input.m_41774_(1);
            }
        });
    }

    public Component m_7755_() {
        return Component.m_237115_((String)((Block)ModBlocks.CRYO_STASIS.get()).m_7705_());
    }

    public AbstractContainerMenu m_7208_(int index, Inventory inventory, Player player) {
        return new CryoStasisContainer(index, inventory, this);
    }

    static final class BeeEntry
    implements INBTSerializable<CompoundTag> {
        private final ResourceLocation id;
        private final Boolean isProductive;
        private final Integer cooldown;
        private final Integer productivity;
        private final Integer weatherTolerance;
        private final Integer behavior;
        private final Integer endurance;
        private final Integer temper;

        BeeEntry(ResourceLocation id, boolean isProductive, Integer cooldown, Integer productivity, Integer weatherTolerance, Integer behavior, Integer endurance, Integer temper) {
            this.id = id;
            this.isProductive = isProductive;
            this.cooldown = cooldown;
            this.productivity = productivity;
            this.weatherTolerance = weatherTolerance;
            this.behavior = behavior;
            this.endurance = endurance;
            this.temper = temper;
        }

        public static BeeEntry fromNbt(CompoundTag tag) {
            return new BeeEntry(new ResourceLocation(tag.m_128461_("id")), tag.m_128471_("isProductive"), tag.m_128451_("cooldown"), tag.m_128451_("productivity"), tag.m_128451_("weatherTolerance"), tag.m_128451_("behavior"), tag.m_128451_("endurance"), tag.m_128451_("temper"));
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("id", this.id.toString());
            tag.m_128379_("isProductive", this.isProductive.booleanValue());
            tag.m_128405_("cooldown", this.cooldown.intValue());
            tag.m_128405_("productivity", this.productivity.intValue());
            tag.m_128405_("weatherTolerance", this.weatherTolerance.intValue());
            tag.m_128405_("behavior", this.behavior.intValue());
            tag.m_128405_("endurance", this.endurance.intValue());
            tag.m_128405_("temper", this.temper.intValue());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
        }

        public ResourceLocation id() {
            return this.id;
        }

        public Integer cooldown() {
            return this.cooldown;
        }

        public Integer productivity() {
            return this.productivity;
        }

        public Integer weatherTolerance() {
            return this.weatherTolerance;
        }

        public Integer behavior() {
            return this.behavior;
        }

        public Integer endurance() {
            return this.endurance;
        }

        public Integer temper() {
            return this.temper;
        }
    }
}

